/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContextFactory;
import oracle.eclipse.tools.adf.dtrt.context.typed.IObjectLocatorContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public final class PageDefinitionMarkerManager {
    private static final String MARKER_TYPE = "oracle.eclipse.tools.adf.dtrt.pageDefinitionMarker";
    private static final String SOURCE_ID = "PageDefinitionMarkerManager";
    private static final String OBJECT_URI_ATTR = "oracle.eclipse.tools.adf.dtrt.ObjectURI";
    private static final String IDE_EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    private static final String DEFAULT_PAGEDEF_EDITOR_ID = "oracle.eclipse.tools.adf.view.ui.bind.editors.PageDefinitionEditor";
    private ResourceChangeListener resourceChangeListener;
    private ExecutorService threadPool;
    private String preferredEditorId;

    public static URI getObjectURI(IMarker marker) {
        if (marker != null && marker.exists()) {
            try {
                if (marker.isSubtypeOf(MARKER_TYPE)) {
                    Object uri = marker.getAttribute(OBJECT_URI_ATTR);
                    if (uri instanceof String) {
                        return URI.create((String)uri);
                    }
                    if (uri instanceof URI) {
                        return (URI)uri;
                    }
                }
            }
            catch (Exception e) {
                DTRTUIBundle.log(e);
            }
        }
        return null;
    }

    public static void validateWorkspace() {
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PageDefinitionFileWorkspaceCollector collector = new PageDefinitionFileWorkspaceCollector();
                collector.loadPageDefinitionFiles();
                if (!collector.isEmpty()) {
                    new PageDefinitionValidator(collector, PageDefinitionMarkerManager.DEFAULT_PAGEDEF_EDITOR_ID, monitor).run();
                }
            }
        };
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    if (pm != null) {
                        pm.setTaskName(Messages.validationProgressMessage);
                    }
                    ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, ProgressMonitorUtil.submon((IProgressMonitor)pm, (int)100));
                }
                catch (CoreException e) {
                    DTRTUIBundle.log(e);
                }
            }
        };
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getProgressService().run(false, false, runnableWithProgress);
            } else {
                runnableWithProgress.run(null);
            }
        }
        catch (InvocationTargetException e) {
            DTRTUIBundle.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static boolean isValidDelta(IResourceDelta delta, boolean checkFlags) {
        return delta != null && delta.getKind() != 0 && delta.getResource() != null && !delta.getResource().isDerived() && (!checkFlags || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x4000) != 0 || (delta.getFlags() & 0x40000) != 0);
    }

    private static List<IMarker> getMarkers(IFile file) {
        if (file != null && file.isAccessible()) {
            try {
                IMarker[] markers = file.findMarkers(MARKER_TYPE, false, 0);
                ArrayList<IMarker> currentMarkers = new ArrayList<IMarker>(markers.length);
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (SOURCE_ID.equals(marker.getAttribute("sourceId"))) {
                        currentMarkers.add(marker);
                    }
                    ++n2;
                }
                return currentMarkers;
            }
            catch (Exception e) {
                DTRTUIBundle.log(e);
            }
        }
        return new ArrayList<IMarker>(0);
    }

    private static void setMarkerAttributes(IMarker marker, ValidationSummary summary, String preferredEditorId) throws CoreException {
        marker.setAttribute("sourceId", (Object)SOURCE_ID);
        marker.setAttribute("severity", summary.markerSeverity);
        marker.setAttribute("message", (Object)summary.status.getMessage());
        marker.setAttribute("location", (Object)summary.location);
        marker.setAttribute(OBJECT_URI_ATTR, (Object)summary.uriString);
        if (preferredEditorId != null) {
            marker.setAttribute(IDE_EDITOR_ID_ATTR, (Object)preferredEditorId);
        }
    }

    private static boolean matches(IMarker marker, ValidationSummary summary, String preferredEditorId) {
        try {
            return marker.exists() && DTRTUtil.equals((Object)SOURCE_ID, (Object)marker.getAttribute("sourceId")) && summary.markerSeverity == marker.getAttribute("severity", -1) && DTRTUtil.equals((Object)summary.status.getMessage(), (Object)marker.getAttribute("message")) && DTRTUtil.equals((Object)summary.location, (Object)marker.getAttribute("location")) && DTRTUtil.equals((Object)summary.uriString, (Object)marker.getAttribute(OBJECT_URI_ATTR)) && DTRTUtil.equals((Object)preferredEditorId, (Object)marker.getAttribute(IDE_EDITOR_ID_ATTR));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setPreferredEditorId(String preferredEditorId) {
        this.preferredEditorId = preferredEditorId;
    }

    public String getPreferredEditorId() {
        return this.preferredEditorId;
    }

    public void startMonitoring() {
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new ResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
            if (this.threadPool == null) {
                ThreadFactory threadFactory = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                this.threadPool = Executors.newFixedThreadPool(20, threadFactory);
            }
        }
    }

    public boolean isMonitoring() {
        return this.resourceChangeListener != null;
    }

    public void stopMonitoring() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
            this.resourceChangeListener = null;
            this.threadPool.shutdown();
        }
    }

    public static void clearAllMarkers() {
        try {
            for (IMarker marker : PageDefinitionMarkerManager.getAllMarkers()) {
                marker.delete();
            }
        }
        catch (CoreException e) {
            DTRTUIBundle.log(e);
        }
    }

    private static List<IMarker> getAllMarkers() throws CoreException {
        return Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().findMarkers(MARKER_TYPE, false, 2));
    }

    private static abstract class AbstractPageDefinitionFileCollector
    implements Iterable<IFile> {
        protected final Collection<IFile> files = new HashSet<IFile>();
        protected final Map<IProject, IObjectLocatorContext> contextMap = new HashMap<IProject, IObjectLocatorContext>();
        protected final Map<IFile, List<IMarker>> markerMap = new HashMap<IFile, List<IMarker>>();

        private AbstractPageDefinitionFileCollector() {
        }

        public void dispose() {
            if (this.contextMap != null) {
                for (IObjectLocatorContext context : this.contextMap.values()) {
                    context.dispose();
                }
                this.contextMap.clear();
            }
            if (this.markerMap != null) {
                this.markerMap.clear();
            }
            this.files.clear();
        }

        public boolean isEmpty() {
            return this.files.isEmpty();
        }

        @Override
        public Iterator<IFile> iterator() {
            return this.files.iterator();
        }

        public IObjectLocatorContext getContext(IFile file) {
            return this.contextMap != null ? this.contextMap.get(file.getProject()) : null;
        }

        public List<IMarker> getCurrentMarkers(IFile file) {
            return this.markerMap != null ? this.markerMap.get(file) : null;
        }

        protected boolean loadPageDefinition(IFile file) {
            IProject project = file.getProject();
            IObjectLocatorContext context = this.contextMap.get(project);
            if (context == null) {
                try {
                    context = (IObjectLocatorContext)DTRTUtil.createContext((IResource)project, IObjectLocatorContext.class);
                    if (context != null) {
                        context.initialize(null);
                        this.contextMap.put(project, context);
                        IPageDefinition pageDefinition = context.getPageDefinition(DTRTUtil.getEARProject((IResource)file), file);
                        if (pageDefinition != null) {
                            this.files.add(file);
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                }
            }
            return false;
        }

        public int getSize() {
            return this.files.size();
        }
    }

    private static class MarkerHandler
    extends Job {
        private IFile file;
        private List<IMarker> currentMarkers;
        private Collection<ValidationSummary> summaries;
        private String preferredEditorId;
        private String family;

        public MarkerHandler(IFile file, List<IMarker> currentMarkers, Collection<ValidationSummary> summaries, String preferredEditorId) {
            super("PageDefinition-MarkerHandler");
            this.file = file;
            this.currentMarkers = currentMarkers;
            this.summaries = summaries;
            this.preferredEditorId = preferredEditorId;
            this.family = String.valueOf(this.getName()) + file.getFullPath();
            this.setRule((ISchedulingRule)file);
        }

        public boolean belongsTo(Object family) {
            return this.family.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.file.isAccessible()) {
                try {
                    ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(this.currentMarkers.size() + this.summaries.size()));
                    for (IMarker marker : this.currentMarkers) {
                        marker.delete();
                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    }
                    for (ValidationSummary summary : this.summaries) {
                        if (summary.markerSeverity != 0) {
                            IMarker marker = this.file.createMarker(PageDefinitionMarkerManager.MARKER_TYPE);
                            PageDefinitionMarkerManager.setMarkerAttributes(marker, summary, this.preferredEditorId);
                        }
                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    }
                    IJobManager manager = Job.getJobManager();
                    manager.cancel((Object)this.family);
                    ProgressMonitorUtil.done((IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                    return DTRTUtil.createErrorStatus((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class Messages
    extends NLS {
        public static String binding;
        public static String executable;
        public static String iteratorBinding;
        public static String validationProgressMessage;

        static {
            NLS.initializeMessages((String)PageDefinitionMarkerManager.class.getName(), Messages.class);
        }

        private Messages() {
        }

        public static String getLocation(IObject object, String label) {
            return object instanceof IIteratorBinding ? NLS.bind((String)iteratorBinding, (Object)label) : (object instanceof IExecutable ? NLS.bind((String)executable, (Object)label) : (object instanceof IBinding ? NLS.bind((String)binding, (Object)label) : null));
        }
    }

    private static final class PageDefinitionFileCollector
    extends AbstractPageDefinitionFileCollector
    implements IResourceDeltaVisitor {
        private PageDefinitionFileCollector() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.isAccessible()) {
                assert (DTRTUtil.isWebProject((IProject)resource.getProject())) : resource.getFullPath();
                if (resource instanceof IContainer) {
                    return true;
                }
                if (resource instanceof IFile && PageDefinitionMarkerManager.isValidDelta(delta, true) && DTRTContentType.PAGE_DEFINITION.appliesTo((IFile)resource)) {
                    this.initializePageDefinition((IFile)resource);
                }
            }
            return false;
        }

        private void initializePageDefinition(IFile file) {
            List markers;
            if (!this.loadPageDefinition(file) && !(markers = PageDefinitionMarkerManager.getMarkers(file)).isEmpty()) {
                this.markerMap.put(file, markers);
                this.files.add(file);
            }
        }
    }

    private static final class PageDefinitionFileWorkspaceCollector
    extends AbstractPageDefinitionFileCollector {
        private PageDefinitionFileWorkspaceCollector() {
        }

        private void initializePageDefinition(IFile file) {
            if (!this.loadPageDefinition(file)) {
                List markers = PageDefinitionMarkerManager.getMarkers(file);
                this.markerMap.put(file, markers);
                this.files.add(file);
            }
        }

        public void loadPageDefinitionFiles() {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IObjectLocatorContext context;
                Project project;
                IOEPEContextFactory contextFactory;
                IProject iProject = iProjectArray[n2];
                if (DTRTUtil.isWebProject((IProject)iProject) && (contextFactory = (IOEPEContextFactory)(project = (Project)iProject.getAdapter(Project.class)).getAppService(IOEPEContextFactory.class)) != null && (context = (IObjectLocatorContext)contextFactory.createContext(IObjectLocatorContext.class)) != null) {
                    try {
                        context.initialize(null);
                        for (IPageDefinition pageDefinition : context.getPageDefinitions(DTRTUtil.getEARProject((IResource)iProject), (IContainer)iProject)) {
                            this.initializePageDefinition(context.getAccessibleFile((IObject)pageDefinition));
                        }
                    }
                    catch (Exception e) {
                        DTRTUIBundle.log(e);
                    }
                }
                ++n2;
            }
        }
    }

    private static class PageDefinitionValidator
    implements Runnable {
        private AbstractPageDefinitionFileCollector collector;
        private String preferredEditorId;
        private IProgressMonitor monitor;

        public PageDefinitionValidator(AbstractPageDefinitionFileCollector collector, String preferredEditorId, IProgressMonitor monitor) {
            this.collector = collector;
            this.preferredEditorId = preferredEditorId;
            this.monitor = monitor;
        }

        @Override
        public void run() {
            int i = 0;
            int total = this.collector.getSize() + 1;
            for (IFile file : this.collector) {
                IPageDefinition pageDefinition;
                this.monitor.subTask("Validating: " + file.getName());
                List currentMarkers = this.collector.getCurrentMarkers(file);
                IObjectLocatorContext context = this.collector.getContext(file);
                if (context == null) {
                    pageDefinition = null;
                } else {
                    pageDefinition = context.getPageDefinition(DTRTUtil.getEARProject((IResource)file), file);
                    if (currentMarkers == null) {
                        currentMarkers = PageDefinitionMarkerManager.getMarkers(file);
                    }
                }
                try {
                    this.handleMarkers(context, file, pageDefinition, currentMarkers, null);
                    this.monitor.worked(++i / total * 100);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                }
            }
            this.collector.dispose();
        }

        private void handleMarkers(IObjectLocatorContext context, IFile file, IPageDefinition pageDefinition, List<IMarker> currentMarkers, IProgressMonitor monitor) throws Exception {
            Map validationMap;
            try {
                validationMap = DTRTObjectUtil.validateBindingObjects((IOEPEContext)context, (IPageDefinition)pageDefinition, (IProgressMonitor)monitor);
            }
            catch (Exception exception) {
                validationMap = Collections.emptyMap();
            }
            ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
            if (!currentMarkers.isEmpty() || !validationMap.isEmpty()) {
                List<ValidationSummary> summaries = ValidationSummary.toSummaries(validationMap);
                int s = summaries.size() - 1;
                while (s >= 0) {
                    ValidationSummary summary = summaries.get(s);
                    boolean removed = false;
                    int m = currentMarkers.size() - 1;
                    while (m >= 0) {
                        IMarker marker = currentMarkers.get(m);
                        if (PageDefinitionMarkerManager.matches(marker, summary, this.preferredEditorId)) {
                            currentMarkers.remove(m);
                            removed = true;
                        }
                        --m;
                    }
                    if (removed) {
                        summaries.remove(s);
                    }
                    --s;
                }
                if (!currentMarkers.isEmpty() || !summaries.isEmpty()) {
                    MarkerHandler validator = new MarkerHandler(file, currentMarkers, summaries, this.preferredEditorId);
                    validator.schedule(250L);
                }
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResourceDelta rootDelta = event.getDelta();
            if (PageDefinitionMarkerManager.isValidDelta(rootDelta, false)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PageDefinitionFileCollector collector = new PageDefinitionFileCollector();
                        IResource resource = rootDelta.getResource();
                        if (resource instanceof IWorkspaceRoot) {
                            IResourceDelta[] iResourceDeltaArray = rootDelta.getAffectedChildren();
                            int n = iResourceDeltaArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResourceDelta delta = iResourceDeltaArray[n2];
                                ResourceChangeListener.this.visit(delta, collector);
                                ++n2;
                            }
                        } else {
                            ResourceChangeListener.this.visit(rootDelta, collector);
                        }
                        if (!collector.isEmpty()) {
                            new PageDefinitionValidator(collector, PageDefinitionMarkerManager.this.getPreferredEditorId(), (IProgressMonitor)new NullProgressMonitor()).run();
                        }
                    }
                };
                if (PageDefinitionMarkerManager.this.isMonitoring()) {
                    PageDefinitionMarkerManager.this.threadPool.execute(runnable);
                }
            }
        }

        private void visit(IResourceDelta delta, IResourceDeltaVisitor visitor) {
            IResource resource = delta.getResource();
            if (DTRTUtil.isWebProject((IProject)resource.getProject())) {
                try {
                    delta.accept(visitor, 5);
                }
                catch (CoreException e) {
                    DTRTUIBundle.log(e);
                }
            }
        }
    }

    private static class ValidationSummary {
        public String location;
        public String uriString;
        public IStatus status;
        public int markerSeverity;

        public static List<ValidationSummary> toSummaries(Map<IObject, IStatus> validationMap) {
            ArrayList<ValidationSummary> summaries = new ArrayList<ValidationSummary>(validationMap.size());
            for (Map.Entry<IObject, IStatus> entry : validationMap.entrySet()) {
                ValidationSummary summary = ValidationSummary.create(entry.getKey(), entry.getValue());
                if (summary == null) continue;
                summaries.add(summary);
            }
            return summaries;
        }

        private static ValidationSummary create(IObject object, IStatus status) {
            URI uri;
            String location;
            String label;
            if (object != null && status != null && (status.getSeverity() == 2 || status.getSeverity() == 4) && (label = DTRTUtil.getLabel((IDescribable)object)) != null && (location = Messages.getLocation(object, label)) != null && (uri = object.getURI()) != null) {
                return new ValidationSummary(location, uri, status);
            }
            return null;
        }

        private ValidationSummary(String location, URI uri, IStatus status) {
            this.location = location;
            this.uriString = uri.toString();
            this.status = status;
            this.markerSeverity = status.getSeverity() == 4 ? 2 : (status.getSeverity() == 2 ? 1 : 0);
        }
    }
}

