/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DescribableResource;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class OpenableResource
extends DescribableResource
implements IOpenable {
    private String editorId;
    private ImageManager.IImageData editorImageData;
    private ISelection selection;
    private String typeLabel;

    public OpenableResource(IFile file) {
        super((IResource)file);
    }

    public OpenableResource(IFile file, ISelection selection) {
        super((IResource)file);
        this.selection = selection;
    }

    public void dispose() {
        this.selection = null;
        this.editorImageData = null;
        super.dispose();
    }

    @Override
    public boolean canOpen() {
        return this.getDecoratedObject() != null && ((IResource)this.getDecoratedObject()).isAccessible();
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
        this.editorImageData = null;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    @Override
    public String getTypeLabel() {
        return this.typeLabel;
    }

    protected ImageManager.IImageData getImageData() {
        if (this.getEditorId() != null) {
            if (this.editorImageData == null) {
                try {
                    ImageManager.IImageData imageData;
                    ImageDescriptor imageDescriptor;
                    IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(this.getEditorId());
                    if (editorDescriptor != null && (imageDescriptor = editorDescriptor.getImageDescriptor()) != null && (imageData = ImageManager.getInstance().getImageData((Object)imageDescriptor.createImage())) != null) {
                        this.editorImageData = imageData;
                    }
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                }
            }
            if (this.editorImageData != null) {
                return this.editorImageData;
            }
        }
        return super.getImageData();
    }

    @Override
    public IEditorPart openEditor() throws CoreException {
        if (this.getDecoratedObject() instanceof IFile) {
            IEditorPart editorPart = DTRTUIUtil.openEditor((IFile)this.getDecoratedObject(), this.getEditorId());
            if (editorPart != null && this.selection != null) {
                editorPart.getSite().getSelectionProvider().setSelection(this.selection);
            }
            return editorPart;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        return adapter == ImageManager.IImageData.class ? this.getImageData() : (adapter == IResource.class ? (IResource)this.getDecoratedObject() : (adapter == IFile.class && this.getDecoratedObject() instanceof IFile ? (IResource)this.getDecoratedObject() : null));
    }

    public final int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getEditorId() == null ? 0 : this.getEditorId().hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && DTRTUtil.equals((Object)this.getEditorId(), (Object)((OpenableResource)obj).getEditorId());
    }
}

