/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.UndoableOperationDecorator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public final class DTRTUIUtil {
    private static final GridDataFactory GDF_GRAB_HORIZONTAL = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false);
    private static final GridDataFactory GDF_GRAB_ALL = GridDataFactory.fillDefaults().grab(true, true);
    private static IHyperlinkListener openableHyperlinkListener;
    public static final IAction SEPARATOR_ACTION;

    static {
        SEPARATOR_ACTION = new Action(){};
    }

    private DTRTUIUtil() {
    }

    public static GridData applyGrabHorizontallyGridData(Control control) {
        GDF_GRAB_HORIZONTAL.applyTo(control);
        return (GridData)control.getLayoutData();
    }

    public static GridData applyGrabAllGridData(Control control) {
        GDF_GRAB_ALL.applyTo(control);
        return (GridData)control.getLayoutData();
    }

    public static Object getFirstElement(ISelection selection) {
        return selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() ? ((IStructuredSelection)selection).getFirstElement() : null;
    }

    public static IObject getObject(ISelection selection) {
        IDescribable describable;
        Object o = DTRTUIUtil.getFirstElement(selection);
        if (o instanceof IObject) {
            return (IObject)o;
        }
        if (o instanceof DescribableTreeElement && (describable = ((DescribableTreeElement)o).getDescribable()) instanceof IObject) {
            return (IObject)describable;
        }
        return null;
    }

    public static ISelection toNotNullSelection(SelectionChangedEvent event) {
        return event == null ? StructuredSelection.EMPTY : DTRTUIUtil.toNotNullSelection(event.getSelection());
    }

    public static ISelection toNotNullSelection(ISelection selection) {
        return selection == null ? StructuredSelection.EMPTY : selection;
    }

    public static ImageDescriptor getImageDescriptor(ImageManager.IImageData imageData) {
        return ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage(imageData));
    }

    public static Image getImage(ImageManager.IImageData imageData) {
        return (Image)ImageManager.getInstance().getImage(imageData);
    }

    public static Image getImage(IDescribable describable) {
        return describable != null ? DTRTUIUtil.getImage(describable.getDescriptor()) : null;
    }

    public static Image getImage(IDescriptor descriptor) {
        return (Image)DTRTUtil.getImage((IDescriptor)descriptor);
    }

    public static Combo createCombo(FormToolkit toolkit, Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        toolkit.adapt((Control)combo, true, true);
        return combo;
    }

    public static Color getSectionLabelColor(FormToolkit toolkit) {
        return toolkit == null ? null : toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
    }

    public static Label createSectionLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label;
        if (toolkit != null) {
            label = toolkit.createLabel(parent, text);
            label.setForeground(DTRTUIUtil.getSectionLabelColor(toolkit));
        } else {
            label = new Label(parent, 0);
            label.setText(text);
        }
        return label;
    }

    public static Text createTextRow(FormToolkit toolkit, Composite parent, String label, int style) {
        Text text;
        DTRTUIUtil.createSectionLabel(toolkit, parent, label);
        if (toolkit != null) {
            int borderStyle = toolkit.getBorderStyle();
            if ((style & 8) != 0) {
                toolkit.setBorderStyle(0);
            }
            text = toolkit.createText(parent, null, style);
            if ((style & 8) != 0) {
                toolkit.setBorderStyle(borderStyle);
            }
        } else {
            text = new Text(parent, 2048);
        }
        if (parent.getLayout() instanceof GridLayout) {
            DTRTUIUtil.applyGrabHorizontallyGridData((Control)text);
        }
        return text;
    }

    public static int getFontHeight(Control control) {
        if (control != null && !control.isDisposed()) {
            try {
                GC gc = new GC((Drawable)control);
                FontMetrics fontMetrics = gc.getFontMetrics();
                int height = fontMetrics != null ? fontMetrics.getHeight() : -1;
                gc.dispose();
                if (height > -1) {
                    return height;
                }
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static FormText createFormText(FormToolkit toolkit, Composite parent, int style) {
        if ((style & 8) == 0) {
            style |= 0x800;
        }
        FormText formText = new FormText(parent, style);
        formText.marginWidth = 1;
        formText.marginHeight = 0;
        formText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        toolkit.adapt((Control)formText, true, true);
        formText.setMenu(parent.getMenu());
        return formText;
    }

    public static void setDefaultHyperlinkSettings(FormToolkit toolkit) {
        if (toolkit != null) {
            HyperlinkGroup hyperlinkGroup = toolkit.getHyperlinkGroup();
            hyperlinkGroup.setForeground(DTRTUIUtil.getColor(toolkit, 0, 102, 204));
            hyperlinkGroup.setHyperlinkUnderlineMode(2);
        }
    }

    public static Color getColor(FormToolkit toolkit, int red, int green, int blue) {
        if (toolkit != null) {
            String key = "rgb:" + red + '/' + green + '/' + blue;
            FormColors colors = toolkit.getColors();
            Color color = colors.getColor(key);
            if (color == null) {
                color = colors.createColor(key, new RGB(red, green, blue));
            }
            return color;
        }
        return null;
    }

    public static Font createItalicFont(Font font) {
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 2);
            ++i;
        }
        return new Font(font.getDevice(), fontData);
    }

    public static IContributionItem renderAction(Object parent, IAction action) {
        if (parent != null && action != null) {
            Separator contributionItem;
            Object object = contributionItem = action == SEPARATOR_ACTION ? new Separator() : new ActionContributionItem(action);
            if (parent instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)parent;
                contributionItem.fill(toolBar, toolBar.getItemCount());
            } else if (parent instanceof Menu) {
                Menu menu = (Menu)parent;
                contributionItem.fill(menu, menu.getItemCount());
            } else if (parent instanceof IContributionManager) {
                ((IContributionManager)parent).add((IContributionItem)contributionItem);
            } else {
                contributionItem = null;
            }
            return contributionItem;
        }
        return null;
    }

    public static void setVisible(Object parent, IContributionItem contributionItem, int contributionItemIndex, boolean visible) {
        if (parent != null && contributionItem != null && contributionItem.isVisible() != visible) {
            contributionItem.setVisible(visible);
            if (parent instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)parent;
                if (visible) {
                    contributionItem.fill(toolBar, contributionItemIndex);
                } else {
                    ToolItem[] items = toolBar.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (i == contributionItemIndex) {
                            items[i].dispose();
                            break;
                        }
                        ++i;
                    }
                }
                toolBar.pack(true);
                DTRTUIUtil.controlChanged((Control)toolBar);
            } else if (parent instanceof Menu) {
                Menu menu = (Menu)parent;
                if (visible) {
                    contributionItem.fill(menu, contributionItemIndex);
                } else {
                    MenuItem[] items = menu.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (i == contributionItemIndex) {
                            items[i].dispose();
                        }
                        ++i;
                    }
                }
            } else if (parent instanceof IContributionManager) {
                ((IContributionManager)parent).update(true);
            }
        }
    }

    public static void executeWithProgressMonitorDialog(final Shell shell, final ICommandStack commandStack) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    commandStack.execute(monitor);
                }
                catch (Exception e) {
                    DTRTUIUtil.handleError(shell, e);
                }
            }
        };
        DTRTUIUtil.runWithProgressMonitorDialog(shell, runnable);
    }

    public static void runWithProgressMonitorDialog(Shell shell, IRunnableWithProgress runnable) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(false, false, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target == null) {
                target = e.getCause();
            }
            DTRTUIUtil.handleError(shell, target != null ? target : e);
        }
    }

    public static void handleError(Shell shell, Throwable throwable) {
        if (throwable != null) {
            if ((throwable instanceof ExecutionException || throwable instanceof InterruptedException || throwable instanceof WrappedException) && throwable.getCause() != null) {
                DTRTUIUtil.handleError(shell, throwable.getCause());
            }
            DTRTUIBundle.log(throwable);
            if (shell != null && !shell.isDisposed()) {
                Diagnostic diagnostic = BasicDiagnostic.toDiagnostic((Throwable)throwable);
                DiagnosticDialog.open((Shell)shell, null, null, (Diagnostic)diagnostic);
            }
        }
    }

    public static Shell getPlatformShell() {
        try {
            IWorkbenchPage page;
            Shell shell;
            IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbench != null && (shell = DTRTUIUtil.getShell((page = workbench.getActivePage()).getActivePart())) != null) {
                return shell;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null && (shell = display.getActiveShell()) != null) {
                return shell;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Shell getShell(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        if (part != null && Display.getCurrent() != null && (site = part.getSite()) != null) {
            return site.getShell();
        }
        return null;
    }

    public static boolean toExecutedUndoableOperation(Shell shell, final IOperationHistory operationHistory, IUndoContext undoContext, ICommand command) {
        if (operationHistory != null && undoContext != null && DTRTUtil.isNotDisposed((ICommand)command)) {
            if (command.canExecute().isOK()) {
                UndoableOperationDecorator undoableOperation = new UndoableOperationDecorator(command);
                undoableOperation.addContext(undoContext);
                IRunnableWithProgress runnable = new IRunnableWithProgress((IUndoableOperation)undoableOperation){
                    private final /* synthetic */ IUndoableOperation val$undoableOperation;
                    {
                        this.val$undoableOperation = iUndoableOperation;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            operationHistory.execute(this.val$undoableOperation, monitor, null);
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof InterruptedException) {
                                throw (InterruptedException)e.getCause();
                            }
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                DTRTUIUtil.runWithProgressMonitorDialog(shell, runnable);
                return true;
            }
            if (command.getLastOperation() == ICommand.CommandOperation.EXECUTION && command.canUndo().isOK()) {
                UndoableOperationDecorator undoableOperation = new UndoableOperationDecorator(command);
                undoableOperation.addContext(undoContext);
                operationHistory.add((IUndoableOperation)undoableOperation);
                return true;
            }
        }
        return false;
    }

    public static Composite controlChanged(Control control) {
        if (control != null && !control.isDisposed()) {
            Composite parent = control.getParent();
            while (parent != null && !(parent instanceof SharedScrolledComposite) && !(parent instanceof Shell)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                parent.layout(true, true);
                return parent;
            }
        }
        return null;
    }

    public static boolean isAncestor(Control ancestor, Control control) {
        if (ancestor != null && !ancestor.isDisposed() && control != null && !control.isDisposed()) {
            Control aux = control;
            while (aux != null) {
                if (ancestor == aux) {
                    return true;
                }
                aux = aux.getParent();
            }
        }
        return false;
    }

    public static void runAction(IAction action, Event event) {
        if (action != null && action.isEnabled()) {
            if (event == null) {
                action.run();
            } else {
                action.runWithEvent(event);
            }
        }
    }

    public static IEditorPart openEditor(IFile file) throws CoreException {
        return DTRTUIUtil.openEditor(file, null, -1, -1);
    }

    public static IEditorPart openEditor(IFile file, int selectionStart, int selectionEnd) throws CoreException {
        return DTRTUIUtil.openEditor(file, null, selectionStart, selectionEnd);
    }

    public static IEditorPart openEditor(IFile file, String editorId) throws CoreException {
        return DTRTUIUtil.openEditor(file, editorId, "org.eclipse.core.resources.textmarker", -1, -1);
    }

    public static IEditorPart openEditor(IFile file, String editorId, int selectionStart, int selectionEnd) throws CoreException {
        return DTRTUIUtil.openEditor(file, editorId, "org.eclipse.core.resources.textmarker", selectionStart, selectionEnd);
    }

    public static IEditorPart openEditor(IFileMarker fileMarker) throws CoreException {
        return DTRTUIUtil.openEditor(fileMarker, null);
    }

    public static IEditorPart openEditor(IFileMarker fileMarker, String editorId) throws CoreException {
        return fileMarker != null ? DTRTUIUtil.openEditor(fileMarker.getFile(), editorId, fileMarker.getType(), fileMarker.getCharStart(), fileMarker.getCharEnd()) : null;
    }

    public static IEditorPart openEditor(IFile file, String editorId, String fileMarkerType, int selectionStart, int selectionEnd) throws CoreException {
        IWorkbenchPage page;
        IWorkbenchWindow workbench;
        if (file != null && file.isAccessible() && (workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = workbench.getActivePage()) != null) {
            IMarker marker = file.createMarker(fileMarkerType);
            if (editorId != null) {
                marker.setAttribute("org.eclipse.ui.editorID", (Object)editorId);
            }
            if (selectionStart >= 0 && selectionEnd > selectionStart) {
                marker.setAttribute("charStart", selectionStart);
                marker.setAttribute("charEnd", selectionEnd);
            }
            try {
                IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                return iEditorPart;
            }
            finally {
                marker.delete();
            }
        }
        return null;
    }

    public static IEditorPart openWebPageEditor(Shell shell, BindingObjectUsageManager.INodeProxy nodeProxy) {
        if (shell != null && nodeProxy != null && !nodeProxy.isDisposed()) {
            try {
                return DTRTUIUtil.openEditor(nodeProxy.getBoundSource().getFile(), nodeProxy.getStartPosition(), nodeProxy.getEndPosition());
            }
            catch (CoreException e) {
                DTRTUIUtil.handleError(shell, e);
            }
        }
        return null;
    }

    private static ITextEditor getActiveTextEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            return editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (editorPart != null ? (ITextEditor)editorPart.getAdapter(ITextEditor.class) : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getTextEditorOffset() {
        IRegion region;
        ITextEditor textEditor = DTRTUIUtil.getActiveTextEditor();
        if (textEditor != null && (region = textEditor.getHighlightRange()) != null) {
            return region.getOffset();
        }
        return -1;
    }

    public static void setSelectionInTextEditor(int offset, int length) {
        ITextEditor textEditor;
        if (offset >= 0 && (textEditor = DTRTUIUtil.getActiveTextEditor()) != null) {
            textEditor.selectAndReveal(offset, length);
        }
    }

    public static IPartService getPartService(IWorkbenchPart part) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPartSite site;
        if (part != null && (site = part.getSite()) != null && (workbenchWindow = site.getWorkbenchWindow()) != null) {
            return workbenchWindow.getPartService();
        }
        return null;
    }

    public static IFile getFile(IWorkbenchPart part) {
        return part instanceof IEditorPart ? DTRTUIUtil.getFile(((IEditorPart)part).getEditorInput()) : null;
    }

    public static IFile getFile(IEditorInput input) {
        return input == null ? null : (input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : (IFile)input.getAdapter(IFile.class));
    }

    public static IFile getAccessiblePageDefinitionFile(IPageDefinitionContext context) {
        return context != null ? context.getAccessibleFile((IObject)context.getPageDefinition()) : null;
    }

    public static WizardDialog createCenteredWizardDialog(IWizard wizard) {
        return DTRTUIUtil.createCenteredWizardDialog(DTRTUIUtil.getPlatformShell(), -1, -1, wizard);
    }

    public static WizardDialog createCenteredWizardDialog(Shell parent, int width, int height, IWizard wizard) {
        if (wizard != null) {
            WizardDialog wizardDialog = new WizardDialog(parent, wizard);
            DTRTUIUtil.centerDialog(parent, (Dialog)wizardDialog, width, height);
            return wizardDialog;
        }
        return null;
    }

    public static void centerDialog(Shell parent, Dialog dialog) {
        DTRTUIUtil.centerDialog(parent, dialog, -1, -1);
    }

    public static void centerDialog(Shell parent, Dialog dialog, int width, int height) {
        if (dialog != null) {
            dialog.create();
            Shell shell = dialog.getShell();
            Point size = shell.getSize();
            if (width > 0 || height > 0) {
                if (width <= 0) {
                    width = size.x;
                }
                if (height <= 0) {
                    height = size.y;
                }
                size = new Point(width, height);
                shell.setSize(size);
            }
            Rectangle parentBounds = parent.getBounds();
            int parentMidX = parentBounds.x + parentBounds.width / 2;
            int parentMidY = parentBounds.y + parentBounds.height / 2;
            shell.setLocation(parentMidX - size.x / 2, parentMidY - size.y / 2);
        }
    }

    public static int disposeChildren(Composite parent) {
        Control[] children;
        if (parent != null && !parent.isDisposed() && (children = parent.getChildren()) != null && children.length > 0) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            return children.length;
        }
        return 0;
    }

    public static IEditorPart open(IOpenable openable) {
        if (openable != null) {
            try {
                return openable.openEditor();
            }
            catch (CoreException ex) {
                UIExceptionHandler.DEFAULT.handleException((Exception)((Object)ex));
            }
        }
        return null;
    }

    public static IHyperlinkListener getOpenableHyperlinkListener() {
        if (openableHyperlinkListener == null) {
            openableHyperlinkListener = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Object href = e.getHref();
                    if (href instanceof IOpenable) {
                        DTRTUIUtil.open((IOpenable)href);
                    }
                }
            };
        }
        return openableHyperlinkListener;
    }

    public static ExpandableComposite createExpandableComposite(FormToolkit toolkit, Composite parent, int style, boolean useLabelFont) {
        ExpandableComposite expandableComposite = toolkit.createExpandableComposite(parent, style);
        expandableComposite.clientVerticalSpacing = 5;
        DTRTUIUtil.applyGrabAllGridData((Control)expandableComposite);
        if (useLabelFont) {
            Label dummy = DTRTUIUtil.createSectionLabel(toolkit, parent, "");
            expandableComposite.setFont(dummy.getFont());
            dummy.dispose();
            expandableComposite.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        return expandableComposite;
    }

    public static IWorkbenchPage getActiveWorkbenchPage(IWorkbenchSite site) {
        IWorkbenchWindow window;
        if (site != null && (window = site.getWorkbenchWindow()) != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IEditorPart getActiveEditor(IWorkbenchSite site, boolean mustBeActivePart) {
        IEditorPart editorPart;
        IWorkbenchPage page = DTRTUIUtil.getActiveWorkbenchPage(site);
        if (!(page == null || (editorPart = page.getActiveEditor()) == null || mustBeActivePart && page.getActivePart() != editorPart)) {
            return editorPart;
        }
        return null;
    }

    public static class ExpandableCompositeAdapter
    extends ExpansionAdapter
    implements IDisposable {
        private static final String ID_KEY = "ExpandableCompositeAdapter_ID_KEY";
        private IManagedForm managedForm;
        private Map<String, Boolean> expandedStateMap;

        public ExpandableCompositeAdapter() {
        }

        public ExpandableCompositeAdapter(IManagedForm managedForm) {
            this.managedForm = managedForm;
        }

        public void dispose() {
            this.managedForm = null;
            if (this.expandedStateMap != null) {
                this.expandedStateMap.clear();
                this.expandedStateMap = null;
            }
        }

        public void setId(ExpandableComposite expandableComposite, String id) {
            if (expandableComposite != null) {
                expandableComposite.setData(ID_KEY, (Object)id);
            }
        }

        public int adjustExpandedState(String expandableCompositeId, int style) {
            if (this.expandedStateMap != null) {
                Boolean expanded = this.expandedStateMap.get(expandableCompositeId);
                if (Boolean.TRUE == expanded) {
                    style |= 0x40;
                } else if (Boolean.FALSE == expanded) {
                    style &= 0xFFFFFFBF;
                }
            }
            return style;
        }

        public void expansionStateChanged(ExpansionEvent e) {
            ExpandableComposite expandableComposite = (ExpandableComposite)e.getSource();
            Object id = expandableComposite.getData(ID_KEY);
            if (id instanceof String) {
                if (this.expandedStateMap == null) {
                    this.expandedStateMap = new HashMap<String, Boolean>(4);
                }
                this.expandedStateMap.put((String)id, expandableComposite.isExpanded());
            }
            DTRTUIUtil.controlChanged((Control)expandableComposite);
            if (this.managedForm != null) {
                this.managedForm.reflow(true);
            }
        }
    }

    public static class PartListAdapter
    implements IPartListener {
        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

