/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.provider.IPageDefinitionDecorationProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ObjectLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.PageDefinitionContextContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DecoratedImageManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;

public class PageDefinitionContextLabelProvider
extends ObjectLabelProvider {
    private static final String EXTENSION_POINT_ID = "oracle.eclipse.tools.adf.dtrt.ui.pageDefinitionDecorationProviders";
    private IPageDefinitionContext context;
    private List<IPageDefinitionDecorationProvider> decorationProviders;

    public PageDefinitionContextLabelProvider(IPageDefinitionContext context) {
        this.context = context;
    }

    @Override
    public void dispose() {
        this.context = null;
        if (this.decorationProviders != null) {
            this.decorationProviders.clear();
            this.decorationProviders = null;
        }
        super.dispose();
    }

    public IPageDefinitionContext getContext() {
        return this.context;
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (element instanceof PageDefinitionContextContentProvider.Category) {
            PageDefinitionContextContentProvider.Category category = (PageDefinitionContextContentProvider.Category)element;
            if (this.getValidationMap() != null) {
                int severity = 0;
                for (IObject iObject : this.getValidationMap().keySet()) {
                    IStatus iStatus;
                    if (!category.getType().isInstance(iObject) || (iStatus = this.getValidationMap().get(iObject)) == null) continue;
                    severity = Math.max(severity, iStatus.getSeverity());
                }
                if (severity >= 2) {
                    image = this.getDecoratedImageManager().decorate(image, severity == 4 ? PageDefinitionContextLabelProvider.getValidationErrorHandle() : PageDefinitionContextLabelProvider.getValidationWarningHandle());
                }
            }
        }
        return image;
    }

    private List<IPageDefinitionDecorationProvider> getDecoratorProviders() {
        if (this.decorationProviders == null) {
            this.decorationProviders = new ArrayList<IPageDefinitionDecorationProvider>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint point = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (point != null) {
                IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    Object object = null;
                    try {
                        object = configurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        DTRTUIBundle.log("Unable to create executable extension from " + configurationElement, (Exception)((Object)e));
                    }
                    if (object instanceof IPageDefinitionDecorationProvider) {
                        IPageDefinitionDecorationProvider provider = (IPageDefinitionDecorationProvider)object;
                        provider.setContext(this.context);
                        this.decorationProviders.add(provider);
                    }
                    ++n2;
                }
            }
        }
        return this.decorationProviders;
    }

    @Override
    protected List<DecoratedImageManager.DecorationHandle> computeDecorationHandles(IObject object) {
        List<DecoratedImageManager.DecorationHandle> decorationHandles = super.computeDecorationHandles(object);
        for (IPageDefinitionDecorationProvider decoratorProvider : this.getDecoratorProviders()) {
            List<DecoratedImageManager.DecorationHandle> debugDecorations;
            if (decoratorProvider == null || (debugDecorations = decoratorProvider.computeDebugDecorationHandles(object)).size() <= 0) continue;
            decorationHandles.addAll(debugDecorations);
        }
        return decorationHandles;
    }
}

