/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.net.URI;
import java.util.Collection;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class Outline<T extends IOEPEExecutableContext>
implements ISelectionChangedListener {
    private EditorPage<T> editorPage;
    private FormToolkit toolkit;
    private boolean createdToolkit;
    private Composite client;
    private MyFilteredTree filteredTree;
    private boolean needsUpdate;
    private String identifier;

    public static final MyFilteredTree createFilteredTree(FormToolkit toolkit, Composite parent, PatternFilter filter) {
        MyFilteredTree filteredTree = new MyFilteredTree(parent, 4, filter, true);
        TreeViewer treeViewer = filteredTree.getViewer();
        Tree composite = treeViewer.getTree();
        while (composite != parent) {
            toolkit.adapt((Composite)composite);
            composite = composite.getParent();
        }
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        treeViewer.getTree().setLayoutData((Object)gd);
        return filteredTree;
    }

    public Outline(EditorPage<T> editorPage, String identifier) {
        assert (editorPage != null);
        this.editorPage = editorPage;
        this.identifier = identifier;
        editorPage.getEditor().getSelectionHandler().createSelectionHelper(this);
    }

    public void dispose() {
        this.needsUpdate = false;
        if (this.toolkit != null) {
            if (this.createdToolkit) {
                this.toolkit.dispose();
            }
            this.toolkit = null;
        }
        this.client = null;
        this.filteredTree = null;
        this.editorPage = null;
    }

    public final boolean isDisposed() {
        return this.editorPage == null;
    }

    public final EditorPage<T> getEditorPage() {
        return this.editorPage;
    }

    public final T getContext() {
        return this.editorPage.getContext();
    }

    public final void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public final FormToolkit getToolkit() {
        if (this.toolkit == null) {
            this.toolkit = new FormToolkit(Display.getCurrent());
            this.createdToolkit = true;
        }
        return this.toolkit;
    }

    public final String getId() {
        return this.identifier;
    }

    protected final TreeViewer getTreeViewer() {
        return this.filteredTree != null ? this.filteredTree.getViewer() : null;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        this.setTreeSelection(DTRTUIUtil.toNotNullSelection(event));
    }

    private void setTreeSelection(ISelection selection) {
        if (this.getTreeViewer() != null && (selection = this.toTreeSelection(this.getTreeViewer(), selection)) != null && !selection.equals(this.getTreeViewer().getSelection())) {
            this.getTreeViewer().setSelection(selection, true);
        }
    }

    public final Control getControl() {
        return this.client;
    }

    final SelectionHelper getSelectionHelper() {
        return this.getEditorPage().getEditor().getSelectionHandler().getSelectionHelper(this);
    }

    protected final ISelection getSelection() {
        return this.getSelectionHelper().getSelection();
    }

    public final void createControl(Composite parent) {
        this.toolkit.adapt(parent);
        this.client = this.createClientComposite(this.toolkit, parent);
        GridLayoutFactory.fillDefaults().margins(2, 0).applyTo(this.client);
        this.filteredTree = Outline.createFilteredTree(this.toolkit, this.client, this.createPatternFilter());
        this.createActions();
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = Outline.this.getTreeSelection();
                Outline.this.updateActions(selection);
                Outline.this.getSelectionHelper().setSelectionAndNotify(Outline.this.fromTreeSelection(Outline.this.getTreeViewer(), selection));
            }
        });
        Menu menu = new Menu((Control)this.getTreeViewer().getTree());
        this.getTreeViewer().getTree().setMenu(menu);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().setContentProvider(this.createContentProvider());
        IBaseLabelProvider labelProvider = this.createLabelProvider();
        if (labelProvider instanceof DescribableLabelProvider) {
            ((DescribableLabelProvider)labelProvider).setFilteredTree(this.filteredTree);
        }
        this.getTreeViewer().setLabelProvider(labelProvider);
        this.getTreeViewer().setComparator(this.createComparator());
        this.adjustTreeViewer(this.getTreeViewer());
        this.getTreeViewer().setInput(this.getContext());
        this.needsUpdate = false;
    }

    protected final Composite createClientComposite(FormToolkit toolkit, Composite parent) {
        return toolkit.createComposite(parent, 0);
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
    }

    public final void reset(URI selectedObjectURI) {
        if (this.getTreeViewer() != null) {
            ISelection selection = this.getTreeViewer().getSelection();
            Object selectedObject = DTRTUIUtil.getFirstElement(selection);
            if (selectedObject instanceof DescribableTreeElement) {
                selectedObject = ((DescribableTreeElement)selectedObject).getDescribable();
            }
            this.getTreeViewer().refresh();
            this.needsUpdate = false;
            if (selectedObject != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selectedObject));
            }
            if (DTRTUIUtil.getFirstElement(this.getTreeViewer().getSelection()) == null) {
                IObject toSelect = null;
                if (this.getTreeViewer().getTree().getItemCount() > 0) {
                    if (selectedObjectURI != null) {
                        toSelect = this.getEditorPage().getEditor().findObjectByURI(selectedObjectURI);
                    }
                    if (toSelect == null) {
                        toSelect = this.getFirstObject();
                    }
                }
                this.setTreeSelection((ISelection)(toSelect == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)toSelect)));
            }
        }
    }

    public final void refresh(boolean updateLabels) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().refresh(this.getContext(), updateLabels);
            this.needsUpdate = false;
        }
    }

    protected final void markForUpdate() {
        this.needsUpdate = true;
    }

    protected final void update(Object[] elements) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().update(elements, null);
            this.needsUpdate = false;
        }
    }

    public final boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected final void update(Collection<? extends IObject> objects) {
        if (this.getTreeViewer() != null && objects != null && !objects.isEmpty()) {
            this.handleUpdateObject(objects);
        }
    }

    public void selectFirstObject() {
        IObject object = this.getFirstObject();
        if (object != null) {
            this.setTreeSelection((ISelection)new StructuredSelection((Object)object));
        }
    }

    protected final IObject getFirstObject() {
        if (this.getTreeViewer() != null) {
            TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                IObject object = this.getObject(item);
                if (object != null) {
                    return object;
                }
                ++n2;
            }
        }
        return null;
    }

    private IObject getObject(TreeItem item) {
        Object data = item.getData();
        if (data != null) {
            IDescribable describable;
            if (data instanceof IObject) {
                return (IObject)data;
            }
            if (data instanceof DescribableTreeElement && (describable = ((DescribableTreeElement)data).getDescribable()) instanceof IObject) {
                return (IObject)describable;
            }
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                IObject object = this.getObject(child);
                if (object != null) {
                    return object;
                }
                ++n2;
            }
        }
        return null;
    }

    public final Object getNextObjectToSelect() {
        Tree tree;
        if (this.getTreeViewer() != null && (tree = this.getTreeViewer().getTree()).getSelectionCount() > 0) {
            TreeItem item = tree.getSelection()[0];
            if (item.getParentItem() != null) {
                TreeItem parent = item.getParentItem();
                int index = parent.indexOf(item);
                assert (index >= 0);
                if (parent.getItemCount() != 1) {
                    item = index < parent.getItemCount() - 1 ? parent.getItem(index + 1) : parent.getItem(index - 1);
                }
            } else {
                Tree parent = item.getParent();
                int index = parent.indexOf(item);
                assert (index >= 0);
                if (parent.getItemCount() != 1) {
                    TreeItem treeItem = item = index < parent.getItemCount() - 1 ? parent.getItem(index + 1) : parent.getItem(index - 1);
                }
            }
            if (item != null && item.getData() != null) {
                return item.getData();
            }
        }
        return this.getFirstObject();
    }

    public final IObject getObject(String id) {
        if (this.getTreeViewer() != null) {
            TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                TreeItem[] treeItemArray2 = item.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IObject obj;
                    TreeItem child = treeItemArray2[n4];
                    Object data = child.getData();
                    if (data instanceof IObject && (obj = (IObject)data).getId().equals(id)) {
                        return obj;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    protected final Shell getShell() {
        return this.getTreeViewer() != null ? this.getTreeViewer().getControl().getShell() : null;
    }

    protected final ISelection getTreeSelection() {
        return this.getTreeViewer() != null ? this.getTreeViewer().getSelection() : null;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.getTreeViewer() != null ? (ITreeContentProvider)this.getTreeViewer().getContentProvider() : null;
    }

    public final void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected final ViewerComparator createComparator() {
        return new DescribableViewerComparator();
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new DescribableLabelProvider();
    }

    protected PatternFilter createPatternFilter() {
        return new PatternFilter();
    }

    protected abstract IContentProvider createContentProvider();

    protected abstract void updateActions(ISelection var1);

    protected abstract void handleUpdateObject(Collection<? extends IObject> var1);

    protected abstract void createActions();

    protected abstract IAction getCreateAction();

    protected abstract IAction getDeleteAction();

    protected ISelection toTreeSelection(TreeViewer treeViewer, ISelection selection) {
        return selection;
    }

    protected ISelection fromTreeSelection(TreeViewer treeViewer, ISelection rawSelection) {
        return rawSelection;
    }

    protected final void fillToolBar(ToolBar toolBar) {
        this.doFillToolBar(toolBar);
    }

    protected final void fillToolBar(IActionBars actionBars) {
        this.doFillToolBar(actionBars.getToolBarManager());
        IAction deleteAction = this.getDeleteAction();
        if (deleteAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
        }
    }

    protected void doFillToolBar(Object parent) {
        IAction deleteAction;
        IAction createAction = this.getCreateAction();
        if (createAction != null) {
            DTRTUIUtil.renderAction(parent, createAction);
        }
        if ((deleteAction = this.getDeleteAction()) != null) {
            DTRTUIUtil.renderAction(parent, deleteAction);
        }
    }

    public final boolean clearFilter() {
        if (this.filteredTree != null) {
            boolean hasFilterText = this.filteredTree.hasFilterText();
            this.filteredTree.clearText();
            return hasFilterText;
        }
        return false;
    }

    private static class MyFilteredTree
    extends FilteredTree {
        public MyFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
            super(parent, treeStyle, filter, useNewLook);
        }

        public boolean hasFilterText() {
            return !DTRTUtil.isEmpty((String)this.getFilterControl().getText());
        }

        protected void clearText() {
            if (this.hasFilterText()) {
                super.clearText();
            }
        }
    }
}

