/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CommonEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.ObjectDetailsPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.editor.OutlineBlock;
import oracle.eclipse.tools.adf.dtrt.ui.editor.OutlineView;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.IGotoMarker;

public abstract class EditorPage<T extends IOEPEExecutableContext>
extends FormPage
implements IGotoMarker,
IDisposable {
    private OutlineBlock<T> outlineBlock;
    private OutlineView<T> outlineView;
    private ExecutorService asyncValidationExecutorService;

    public EditorPage(CommonEditor<T> editor, String id, String title) {
        super(editor, id, title);
        assert (editor.getContext() != null);
        assert (!editor.getContext().isDisposed());
        assert (editor.getContext().isInitialized());
        this.outlineBlock = this.createOutlineBlock();
    }

    public void dispose() {
        if (this.outlineBlock != null) {
            this.outlineBlock.dispose();
            this.outlineBlock = null;
        }
        if (this.outlineView != null) {
            this.outlineView.dispose();
            this.outlineView = null;
        }
        if (this.asyncValidationExecutorService != null) {
            try {
                this.asyncValidationExecutorService.shutdownNow();
            }
            catch (Exception exception) {}
            this.asyncValidationExecutorService = null;
        }
        super.dispose();
    }

    public final void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }

    public T getContext() {
        return this.getEditor().getContext();
    }

    public final CommonEditor<T> getEditor() {
        return (CommonEditor)super.getEditor();
    }

    public final IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = DTRTUIBundle.getActivatorInstance().getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings settingsSection = dialogSettings.getSection(this.getDialogSettingsSectionName());
            if (settingsSection == null) {
                settingsSection = dialogSettings.addNewSection(this.getDialogSettingsSectionName());
            }
            return settingsSection;
        }
        return null;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.getEditor().getContentOutlinePage() != null) {
            this.getEditor().getContentOutlinePage().showOutline(this.getId());
        }
    }

    protected boolean canHandleEditorSelection(ISelection selection) {
        return true;
    }

    protected final OutlineBlock<T> getOutlineBlock() {
        return this.outlineBlock;
    }

    protected Outline<T> getOutline() {
        return this.outlineBlock.getOutline();
    }

    public final void asyncValidate(IProgressMonitor monitor) {
        if (this.asyncValidationExecutorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "async.Validate");
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.asyncValidationExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        }
        this.asyncValidationExecutorService.execute(this.getValidationRunnable());
    }

    protected Runnable getValidationRunnable() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (EditorPage.this.getOutlineBlock() != null) {
                    EditorPage.this.getOutlineBlock().getOutline().markForUpdate();
                    if (EditorPage.this.getOutline() != null) {
                        EditorPage.this.getOutline().markForUpdate();
                    }
                } else {
                    return;
                }
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && EditorPage.this.getOutlineBlock() != null && EditorPage.this.getOutlineBlock().getOutline().needsUpdate() && !EditorPage.this.getEditor().getValidationMap().isEmpty()) {
                    Map map = DTRTObjectUtil.validate(EditorPage.this.getContext(), EditorPage.this.getEditor().getValidationMap().keySet(), null);
                    if (EditorPage.this.getEditor().updateValidationMap(map)) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (EditorPage.this.getOutlineBlock() != null && EditorPage.this.getOutlineBlock().getOutline().needsUpdate()) {
                                    EditorPage.this.getOutlineBlock().getOutline().update(EditorPage.this.getEditor().getValidationMap().keySet());
                                }
                                if (EditorPage.this.getOutline() != null && EditorPage.this.getOutline().needsUpdate()) {
                                    EditorPage.this.getOutline().update(EditorPage.this.getEditor().getValidationMap().keySet());
                                }
                                EditorPage.this.getEditor().setObjectEditorIsStale(true);
                                try {
                                    EditorPage.this.getManagedForm().refresh();
                                }
                                finally {
                                    EditorPage.this.getEditor().setObjectEditorIsStale(false);
                                }
                            }
                        });
                    }
                }
            }
        };
        return runnable;
    }

    protected abstract OutlineBlock<T> createOutlineBlock();

    protected abstract Image getPageImage();

    protected abstract void applyEditorHelpContext(Control var1);

    protected abstract String getDialogSettingsSectionName();

    protected abstract OutlineView<T> createOutlineView(FormToolkit var1);

    protected final void createFormContent(IManagedForm managedForm) {
        this.adjustManagedForm(managedForm);
        managedForm.getForm().setImage(this.getPageImage());
        ScrolledForm scrolledForm = managedForm.getForm();
        managedForm.getToolkit().decorateFormHeading(scrolledForm.getForm());
        scrolledForm.setText(this.getTitle());
        scrolledForm.getForm().setSeparatorVisible(true);
        this.applyEditorHelpContext((Control)scrolledForm);
        this.outlineBlock.createContent(managedForm);
        this.outlineBlock.getOutlineSelectionHelper().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditorPage.this.getEditor().markLocation(EditorPage.this.getId());
            }
        });
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            this.outlineBlock.getOutline().selectFirstObject();
            if (this.getSelection().isEmpty()) {
                this.outlineBlock.getOutline().updateActions(selection);
            }
        } else {
            SelectionHelper selectionHelper = this.outlineBlock.getOutlineSelectionHelper();
            selectionHelper.setSelection(selection);
            selectionHelper.notifySelectionChangeListeners();
        }
        this.getEditor().adjustActionBars(true);
    }

    private void adjustManagedForm(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        DTRTUIUtil.setDefaultHyperlinkSettings(toolkit);
    }

    public final void refresh() {
        if (this.getManagedForm() != null) {
            this.outlineBlock.getOutline().refresh(true);
            this.getManagedForm().refresh();
        }
        if (this.outlineView != null) {
            this.outlineView.getOutline().refresh(true);
        }
    }

    public final void setFocus() {
        Composite body = this.getManagedForm().getForm().getBody();
        if (body != null) {
            body.setFocus();
        } else {
            super.setFocus();
        }
    }

    public final Object getAdapter(Class adapter) {
        if (adapter == IGotoMarker.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private SelectionHelper getSelectionHelper() {
        return this.getEditor().getSelectionHandler().getSelectionHelper(this);
    }

    protected final ISelection getSelection() {
        return this.getSelectionHelper().getSelection();
    }

    final OutlineView<T> createOutlineView() {
        this.outlineView = this.createOutlineView(this.getManagedForm().getToolkit());
        this.getSelectionHelper().addSelectionChangedListener(this.outlineView.getSelectionHelper());
        this.outlineView.getSelectionHelper().setSelectionAndNotify(this.getSelectionHelper().getSelection());
        this.outlineView.getSelectionHelper().addSelectionChangedListener(this.getSelectionHelper());
        return this.outlineView;
    }

    protected IObject getObject(IMarker marker) {
        return null;
    }

    public final void gotoMarker(IMarker marker) {
        IObject object = this.getObject(marker);
        if (object != null) {
            StructuredSelection selection = new StructuredSelection((Object)object);
            this.getSelectionHelper().setSelection((ISelection)selection);
        }
    }

    protected void handleGlobalDelete(Event event) {
        Control focusControl = this.getFocusControl();
        if (focusControl != null) {
            if (DTRTUIUtil.isAncestor(this.outlineBlock.getOutline().getControl(), focusControl)) {
                DTRTUIUtil.runAction(this.outlineBlock.getOutline().getDeleteAction(), event);
            } else {
                ObjectDetailsPage<T> objectDetailsPage = this.outlineBlock.getObjectDetailsPage();
                if (objectDetailsPage != null && objectDetailsPage.belongsToObjectEditor(focusControl)) {
                    IUIObjectEditor objectEditor = objectDetailsPage.getObjectEditor();
                    assert (objectEditor != null);
                    objectEditor.handleGlobalActionExecution(ActionFactory.DELETE.getId(), focusControl, event);
                }
            }
        }
    }

    public Control getFocusControl() {
        Display display;
        Control focusControl;
        ScrolledForm control;
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null && (control = managedForm.getForm()) != null && !control.isDisposed() && (focusControl = (display = control.getDisplay()).getFocusControl()) != null && !focusControl.isDisposed()) {
            return focusControl;
        }
        return null;
    }

    public void reset(URI selectedObjectURI) {
        if (this.getManagedForm() != null) {
            this.outlineBlock.getOutline().reset(selectedObjectURI);
        }
        if (this.outlineView != null) {
            this.outlineView.getOutline().reset(selectedObjectURI);
        }
        if (this.getManagedForm() != null && this.getManagedForm().getForm() != null) {
            this.outlineBlock.updateToolBarActions(this.getManagedForm().getForm().getToolBarManager());
        }
    }

    protected void validateObjects(IProgressMonitor monitor) {
    }

    public Object getNextObjectToSelect() {
        return this.outlineBlock.getOutline().getNextObjectToSelect();
    }

    protected void handlePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
    }

    public boolean canHandleDelete() {
        return true;
    }

    public boolean clearFilter() {
        return this.getOutlineBlock() != null && this.getOutlineBlock().getOutline().clearFilter();
    }
}

