/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateCommand;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class CreatableTypeDialog
extends TrayDialog {
    private IOEPEExecutableContext context;
    private ICreateCommand originalCommand;
    private List<IDescribable> types;
    private Label errorLabel;
    private ICreateCommand command;
    private IDescribable type;
    private String id;
    private Class<? extends IObject> baseType;

    public CreatableTypeDialog(Shell shell, IOEPEExecutableContext context, ICreateCommand command, Class<? extends IObject> baseType) {
        super(shell);
        this.context = context;
        this.originalCommand = command;
        this.baseType = baseType;
        this.types = new ArrayList<IDescribable>();
        this.addCreatableTypes(this.types);
        Collections.sort(this.types, DTRTUtil.COMPARATOR);
        this.command = this.originalCommand.clone();
        this.type = command.getType();
        this.id = command.getObjectId();
        this.setBlockOnOpen(true);
    }

    protected IOEPEExecutableContext getContext() {
        return this.context;
    }

    protected final Class<? extends IObject> getBaseType() {
        return this.baseType;
    }

    protected abstract String getTitle();

    protected abstract String getMessage();

    protected abstract void addCreatableTypes(List<IDescribable> var1);

    protected abstract String computeUniqueId(String var1, IDescribable var2);

    protected abstract boolean canModifyId(IDescribable var1);

    public final boolean close() {
        this.context = null;
        this.command = null;
        this.originalCommand = null;
        return super.close();
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
        this.applyContextHelp((Control)newShell);
    }

    protected void applyContextHelp(Control control) {
    }

    protected final void okPressed() {
        this.originalCommand.setObjectId(this.command.getObjectId()).setType(this.command.getType());
        super.okPressed();
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        new Label(composite, 0).setText(this.getMessage());
        FilteredTree filteredTree = new FilteredTree(composite, 2052, new PatternFilter(), true);
        TreeViewer treeViewer = filteredTree.getViewer();
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 310;
        treeViewer.getTree().setLayoutData((Object)gd);
        Composite textComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(textComposite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)textComposite);
        final Text text = DTRTUIUtil.createTextRow(null, textComposite, Messages.idLabel, 0);
        this.errorLabel = new Label(textComposite, 64);
        GridData gridData = DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.errorLabel);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        this.errorLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return CreatableTypeDialog.this.types.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider().setFilteredTree(filteredTree));
        treeViewer.setInput(this.types);
        if (this.type != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.type), true);
        }
        if (this.id != null) {
            text.setText(this.id);
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CreatableTypeDialog.this.type = (IDescribable)DTRTUIUtil.getFirstElement(event.getSelection());
                if (CreatableTypeDialog.this.type != null && (DTRTUtil.isEmpty((String)text.getText()) || DTRTUtil.equals((Object)text.getText(), (Object)text.getData("computed")))) {
                    String computed = CreatableTypeDialog.this.computeUniqueId(DTRTUtil.getLabel((IDescribable)CreatableTypeDialog.this.type), CreatableTypeDialog.this.type);
                    text.setData("computed", (Object)computed);
                    text.setText(computed);
                    text.setEnabled(CreatableTypeDialog.this.canModifyId(CreatableTypeDialog.this.type));
                    return;
                }
                CreatableTypeDialog.this.updateButtonsAndErrorText();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Button okButton = CreatableTypeDialog.this.getButton(0);
                if (okButton != null && okButton.isEnabled()) {
                    CreatableTypeDialog.this.okPressed();
                }
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                CreatableTypeDialog.this.id = DTRTUtil.isEmpty((String)text) ? null : text;
                CreatableTypeDialog.this.updateButtonsAndErrorText();
            }
        });
        treeViewer.getTree().setFocus();
        return composite;
    }

    protected final Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateButtonsAndErrorText();
        return control;
    }

    private void updateButtonsAndErrorText() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            if (!DTRTUtil.equals((Object)this.type, (Object)this.command.getType()) || !DTRTUtil.equals((Object)this.id, (Object)this.command.getObjectId())) {
                this.command.setType(this.type).setObjectId(this.id);
                IStatus status = this.context.setExecuteCommand((ICommand)this.command).canExecute();
                this.errorLabel.setText(status.isOK() ? "" : this.getStatusMessage(status));
                okButton.setEnabled(status.isOK());
            } else if (this.type == null) {
                this.errorLabel.setText("");
                okButton.setEnabled(false);
            }
        }
    }

    private String getStatusMessage(IStatus status) {
        return DTRTUtil.getLeafStatus((IStatus)status).getMessage();
    }

    private static class Messages {
        public static String idLabel;

        static {
            NLS.initializeMessages((String)CreatableTypeDialog.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

