/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CommonEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.OutlineView;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

final class CommonEditorCommonOutlinePage<T extends IOEPEExecutableContext>
extends Page
implements IContentOutlinePage {
    private Map<String, OutlineView<T>> outlineViews;
    private CommonEditor<? extends IOEPEExecutableContext> editor;
    private FormToolkit toolkit;
    private Composite pageBookComposite;
    private PageBook pageBook;
    private String currentEditorPageId;

    public CommonEditorCommonOutlinePage(CommonEditor<? extends IOEPEExecutableContext> editor, FormToolkit toolkit) {
        this.editor = editor;
        this.toolkit = toolkit;
    }

    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().setSelectionProvider(null);
        }
        if (this.outlineViews != null) {
            this.outlineViews.clear();
            this.outlineViews = null;
        }
        if (this.pageBookComposite != null) {
            this.pageBookComposite.dispose();
            this.pageBookComposite = null;
        }
        this.editor = null;
        this.pageBook = null;
        this.toolkit = null;
        super.dispose();
    }

    public final boolean isDisposed() {
        return this.pageBookComposite == null;
    }

    public void addOutline(String editorPageId, OutlineView<T> outlineView) {
        this.outlineViews.put(editorPageId, outlineView);
    }

    public void createControl(Composite parent) {
        this.pageBookComposite = new Composite(parent, 0);
        this.toolkit.adapt(this.pageBookComposite);
        DTRTUIUtil.applyGrabAllGridData((Control)this.pageBookComposite);
        GridLayoutFactory.swtDefaults().applyTo(this.pageBookComposite);
        this.pageBook = new PageBook(this.pageBookComposite, 0);
        this.toolkit.adapt((Composite)this.pageBook);
        DTRTUIUtil.applyGrabAllGridData((Control)this.pageBook);
        this.outlineViews = new HashMap<String, OutlineView<T>>();
        if (this.editor.getEditorPage() != null) {
            String editorPageId = this.editor.getEditorPage().getId();
            this.showOutline(editorPageId);
        }
    }

    void showOutline(String editorPageId) {
        OutlineView<T> outlineView;
        assert (editorPageId != null);
        if (this.pageBook != null && !this.pageBook.isDisposed() && (outlineView = this.getOutlineView(editorPageId)) != null) {
            this.currentEditorPageId = editorPageId;
            this.pageBook.showPage(outlineView.getControl());
        }
    }

    private OutlineView<T> getOutlineView(String editorPageId) {
        OutlineView<Object> outlineView;
        if (this.currentEditorPageId != editorPageId) {
            this.getSite().getActionBars().getToolBarManager().removeAll();
        }
        if ((outlineView = this.outlineViews.get(editorPageId)) == null) {
            outlineView = this.editor.getEditorPage(editorPageId).createOutlineView();
            outlineView.createControl((Composite)this.pageBook);
            this.outlineViews.put(editorPageId, outlineView);
        }
        if (this.currentEditorPageId != editorPageId) {
            outlineView.setActionBars(this.getSite().getActionBars());
        }
        this.getSite().getActionBars().updateActionBars();
        return outlineView;
    }

    public Control getControl() {
        return this.pageBookComposite;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        if (this.pageBook != null) {
            this.pageBook.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection) {
    }
}

