/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.UIExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CommonEditorCommonOutlinePage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.ContextErrorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.SelectionHandler;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummaryCollector;
import oracle.eclipse.tools.adf.dtrt.util.ValidationPreferencesHelper;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class CommonEditor<T extends IOEPEExecutableContext>
extends FormEditor
implements INavigationLocationProvider,
IOEPEExecutableContext.IExecutableContextListener,
IEclipsePreferences.IPreferenceChangeListener,
ISelectionProvider,
ISelectionChangedListener,
IUIObjectEditor.IObjectEditorClient,
IDataControlProvider.IDataControlProviderListener {
    private static final int UNDO_LIMIT = 20;
    private T context;
    private ContextErrorPage contextErrorPage;
    private Boolean dirtyState;
    private String errorMsg;
    private String errorDescription;
    private DTRTUIUtil.PartListAdapter partListAdapter;
    private boolean hasExternalChange;
    private boolean hasStructureChange;
    private IUndoContext undoContext;
    private IAction globalRevertAction;
    private IAction globalDeleteAction;
    private SaveSummaryCollector saveSummaryCollector;
    private Map<IObject, IStatus> validationMap;
    private ValidationPreferencesHelper preferenceStore;
    private List<EditorPage<T>> editorPages = new ArrayList<EditorPage<T>>(1);
    private String pageIdForLocation;
    private CommonEditorCommonOutlinePage<T> outlinePage;
    private ICommand handledCommand;
    private SelectionHandler selectionHandler;
    private boolean objectEditorIsStale;

    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().setSelectionProvider(null);
        }
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        if (this.saveSummaryCollector != null) {
            this.saveSummaryCollector.dispose();
            this.saveSummaryCollector = null;
        }
        if (this.editorPages != null) {
            this.editorPages.clear();
            this.editorPages = null;
        }
        if (this.partListAdapter != null) {
            IPartService partService = DTRTUIUtil.getPartService((IWorkbenchPart)this);
            if (partService != null) {
                partService.removePartListener((IPartListener)this.partListAdapter);
            }
            this.partListAdapter = null;
        }
        if (this.undoContext != null) {
            try {
                this.getOperationHistory().dispose(this.undoContext, true, true, true);
            }
            catch (Exception exception) {}
            this.undoContext = null;
        }
        if (this.validationMap != null) {
            this.validationMap.clear();
            this.validationMap = null;
        }
        if (this.getContext() != null) {
            this.getContext().removeListener((IOEPEContext.IContextListener)this);
        }
        if (this.selectionHandler != null) {
            this.selectionHandler.dispose();
            this.selectionHandler = null;
        }
        this.removePreferencesListener();
        this.globalRevertAction = null;
        this.globalDeleteAction = null;
        this.handledCommand = null;
        super.dispose();
    }

    public final T getContext() {
        return this.context;
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            this.context = this.init();
            this.context.addListener((IOEPEContext.IContextListener)new UIExecutableContextAdapter(this));
            this.saveSummaryCollector = new SaveSummaryCollector();
            this.initializeUndoRedoSupport();
            this.validationMap = new HashMap<IObject, IStatus>();
            this.addPreferencesListener();
            this.selectionHandler = new SelectionHandler(this);
            site.setSelectionProvider((ISelectionProvider)this);
            this.partListAdapter = new DTRTUIUtil.PartListAdapter(){

                @Override
                public void partActivated(IWorkbenchPart part) {
                    if (part == CommonEditor.this) {
                        CommonEditor.this.adjustActionBars(true);
                    }
                    if (CommonEditor.this.checkInput() && part == CommonEditor.this) {
                        if (CommonEditor.this.hasStructureChange) {
                            CommonEditor.this.hasExternalChange = false;
                            CommonEditor.this.handleStructureChange();
                        } else if (CommonEditor.this.hasExternalChange) {
                            CommonEditor.this.handleExternalChange();
                        }
                    }
                }

                @Override
                public void partDeactivated(IWorkbenchPart part) {
                    if (part == CommonEditor.this) {
                        CommonEditor.this.adjustActionBars(false);
                    }
                }
            };
            DTRTUIUtil.getPartService((IWorkbenchPart)this).addPartListener((IPartListener)this.partListAdapter);
            this.globalRevertAction = new Action(){

                public void run() {
                    CommonEditor.this.reset();
                }
            };
            this.globalRevertAction.setEnabled(false);
            this.globalDeleteAction = new Action(){

                public void run() {
                    CommonEditor.this.handleGlobalDelete(null);
                }

                public void runWithEvent(Event event) {
                    CommonEditor.this.handleGlobalDelete(event);
                }
            };
        }
        catch (EditorNotInitializedCorrectlyException e) {
            this.errorMsg = e.getMessage();
            this.errorDescription = e.getDescription();
        }
    }

    protected abstract T init() throws EditorNotInitializedCorrectlyException;

    public abstract String getPageTitle();

    protected abstract String getEditorId();

    protected abstract String getNavigationLocationName();

    public abstract IObject findObjectByURI(URI var1);

    protected abstract void addEditorPages(List<EditorPage<T>> var1);

    public boolean checkInput() {
        IFile file = DTRTUIUtil.getFile((IWorkbenchPart)this);
        return file != null && file.isAccessible() && file.getProject().isOpen();
    }

    private boolean _checkInput() {
        if (!this.checkInput()) {
            Display display = Display.getCurrent();
            if (display != null) {
                this.close(true);
            } else {
                display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommonEditor.this.close(true);
                    }
                });
            }
            return false;
        }
        return true;
    }

    public String getEditorInputKey() {
        try {
            IEditorInput editorInput = this.getEditorInput();
            return editorInput instanceof IURIEditorInput ? ((IURIEditorInput)editorInput).getURI().toString() : (editorInput instanceof IStorageEditorInput ? ((IStorageEditorInput)editorInput).getStorage().getFullPath().toString() : null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected final void addPages() {
        if (this.errorMsg == null) {
            this.addEditorPages(this.editorPages);
            if (this.editorPages.isEmpty()) {
                this.errorMsg = "A common editor must have at least one editor page";
            }
        }
        if (this.errorMsg != null) {
            try {
                this.contextErrorPage = new ContextErrorPage(this, "ContextError", String.valueOf(this.getPageTitle()) + " - " + this.errorMsg, this.errorDescription);
                this.addPage((IFormPage)this.contextErrorPage);
            }
            catch (PartInitException e) {
                DTRTUIBundle.log(e);
            }
        } else {
            try {
                for (EditorPage<T> editorPage : this.editorPages) {
                    super.addPage(editorPage);
                }
            }
            catch (PartInitException e) {
                DTRTUIBundle.log(e);
            }
        }
        if (this.getPageCount() == 1) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.setTabHeight(0);
        }
    }

    final List<EditorPage<T>> getEditorPages() {
        return this.editorPages;
    }

    public final void doSave(IProgressMonitor monitor) {
        try {
            this.getContext().save(monitor);
        }
        catch (InterruptedException interruptedException) {
            this.refresh();
        }
        catch (CoreException e) {
            DTRTUIUtil.handleError(DTRTUIUtil.getShell((IWorkbenchPart)this), e);
        }
    }

    public final void refresh() {
        EditorPage<T> editorPage2;
        URI selectedObjectURI = this.getSelectionHandler().getLastSelectedObjectURI();
        for (EditorPage<T> editorPage2 : this.editorPages) {
            editorPage2.refresh();
        }
        if (selectedObjectURI != null && (editorPage2 = this.getEditorPage()).getSelection().isEmpty()) {
            this.setSelection((ISelection)new StructuredSelection((Object)selectedObjectURI));
        }
    }

    protected final EditorPage<T> getEditorPage() {
        return this.editorPages != null && this.editorPages.size() > this.getActivePage() ? this.editorPages.get(this.getActivePage()) : null;
    }

    protected final void setActivePage(int pageIndex) {
        if (pageIndex != this.getActivePage()) {
            super.setActivePage(pageIndex);
        }
    }

    public final EditorPage<T> getEditorPage(String pageId) {
        if (pageId != null && this.editorPages != null) {
            for (EditorPage<T> editorPage : this.editorPages) {
                if (!pageId.equals(editorPage.getId())) continue;
                return editorPage;
            }
        }
        return null;
    }

    public final Map<? extends IObject, IStatus> getValidationMap() {
        return Collections.unmodifiableMap(this.validationMap);
    }

    public final boolean updateValidationMap(Map<? extends IObject, ? extends IStatus> map) {
        if (map != null && !map.isEmpty()) {
            boolean changed = false;
            for (Map.Entry<? extends IObject, ? extends IStatus> entry : map.entrySet()) {
                if (this.showStatus(entry.getValue())) {
                    this.validationMap.put(entry.getKey(), entry.getValue());
                    changed = true;
                    continue;
                }
                if (this.validationMap.remove(entry.getKey()) == null) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    private boolean showStatus(IStatus status) {
        return status != null && (status.getSeverity() == 4 || status.getSeverity() == 2);
    }

    public final IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public final SaveSummaryCollector getSaveSummaryCollector() {
        return this.saveSummaryCollector;
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    public final void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public final IOEPEExecutableContext.IContextSaveParticipant handlePreSave(IOEPEExecutableContext context) {
        return null;
    }

    public final void handleSave(IOEPEExecutableContext context, IOEPEExecutableContext.ISaveSummary saveSummary) {
        this.dirtyStateChanged();
        this.getSaveSummaryCollector().handleSave(context, saveSummary);
    }

    public boolean handlePreCommandOperation(IOEPEExecutableContext context, ICommand command) {
        return true;
    }

    public final void handleCommandOperation(IOEPEExecutableContext context, ICommand command) {
        DTRTUIUtil.toExecutedUndoableOperation(DTRTUIUtil.getShell((IWorkbenchPart)this), this.getOperationHistory(), this.undoContext, command);
        this.setObjectEditorIsStale(true);
        this.handledCommand = command;
        try {
            Object nextObjectToSelect = this.getEditorPage().getNextObjectToSelect();
            this.validateObjects(null);
            this.getEditorPage().refresh();
            if (!command.getAffectedObjects().isEmpty()) {
                this.setSelection((ISelection)new StructuredSelection(command.getAffectedObjects()));
            }
            if (this.getSelection().isEmpty()) {
                if (nextObjectToSelect != null) {
                    this.setSelection((ISelection)new StructuredSelection(nextObjectToSelect));
                }
                if (this.getSelection().isEmpty()) {
                    this.getEditorPage().getOutline().selectFirstObject();
                }
            }
            this.dirtyStateChanged();
            for (EditorPage<T> editorPage : this.editorPages) {
                if (editorPage == this.getEditorPage()) continue;
                editorPage.refresh();
            }
        }
        finally {
            this.handledCommand = null;
            this.setObjectEditorIsStale(false);
        }
    }

    @Override
    public boolean isObjectEditorStale() {
        return this.objectEditorIsStale;
    }

    void setObjectEditorIsStale(boolean objectEditorIsStale) {
        this.objectEditorIsStale = objectEditorIsStale;
    }

    @Override
    public ICommand getHandledCommand() {
        return this.handledCommand;
    }

    @Override
    public IStatus getValidationStatus(IObject object) {
        return object != null && this.validationMap != null ? this.validationMap.get(object) : null;
    }

    public final void handleExternalChange(IOEPEContext context) {
        this.hasExternalChange = true;
        if (this._checkInput() && DTRTUIUtil.getActiveEditor((IWorkbenchSite)this.getEditorSite(), true) == this) {
            this.handleExternalChange();
        }
    }

    private void handleExternalChange() {
        Shell shell = DTRTUIUtil.getShell((IWorkbenchPart)this);
        this.hasExternalChange = false;
        if (this.isDirty()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.externalChangeTitle, (String)Messages.externalChangeChoice)) {
                this.reset();
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)Messages.externalChangeTitle, (String)Messages.externalChangeReload);
            this.reset();
        }
    }

    public void handleStructureLoading(IDataControlProvider provider) {
    }

    public final void handleStructureReset(IDataControlProvider provider) {
    }

    public final void handleStructureChange(IDataControlProvider provider) {
        this.hasStructureChange = true;
        if (this._checkInput() && this.getEditorSite().getWorkbenchWindow().getActivePage().getActiveEditor() == this) {
            this.handleStructureChange();
        }
    }

    private void handleStructureChange() {
        boolean saveBeforeReset;
        Shell shell = DTRTUIUtil.getShell((IWorkbenchPart)this);
        this.hasStructureChange = false;
        if (this.isDirty()) {
            saveBeforeReset = MessageDialog.openQuestion((Shell)shell, (String)Messages.structureChangeTitle, (String)Messages.structureChangeChoice);
        } else {
            saveBeforeReset = false;
            MessageDialog.openInformation((Shell)shell, (String)Messages.structureChangeTitle, (String)Messages.structureChangeReload);
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.setOpenOnRun(true);
        DTRTUIUtil.runWithProgressMonitorDialog(DTRTUIUtil.getShell((IWorkbenchPart)this), new ResetRunnable(saveBeforeReset));
    }

    public final void handleReset(IOEPEContext context) {
    }

    public void handleDispose(IOEPEContext context) {
    }

    private void dirtyStateChanged() {
        this.resetDirtyState();
        this.editorDirtyStateChanged();
        this.globalRevertAction.setEnabled(this.isDirty());
    }

    public final void markLocation(String pageId) {
        IWorkbenchPage page = this.getSite().getPage();
        try {
            this.pageIdForLocation = pageId;
            page.getNavigationHistory().markLocation((IEditorPart)this);
        }
        finally {
            this.pageIdForLocation = null;
        }
    }

    public final INavigationLocation createEmptyNavigationLocation() {
        return new DescribableNavigationLocation(null, null);
    }

    public final INavigationLocation createNavigationLocation() {
        Object selectedObject;
        EditorPage<T> editorPage;
        EditorPage<T> editorPage2 = editorPage = this.pageIdForLocation == null ? this.getEditorPage() : this.getEditorPage(this.pageIdForLocation);
        if (editorPage != null && (selectedObject = DTRTUIUtil.getFirstElement(this.getSelection())) instanceof IDescribable) {
            return new DescribableNavigationLocation(editorPage.getId(), (IDescribable)selectedObject);
        }
        return null;
    }

    private ValidationPreferencesHelper getValidationPreferencesHelper() {
        if (this.preferenceStore == null) {
            this.preferenceStore = ValidationPreferencesHelper.createValidationPreferencesHelper();
        }
        return this.preferenceStore;
    }

    private final void addPreferencesListener() {
        this.getValidationPreferencesHelper().getValidationPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private final void removePreferencesListener() {
        this.getValidationPreferencesHelper().getValidationPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public final boolean isDirty() {
        if (this.dirtyState == null) {
            this.dirtyState = super.isDirty() || this.getContext() != null && this.getContext().needsSaving();
        }
        return Boolean.TRUE.equals(this.dirtyState);
    }

    protected final void resetDirtyState() {
        this.dirtyState = null;
    }

    public final Object getAdapter(Class adapter) {
        Object ret;
        if (adapter == IContentOutlinePage.class) {
            return this.getContentOutlinePage() == null ? this.createContenOutlinePage() : this.getContentOutlinePage();
        }
        EditorPage<T> editorPage = this.getEditorPage();
        if (editorPage != null && (ret = editorPage.getAdapter(adapter)) != null) {
            return ret;
        }
        return super.getAdapter(adapter);
    }

    public final CommonEditorCommonOutlinePage<T> getContentOutlinePage() {
        return this.outlinePage;
    }

    private CommonEditorCommonOutlinePage<T> createContenOutlinePage() {
        assert (this.outlinePage == null);
        this.outlinePage = new CommonEditorCommonOutlinePage(this, this.getToolkit());
        return this.outlinePage;
    }

    private void reset() {
        DTRTUIUtil.runWithProgressMonitorDialog(DTRTUIUtil.getShell((IWorkbenchPart)this), new ResetRunnable(false));
    }

    public final void validateObjects(IProgressMonitor monitor) {
        this.validationMap.clear();
        for (EditorPage<T> editorPage : this.editorPages) {
            editorPage.validateObjects(monitor);
        }
    }

    private void initializeUndoRedoSupport() {
        this.undoContext = new UndoContext();
        this.getOperationHistory().setLimit(this.undoContext, 20);
    }

    protected final void adjustActionBars(boolean activate) {
        IActionBars actionBars;
        IEditorSite site = this.getEditorSite();
        if (site != null && (actionBars = site.getActionBars()) != null) {
            this.adjustUndoRedoAction((IWorkbenchPartSite)site, actionBars, false, activate);
            this.adjustUndoRedoAction((IWorkbenchPartSite)site, actionBars, true, activate);
            if (activate) {
                actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.globalRevertAction);
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getEditorPage().canHandleDelete() ? this.globalDeleteAction : null);
            } else {
                actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), null);
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            }
        }
    }

    private void handleGlobalDelete(Event event) {
        this.getEditorPage().handleGlobalDelete(event);
    }

    private void adjustUndoRedoAction(IWorkbenchPartSite site, IActionBars actionBars, boolean redo, boolean activate) {
        String id = redo ? ActionFactory.REDO.getId() : ActionFactory.UNDO.getId();
        IAction currentAction = actionBars.getGlobalActionHandler(id);
        if (currentAction instanceof OperationHistoryActionHandler) {
            IWorkbenchWindow window;
            OperationHistoryActionHandler handler = (OperationHistoryActionHandler)currentAction;
            if (activate) {
                handler.setContext(this.undoContext);
            } else if (handler.getAdapter(IUndoContext.class) == this.undoContext && (window = site.getWorkbenchWindow()) != null) {
                ActionFactory.IWorkbenchAction workbenchAction = redo ? ActionFactory.REDO.create(window) : ActionFactory.UNDO.create(window);
                actionBars.setGlobalActionHandler(id, (IAction)workbenchAction);
            }
        } else if (activate) {
            RedoActionHandler handler = redo ? new RedoActionHandler(site, this.undoContext) : new UndoActionHandler(site, this.undoContext);
            actionBars.setGlobalActionHandler(id, (IAction)handler);
        }
    }

    private IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        for (EditorPage<T> editorPage : this.editorPages) {
            editorPage.handlePreferenceChange(event);
        }
    }

    protected final void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        EditorPage<T> editorPage = this.getEditorPage();
        if (editorPage != null) {
            IActionBars actionBars;
            this.setSelection(editorPage.getSelection());
            IEditorSite site = this.getEditorSite();
            if (site != null && (actionBars = site.getActionBars()) != null) {
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), editorPage.canHandleDelete() ? this.globalDeleteAction : null);
            }
        }
    }

    protected final boolean validateEdit(IFile file) {
        IWorkspace workspace;
        IStatus status;
        return file == null || !file.isAccessible() || !file.isReadOnly() || (status = (workspace = ResourcesPlugin.getWorkspace()).validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT)).isOK();
    }

    final SelectionHandler getSelectionHandler() {
        return this.selectionHandler;
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHandler.getSelectionHelper(this).addSelectionChangedListener(listener);
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionHandler.getSelectionHelper(this).removeSelectionChangedListener(listener);
    }

    public final ISelection getSelection() {
        return this.selectionHandler.getSelectionHelper(this).getSelection();
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        ISelection adjustedSelection;
        if (event != null && (adjustedSelection = this.adjustSelection(selection = event.getSelection())) != selection) {
            event = new SelectionChangedEvent(event.getSelectionProvider(), adjustedSelection);
        }
        this.selectionHandler.getSelectionHelper(this).selectionChanged(event);
    }

    public final void setSelection(ISelection selection) {
        selection = this.adjustSelection(selection);
        this.selectionHandler.getSelectionHelper(this).setSelectionAndNotify(selection);
    }

    protected ISelection adjustSelection(ISelection selection) {
        IObject object;
        Object selectedObject = DTRTUIUtil.getFirstElement(selection);
        if (selectedObject instanceof IObject) {
            object = (IObject)selectedObject;
            if (!this.getContext().isKnown(object)) {
                selectedObject = object.getURI();
            }
        }
        if (selectedObject instanceof URI && (object = this.findObjectByURI((URI)selectedObject)) != null) {
            selection = new StructuredSelection((Object)object);
        }
        return selection;
    }

    private class DescribableNavigationLocation
    extends NavigationLocation {
        private IDescribable describable;
        private URI objectURI;
        private String navigationLocationName;

        private DescribableNavigationLocation(String editorPageId, IDescribable describable) {
            super((IEditorPart)CommonEditor.this);
            if (describable instanceof IObject) {
                this.objectURI = ((IObject)describable).getURI();
            } else if (describable != null && describable.getDescriptor() != null) {
                this.describable = describable;
            }
            this.navigationLocationName = CommonEditor.this.getNavigationLocationName();
        }

        public void dispose() {
            this.describable = null;
            this.objectURI = null;
            super.dispose();
        }

        public String getText() {
            return this.navigationLocationName;
        }

        public boolean mergeInto(INavigationLocation currentLocation) {
            if (currentLocation instanceof DescribableNavigationLocation) {
                DescribableNavigationLocation other = (DescribableNavigationLocation)currentLocation;
                return DTRTUtil.equals((Object)this.objectURI, (Object)other.objectURI) && DTRTUtil.equals((Object)this.describable, (Object)other.describable);
            }
            return false;
        }

        public void restoreLocation() {
            if (this.describable != null || this.objectURI != null) {
                IFile file;
                CommonEditor commonEditor = null;
                IEditorPart editorPart = this.getEditorPart();
                if (editorPart instanceof CommonEditor && ((CommonEditor)editorPart).getContext() != null) {
                    commonEditor = (CommonEditor)editorPart;
                }
                if (commonEditor == null && (file = DTRTUIUtil.getFile((IWorkbenchPart)editorPart)) != null && file.isAccessible()) {
                    try {
                        editorPart = DTRTUIUtil.openEditor(file, CommonEditor.this.getEditorId(), -1, -1);
                        if (editorPart instanceof CommonEditor) {
                            commonEditor = (CommonEditor)editorPart;
                        }
                    }
                    catch (Exception exception) {}
                }
                if (commonEditor != null) {
                    StructuredSelection selection = this.objectURI != null ? new StructuredSelection((Object)this.objectURI) : new StructuredSelection((Object)this.describable);
                    commonEditor.setSelection((ISelection)selection);
                }
            }
        }

        public void update() {
        }

        public void restoreState(IMemento memento) {
        }

        public void saveState(IMemento memento) {
        }
    }

    protected static final class EditorNotInitializedCorrectlyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String description;

        public EditorNotInitializedCorrectlyException(String message, String description) {
            super(message);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class Messages
    extends NLS {
        public static String externalChangeReload;
        public static String externalChangeChoice;
        public static String externalChangeTitle;
        public static String structureChangeTitle;
        public static String structureChangeReload;
        public static String structureChangeChoice;

        static {
            NLS.initializeMessages((String)CommonEditor.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private final class ResetRunnable
    implements IRunnableWithProgress {
        private boolean saveBeforeReset;

        public ResetRunnable(boolean saveBeforeReset) {
            this.saveBeforeReset = saveBeforeReset;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            LinkedHashMap<EditorPage, URI> selectionMap = new LinkedHashMap<EditorPage, URI>(CommonEditor.this.editorPages.size());
            EditorPage currentPage = CommonEditor.this.getEditorPage();
            for (EditorPage editorPage : CommonEditor.this.editorPages) {
                IObject selectedObject = DTRTUIUtil.getObject(editorPage.getSelection());
                if (selectedObject == null || selectedObject.getURI() == null) continue;
                selectionMap.put(editorPage, selectedObject.getURI());
            }
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(this.saveBeforeReset ? 5 : 3));
            try {
                if (this.saveBeforeReset) {
                    CommonEditor.this.getContext().save(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                }
                CommonEditor.this.getContext().reset(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                CommonEditor.this.validateObjects(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            }
            catch (CoreException e) {
                DTRTUIUtil.handleError(DTRTUIUtil.getShell((IWorkbenchPart)CommonEditor.this), e);
            }
            for (EditorPage editorPage : CommonEditor.this.editorPages) {
                editorPage.reset((URI)selectionMap.get((Object)editorPage));
            }
            if (currentPage != null) {
                CommonEditor.this.setActivePage(currentPage.getId());
            }
            CommonEditor.this.dirtyStateChanged();
            CommonEditor.this.getOperationHistory().dispose(CommonEditor.this.undoContext, true, true, true);
            CommonEditor.this.getOperationHistory().setLimit(CommonEditor.this.undoContext, 20);
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }
}

