/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class BaseDetailPage<T extends IOEPEExecutableContext>
implements IDetailsPage {
    private EditorPage<T> editorPage;
    private IManagedForm managedForm;

    public static final Section createSection(final IManagedForm managedForm, Composite parent, String title, boolean grabVertical, int extraStyle) {
        FormToolkit toolkit = managedForm.getToolkit();
        int style = 0x102 | extraStyle;
        Section section = toolkit.createSection(parent, style);
        section.clientVerticalSpacing = 10;
        section.marginWidth = 5;
        if (title != null) {
            section.setText(title);
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                managedForm.reflow(true);
            }
        });
        GridDataFactory.fillDefaults().grab(true, grabVertical).applyTo((Control)section);
        return section;
    }

    protected BaseDetailPage(EditorPage<T> editorPage) {
        assert (editorPage != null);
        assert (editorPage.getContext() != null);
        this.editorPage = editorPage;
    }

    public void dispose() {
        this.editorPage = null;
        this.managedForm = null;
    }

    protected EditorPage<T> getEditorPage() {
        return this.editorPage;
    }

    protected final IManagedForm getManagedForm() {
        return this.managedForm;
    }

    public final void initialize(IManagedForm form) {
        this.managedForm = form;
    }

    public void createContents(Composite parent) {
        GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing().x, 20).applyTo(parent);
    }

    public final boolean setFormInput(Object input) {
        return false;
    }

    public final boolean isDirty() {
        return false;
    }

    public final void commit(boolean onSave) {
    }
}

