/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.context;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class UIExecutableContextAdapter
implements IOEPEExecutableContext.IExecutableContextListener {
    private IOEPEExecutableContext.IExecutableContextListener contextListener;

    public UIExecutableContextAdapter(IOEPEExecutableContext.IExecutableContextListener contextListener) {
        this.contextListener = contextListener;
    }

    public IOEPEExecutableContext.IExecutableContextListener getContextListener() {
        return this.contextListener;
    }

    public void handleDispose(IOEPEContext context) {
        ExecutableContextListenerMethod.HANDLE_DISPOSE.invoke(this.getContextListener(), context, new Object[0]);
    }

    public void handleExternalChange(IOEPEContext context) {
        ExecutableContextListenerMethod.HANDLE_EXTERNAL_CHANGE.invoke(this.getContextListener(), context, new Object[0]);
    }

    public void handleReset(IOEPEContext context) {
        ExecutableContextListenerMethod.HANDLE_RESET.invoke(this.getContextListener(), context, new Object[0]);
    }

    public boolean handlePreCommandOperation(IOEPEExecutableContext context, ICommand command) {
        Object ret = ExecutableContextListenerMethod.HANDLE_PRE_COMMAND_OPERATION.invoke(this.getContextListener(), (IOEPEContext)context, command);
        return (Boolean)ret;
    }

    public void handleCommandOperation(IOEPEExecutableContext context, ICommand command) {
        ExecutableContextListenerMethod.HANDLE_COMMAND_OPERATION.invoke(this.getContextListener(), (IOEPEContext)context, command);
    }

    public IOEPEExecutableContext.IContextSaveParticipant handlePreSave(IOEPEExecutableContext context) {
        Object ret = ExecutableContextListenerMethod.HANDLE_PRE_SAVE.invoke(this.getContextListener(), (IOEPEContext)context, new Object[0]);
        return (IOEPEExecutableContext.IContextSaveParticipant)ret;
    }

    public void handleSave(IOEPEExecutableContext context, IOEPEExecutableContext.ISaveSummary saveSummary) {
        ExecutableContextListenerMethod.HANDLE_SAVE.invoke(this.getContextListener(), (IOEPEContext)context, saveSummary);
    }

    private static enum ExecutableContextListenerMethod {
        HANDLE_DISPOSE,
        HANDLE_EXTERNAL_CHANGE,
        HANDLE_RESET,
        HANDLE_PRE_COMMAND_OPERATION,
        HANDLE_COMMAND_OPERATION,
        HANDLE_PRE_SAVE,
        HANDLE_SAVE;


        public Object invoke(final IOEPEExecutableContext.IExecutableContextListener listener, final IOEPEContext context, final Object ... args) {
            Display display;
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {
                display = null;
            }
            if (display != null) {
                if (Display.getCurrent() != null) {
                    return this.doInvoke(listener, context, args);
                }
                final Object[] ret = new Object[1];
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ret[0] = ExecutableContextListenerMethod.this.doInvoke(listener, context, args);
                    }
                });
                return ret[0];
            }
            return this.doInvoke(listener, context, args);
        }

        private Object doInvoke(IOEPEExecutableContext.IExecutableContextListener listener, IOEPEContext context, Object ... args) {
            switch (this) {
                case HANDLE_DISPOSE: {
                    listener.handleDispose(context);
                    return null;
                }
                case HANDLE_EXTERNAL_CHANGE: {
                    listener.handleExternalChange(context);
                    return null;
                }
                case HANDLE_RESET: {
                    listener.handleReset(context);
                    return null;
                }
                case HANDLE_PRE_COMMAND_OPERATION: {
                    return listener.handlePreCommandOperation((IOEPEExecutableContext)context, (ICommand)args[0]);
                }
                case HANDLE_COMMAND_OPERATION: {
                    listener.handleCommandOperation((IOEPEExecutableContext)context, (ICommand)args[0]);
                    return null;
                }
                case HANDLE_PRE_SAVE: {
                    return listener.handlePreSave((IOEPEExecutableContext)context);
                }
                case HANDLE_SAVE: {
                    listener.handleSave((IOEPEExecutableContext)context, (IOEPEExecutableContext.ISaveSummary)args[0]);
                    return null;
                }
            }
            throw new IllegalStateException("Unhandled enumeration literal: " + (Object)((Object)this));
        }
    }
}

