/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.context;

import java.util.EnumMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableResource;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class BasicDataControlObjectEditor
extends BasicObjectEditor {
    private IDataControlProvider dataControlProvider;
    private boolean showStructureMember;
    private boolean showDeclarationAsHyperlink;
    private FormToolkit toolkit;
    private Composite parentComposite;
    private Control lastCommonControl;
    private Map<DTRTContentType, String> declarationEditorIdMap;

    public BasicDataControlObjectEditor(IDataControlProvider dataControlProvider, IDataControlObject dataControlObject, boolean showDeclarationAsHyperlink, boolean showStructureMember) {
        super((IObject)dataControlObject);
        this.dataControlProvider = dataControlProvider;
        this.showDeclarationAsHyperlink = showDeclarationAsHyperlink;
        this.showStructureMember = showStructureMember;
    }

    @Override
    public void dispose() {
        if (this.declarationEditorIdMap != null) {
            this.declarationEditorIdMap.clear();
            this.declarationEditorIdMap = null;
        }
        this.dataControlProvider = null;
        this.toolkit = null;
        this.parentComposite = null;
        this.lastCommonControl = null;
        super.dispose();
    }

    public IDataControlObject getObject() {
        return (IDataControlObject)super.getObject();
    }

    public void setDeclarationEditorId(DTRTContentType contentType, String declarationEditorId) {
        if (contentType != null) {
            if (declarationEditorId != null) {
                if (this.declarationEditorIdMap == null) {
                    this.declarationEditorIdMap = new EnumMap<DTRTContentType, String>(DTRTContentType.class);
                }
                this.declarationEditorIdMap.put(contentType, declarationEditorId);
            } else if (this.declarationEditorIdMap != null && this.declarationEditorIdMap.remove(contentType) != null && this.declarationEditorIdMap.isEmpty()) {
                this.declarationEditorIdMap = null;
            }
        }
    }

    public String getDeclarationEditorId(DTRTContentType contentType) {
        return this.declarationEditorIdMap != null ? this.declarationEditorIdMap.get(contentType) : null;
    }

    protected IDataControlProvider getDataControlProvider() {
        return this.dataControlProvider;
    }

    public boolean isShowDeclarationAsHyperlink() {
        return this.showDeclarationAsHyperlink;
    }

    @Override
    protected void addControls(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.parentComposite = parent;
        this.createObjectViewer(toolkit, parent);
    }

    @Override
    protected String getType() {
        IStructureObject structureObject;
        if (this.getObject() != null && (structureObject = this.getObject().getStructureObject()) != null && structureObject.getSourceTypeDescriptor() != null) {
            return structureObject.getSourceTypeDescriptor().getLabel();
        }
        return Messages.unknown;
    }

    @Override
    public void refresh() {
        boolean layout = false;
        if (this.lastCommonControl == null) {
            Control[] children = this.parentComposite.getChildren();
            if (children.length > 0) {
                this.lastCommonControl = children[children.length - 1];
            }
        } else {
            boolean dispose = false;
            Control[] children = this.parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == this.lastCommonControl) {
                    dispose = true;
                    layout = true;
                } else if (dispose) {
                    children[i].dispose();
                }
                ++i;
            }
        }
        if (this.createObjectSpecificControls(this.toolkit, this.parentComposite) || layout) {
            this.parentComposite.layout(true);
        }
        super.refresh();
    }

    protected boolean createObjectSpecificControls(FormToolkit toolkit, Composite parent) {
        IStructureObject structureObject;
        boolean layout = false;
        IFileMarker declarationFileMarker = this.getDataControlProvider().getAccessibleDeclaration(this.getObject());
        if (declarationFileMarker != null && declarationFileMarker.getFile() != null) {
            DTRTUIUtil.createSectionLabel(toolkit, parent, Messages.declarationLabel);
            DescribableViewer declarationViewer = new DescribableViewer();
            declarationViewer.setUseDescribableToolTipText(true);
            Control control = declarationViewer.createControl(toolkit, parent, false, false);
            DTRTUIUtil.applyGrabHorizontallyGridData(control);
            if (this.showDeclarationAsHyperlink) {
                declarationViewer.addHyperlinkListener(DTRTUIUtil.getOpenableHyperlinkListener());
            }
            OpenableResource openableResource = new OpenableResource(declarationFileMarker.getFile(), (ISelection)new StructuredSelection((Object)this.getObject()));
            if (this.declarationEditorIdMap != null) {
                for (Map.Entry<DTRTContentType, String> entry : this.declarationEditorIdMap.entrySet()) {
                    if (!entry.getKey().appliesTo(declarationFileMarker.getFile())) continue;
                    openableResource.setEditorId(entry.getValue());
                }
            }
            declarationViewer.setInput(openableResource);
            layout = true;
        }
        if (this.getObject() != null && (structureObject = this.getObject().getStructureObject()) != null) {
            if (this.getObject() instanceof IDataControlChild && structureObject.getSourceTypeDescriptor() != null) {
                this.createTypeText(toolkit, parent);
            }
            HyperlinkAdapter structureObjectHyperlinkListener = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IStructureObject structureObject;
                    if (BasicDataControlObjectEditor.this.getObject() != null && (structureObject = BasicDataControlObjectEditor.this.getObject().getStructureObject()) != null) {
                        BasicDataControlObjectEditor.this.notifyObjectSelectionListeners((ISelection)new StructuredSelection((Object)structureObject));
                    }
                }
            };
            if (this.showStructureMember) {
                if (DTRTUtil.equals((Object)this.getObject().getDescriptor(), (Object)structureObject.getDescriptor())) {
                    Hyperlink hyperlink = toolkit.createHyperlink(parent, structureObject.canCustomize() ? Messages.editStructureDefinitionLink : Messages.viewStructureDefinitionLink, 64);
                    GridData gridData = DTRTUIUtil.applyGrabHorizontallyGridData((Control)hyperlink);
                    gridData.horizontalSpan = 2;
                    gridData.verticalIndent = 5;
                    hyperlink.addHyperlinkListener((IHyperlinkListener)structureObjectHyperlinkListener);
                } else {
                    DTRTUIUtil.createSectionLabel(toolkit, parent, Messages.structureChildLabel);
                    DescribableViewer structureChildViewer = new DescribableViewer();
                    structureChildViewer.setUseDescribableToolTipText(true);
                    structureChildViewer.setNullString(Messages.unknown);
                    DTRTUIUtil.applyGrabHorizontallyGridData(structureChildViewer.createControl(toolkit, parent, false, false));
                    structureChildViewer.setInput((IDescribable)structureObject);
                    structureChildViewer.addHyperlinkListener((IHyperlinkListener)structureObjectHyperlinkListener);
                }
            }
            layout = true;
        }
        return layout;
    }

    private static final class Messages
    extends NLS {
        public static String unknown;
        public static String structureChildLabel;
        public static String viewStructureDefinitionLink;
        public static String editStructureDefinitionLink;
        public static String declarationLabel;

        static {
            NLS.initializeMessages((String)BasicDataControlObjectEditor.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

