/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenameWorkspaceRefactorProcess
extends AbstractRenameRefactorProcess {
    public static final boolean DEBUG_FILTERED_MODULES = false;

    protected AbstractRenameWorkspaceRefactorProcess() {
    }

    public AbstractRenameWorkspaceRefactorProcess(Definition definition) {
        super(definition);
    }

    protected List<ASTEntry> getOccurrencesInOtherModule(RefactoringStatus status, String initialName, SourceModule module, PythonNature nature) {
        new CompletionCache();
        List<ASTEntry> entryOccurrences = this.findReferencesOnOtherModule(status, initialName, module);
        return entryOccurrences;
    }

    protected abstract boolean getRecheckWhereDefinitionWasFound();

    @Override
    protected void findReferencesToRenameOnWorkspace(RefactoringRequest request, RefactoringStatus status) {
        block10: {
            request.getMonitor().beginTask("Find references on workspace", 100);
            try {
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 20));
                    this.findReferencesToRenameOnLocalScope(request, status);
                }
                finally {
                    request.popMonitor().done();
                }
                boolean onlyInLocalScope = (Boolean)request.getAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)false);
                if (onlyInLocalScope || status.hasFatalError()) break block10;
                request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 80));
                try {
                    this.doCheckInitialOnWorkspace(status, request);
                }
                finally {
                    request.popMonitor().done();
                }
            }
            finally {
                request.getMonitor().done();
            }
        }
    }

    protected void doCheckInitialOnWorkspace(RefactoringStatus status, RefactoringRequest request) {
        try {
            try {
                ArrayList<Tuple<List<ModulesKey>, IPythonNature>> references;
                request.getMonitor().beginTask("Check references on workspace", 100);
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 90));
                    references = this.findFilesWithPossibleReferences(request);
                }
                finally {
                    request.popMonitor().done();
                }
                int total = references.size();
                try {
                    request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 10));
                    request.getMonitor().beginTask("Analyzing references found", total);
                    int i = 0;
                    for (Tuple<List<ModulesKey>, IPythonNature> file : references) {
                        request.communicateWork(StringUtils.format((String)"Analyzing %s (%s of %s)", (Object[])new Object[]{((IPythonNature)file.o2).getProject(), ++i, total}));
                        PythonNature nature = (PythonNature)file.o2;
                        if (nature == null || !nature.startRequests()) continue;
                        try {
                            for (ModulesKey key : (List)file.o1) {
                                IProjectModulesManager modulesManager = (IProjectModulesManager)nature.getAstManager().getModulesManager();
                                request.checkCancelled();
                                String modName = key.name;
                                if (modName == null || request.moduleName.equals(modName)) continue;
                                request.checkCancelled();
                                IModule module = modulesManager.getModuleInDirectManager(modName, (IPythonNature)nature, false);
                                if (!(module instanceof SourceModule)) continue;
                                request.checkCancelled();
                                List<ASTEntry> entryOccurrences = this.getOccurrencesInOtherModule(status, request.initialName, (SourceModule)module, nature);
                                if (entryOccurrences.size() <= 0) continue;
                                this.addOccurrences(entryOccurrences, key.file, modName);
                            }
                        }
                        finally {
                            nature.endRequests();
                        }
                    }
                }
                finally {
                    request.popMonitor().done();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                request.getMonitor().done();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            request.getMonitor().done();
        }
    }

    protected abstract List<ASTEntry> findReferencesOnOtherModule(RefactoringStatus var1, String var2, SourceModule var3);
}

