/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.preferences.ConfiguratorEnablerComposite;
import org.eclipse.m2e.wtp.preferences.ConfiguratorEnabler;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferences;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferencesManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public class MavenWtpPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private Composite overrideComp;
    private Button overrideButton;
    private Link fChangeWorkspaceSettings;
    private Group earPrefGroup;
    private Button genApplicationXmlButton;
    private Group warPrefGroup;
    private Button warMavenArchiverButton;
    private Group configuratorEnablerGroup;
    private List<ConfiguratorEnablerComposite> enablersComposites;
    private Button enableM2eWtpButton;

    public MavenWtpPreferencePage() {
        this.setTitle(Messages.MavenWtpPreferencePage_JavaEE_Integration_Settings);
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainGroupLayout = new GridLayout();
        mainGroupLayout.numColumns = 1;
        main.setLayout((Layout)mainGroupLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        IProject project = this.getProject();
        this.createOverridePrefs(main, project);
        this.createGlobalPrefs(main);
        if (project == null || JavaEEProjectUtilities.isEARProject((IProject)project)) {
            this.createEarPrefs(main);
        }
        if (project == null || JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            this.createWarPrefs(main);
        }
        IMavenWtpPreferencesManager prefManager = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        this.fillValues(prefManager.getPreferences(project));
        if (project == null) {
            this.createJavaeeConfiguratorActivation(main, prefManager.getConfiguratorEnablers());
        }
        return main;
    }

    private void createJavaeeConfiguratorActivation(Composite main, ConfiguratorEnabler[] configuratorEnablers) {
        if (configuratorEnablers == null || configuratorEnablers.length == 0) {
            return;
        }
        this.configuratorEnablerGroup = new Group(main, 0);
        this.configuratorEnablerGroup.setText(Messages.MavenWtpPreferencePage_Select_Active_JavaEE_Configurators);
        GridDataFactory.fillDefaults().applyTo((Control)this.configuratorEnablerGroup);
        GridLayoutFactory.fillDefaults().margins(5, 0).applyTo((Composite)this.configuratorEnablerGroup);
        this.enablersComposites = new ArrayList<ConfiguratorEnablerComposite>(configuratorEnablers.length);
        ConfiguratorEnabler[] configuratorEnablerArray = configuratorEnablers;
        int n = configuratorEnablers.length;
        int n2 = 0;
        while (n2 < n) {
            ConfiguratorEnabler configuratorEnabler = configuratorEnablerArray[n2];
            ConfiguratorEnablerComposite enablerComposite = new ConfiguratorEnablerComposite((Composite)this.configuratorEnablerGroup, configuratorEnabler, 0);
            GridLayoutFactory.fillDefaults().margins(20, 0).applyTo((Composite)enablerComposite);
            this.enablersComposites.add(enablerComposite);
            ++n2;
        }
        this.toggleWidgets(this.enableM2eWtpButton.getSelection());
    }

    private void createGlobalPrefs(Composite main) {
        this.enableM2eWtpButton = new Button(main, 32);
        this.enableM2eWtpButton.setText("Enable Java EE configuration");
        this.enableM2eWtpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MavenWtpPreferencePage.this.toggleWidgets(MavenWtpPreferencePage.this.enableM2eWtpButton.getSelection());
            }
        });
    }

    private void createEarPrefs(Composite main) {
        this.earPrefGroup = new Group(main, 0);
        this.earPrefGroup.setText(Messages.MavenWtpPreferencePage_EAR_Project_Preferences);
        this.earPrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.earPrefGroup.setLayoutData((Object)new GridData(768));
        this.genApplicationXmlButton = new Button((Composite)this.earPrefGroup, 32);
        this.genApplicationXmlButton.setText(Messages.MavenWtpPreferencePage_Generate_ApplicationXml_Under_Build_Dir);
    }

    private void createOverridePrefs(Composite main, IProject project) {
        if (project != null) {
            this.overrideComp = new Composite(main, 0);
            GridLayout overrideCompLayout = new GridLayout();
            overrideCompLayout.numColumns = 2;
            overrideCompLayout.marginWidth = 0;
            overrideCompLayout.marginHeight = 0;
            this.overrideComp.setLayout((Layout)overrideCompLayout);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.overrideComp);
            this.overrideButton = new Button(this.overrideComp, 32);
            GridData gd = new GridData(768);
            this.overrideButton.setLayoutData((Object)gd);
            this.overrideButton.setText(Messages.MavenWtpPreferencePage_Enable_Project_Specific_Settings);
            this.overrideButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MavenWtpPreferencePage.this.setWidgetsEnabled(MavenWtpPreferencePage.this.overrideButton.getSelection());
                }
            });
            this.fChangeWorkspaceSettings = this.createLink(this.overrideComp, Messages.MavenWtpPreferencePage_Configure_Workspace_Settings);
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            Label horizontalLine = new Label(main, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(main.getFont());
        }
    }

    private void createWarPrefs(Composite main) {
        this.warPrefGroup = new Group(main, 0);
        this.warPrefGroup.setText(Messages.MavenWtpPreferencePage_WAR_Project_Preferences);
        this.warPrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.warPrefGroup.setLayoutData((Object)new GridData(768));
        this.warMavenArchiverButton = new Button((Composite)this.warPrefGroup, 32);
        this.warMavenArchiverButton.setText(Messages.MavenWtpPreferencePage_Generate_MavenArchiver_Files_Under_Build_Dir);
        this.warMavenArchiverButton.setToolTipText(Messages.MavenWtpPreferencePage_Using_Build_Directory);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setLayoutData((Object)new GridData(128));
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MavenWtpPreferencePage.this.openGlobalPrefs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MavenWtpPreferencePage.this.openGlobalPrefs();
            }
        });
        return link;
    }

    private void openGlobalPrefs() {
        String id = "org.eclipse.m2e.wtp.preferences.MavenWtpPreferencePage";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)this.getElement()).open();
    }

    protected void setWidgetsEnabled(boolean isEnabled) {
        if (this.fChangeWorkspaceSettings != null) {
            this.fChangeWorkspaceSettings.setEnabled(!isEnabled);
        }
        if (this.enableM2eWtpButton != null) {
            this.enableM2eWtpButton.setEnabled(isEnabled);
        }
        this.toggleWidgets(isEnabled);
    }

    private void fillValues(IMavenWtpPreferences preferences) {
        IProject project = this.getProject();
        if (project != null) {
            this.overrideButton.setSelection(preferences.isEnabledProjectSpecificSettings());
            this.setWidgetsEnabled(this.overrideButton.getSelection());
        }
        if (this.enableM2eWtpButton != null) {
            this.enableM2eWtpButton.setSelection(preferences.isEnabled());
        }
        if (this.genApplicationXmlButton != null) {
            this.genApplicationXmlButton.setSelection(preferences.isApplicationXmGeneratedInBuildDirectory());
        }
        if (this.warMavenArchiverButton != null) {
            this.warMavenArchiverButton.setSelection(preferences.isWebMavenArchiverUsesBuildDirectory());
        }
    }

    private void toggleWidgets(boolean enabled) {
        if (this.genApplicationXmlButton != null) {
            this.genApplicationXmlButton.setEnabled(enabled);
        }
        if (this.warMavenArchiverButton != null) {
            this.warMavenArchiverButton.setEnabled(enabled);
        }
        if (this.enablersComposites != null) {
            for (ConfiguratorEnablerComposite enablerComposite : this.enablersComposites) {
                enablerComposite.setEnabled(enabled);
            }
        }
    }

    public IProject getProject() {
        IAdaptable el = this.getElement();
        IProject p = el == null ? null : (IProject)el.getAdapter(IProject.class);
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IProject project = this.getProject();
        IMavenWtpPreferencesManager preferencesManager = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        IMavenWtpPreferences preferences = preferencesManager.getPreferences(project);
        IMavenWtpPreferences newPreferences = preferencesManager.createNewPreferences();
        if (project != null) {
            newPreferences.setEnabledProjectSpecificSettings(this.overrideButton.getSelection());
        }
        if (this.enableM2eWtpButton != null) {
            newPreferences.setEnabled(this.enableM2eWtpButton.getSelection());
        }
        if (this.genApplicationXmlButton != null) {
            newPreferences.setApplicationXmGeneratedInBuildDirectory(this.genApplicationXmlButton.getSelection());
        }
        if (this.warMavenArchiverButton != null) {
            newPreferences.setWebMavenArchiverUsesBuildDirectory(this.warMavenArchiverButton.getSelection());
        }
        if (this.enablersComposites != null) {
            for (ConfiguratorEnablerComposite enablerComposite : this.enablersComposites) {
                enablerComposite.savePreferences();
            }
        }
        if (!newPreferences.equals(preferences)) {
            preferencesManager.savePreferences(newPreferences, this.getProject());
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenWtpPreferencePage_Maven_JavaEE_Integration_Settings, (String)Messages.MavenWtpPreferencePage_Update_Projects_After_Preference_Changes);
            if (res) {
                this.updateImpactedProjects();
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IProject project = this.getProject();
        IMavenWtpPreferencesManager preferencesManager = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        IMavenWtpPreferences workspacePreferences = preferencesManager.getWorkspacePreferences();
        if (project == null) {
            workspacePreferences.setEnabled(true);
            workspacePreferences.setApplicationXmGeneratedInBuildDirectory(true);
            workspacePreferences.setWebMavenArchiverUsesBuildDirectory(true);
        }
        this.fillValues(workspacePreferences);
        if (this.enablersComposites != null) {
            for (ConfiguratorEnablerComposite enablerComposite : this.enablersComposites) {
                enablerComposite.setDefaultValue();
            }
        }
        super.performDefaults();
    }

    private void updateImpactedProjects() {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        final List<IMavenProjectFacade> facades = this.getImpactedProjects(projectManager);
        if (facades.isEmpty()) {
            return;
        }
        final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        WorkspaceJob job = new WorkspaceJob(Messages.MavenWtpPreferencePage_Updating_Maven_Projects_Job){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MavenWtpPreferencePage_Updating_Maven_Projects_Monitor, (int)100);
                    SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(facades.size() * 100));
                    for (IMavenProjectFacade facade : facades) {
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProject project = facade.getProject();
                        subProgress.subTask(NLS.bind((String)Messages.MavenWtpPreferencePage_Updating_Configuration_For_Project, (Object)project.getName()));
                        configurationManager.updateProjectConfiguration(project, (IProgressMonitor)subProgress);
                    }
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(configurationManager.getRule());
        job.schedule();
    }

    private List<IMavenProjectFacade> getImpactedProjects(IMavenProjectRegistry projectManager) {
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>();
        IProject project = this.getProject();
        if (project == null) {
            IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                if (this.isImpacted(facade)) {
                    facades.add(facade);
                }
                ++n2;
            }
        } else {
            facades.add(projectManager.getProject(project));
        }
        return facades;
    }

    private boolean isImpacted(IMavenProjectFacade facade) {
        return JEEPackaging.getValue(facade.getPackaging()) != null;
    }
}

