/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionEnabler;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProjectFacetConversionEnabler
extends AbstractProjectConversionEnabler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProjectFacetConversionEnabler.class);
    private IProjectFacet requiredFacet;

    public AbstractProjectFacetConversionEnabler(IProjectFacet requiredFacet) {
        this.requiredFacet = requiredFacet;
    }

    public boolean accept(IProject project) {
        if (project != null) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject != null && facetedProject.hasProjectFacet(this.requiredFacet);
            }
            catch (CoreException ex) {
                LOG.error(NLS.bind((String)Messages.AbstractProjectFacetConversionEnabler_Error_Accessing_Project, (Object)project.getName()), (Throwable)ex);
            }
        }
        return false;
    }
}

