/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.wtp.IMavenPackageFilter;
import org.eclipse.m2e.wtp.IProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.MarkedException;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.StringUtils;
import org.eclipse.m2e.wtp.internal.utilities.DebugUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractProjectConfiguratorDelegate
implements IProjectConfiguratorDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProjectConfiguratorDelegate.class);
    static final IClasspathAttribute NONDEPENDENCY_ATTRIBUTE = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"");
    protected static final IPath ROOT_PATH = new Path("/");
    protected final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
    protected final IMavenMarkerManager mavenMarkerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();

    AbstractProjectConfiguratorDelegate() {
    }

    @Override
    public void configureProject(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws MarkedException {
        try {
            this.mavenMarkerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration");
            this.configure(project, mavenProject, monitor);
        }
        catch (CoreException cex) {
            this.mavenMarkerManager.addErrorMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.wtp.configuration", (Exception)((Object)cex));
            throw new MarkedException(NLS.bind((String)Messages.AbstractProjectConfiguratorDelegate_Unable_To_Configure_Project, (Object)project.getName()), cex);
        }
    }

    protected abstract void configure(IProject var1, MavenProject var2, IProgressMonitor var3) throws CoreException;

    protected List<IMavenProjectFacade> getWorkspaceDependencies(IProject project, MavenProject mavenProject) {
        HashSet<IProject> projects = new HashSet<IProject>();
        ArrayList<IMavenProjectFacade> dependencies = new ArrayList<IMavenProjectFacade>();
        Set artifacts = mavenProject.getArtifacts();
        for (Artifact artifact : artifacts) {
            IMavenProjectFacade dependency = this.projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope()) || dependency == null || dependency.getProject().equals((Object)project) || dependency.getFullPath(artifact.getFile()) == null || !projects.add(dependency.getProject())) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    protected void configureWtpUtil(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        IPath[] resourceRoots;
        IProject project = facade.getProject();
        MavenProject mavenProject = facade.getMavenProject();
        if (!WTPProjectsUtil.isJavaProject(facade) || WTPProjectsUtil.isJavaEEProject(project) || WTPProjectsUtil.isQualifiedAsWebFragment(facade)) {
            return;
        }
        IPath[] sourceRoots = MavenProjectUtils.getSourceLocations((IProject)project, (List)mavenProject.getCompileSourceRoots());
        if (!this.checkJavaConfiguration(project, sourceRoots, resourceRoots = MavenProjectUtils.getResourceLocations((IProject)project, (List)mavenProject.getResources()))) {
            LOG.warn(NLS.bind((String)Messages.AbstractProjectConfiguratorDelegate_Error_Inconsistent_Java_Configuration, (Object)project.getName()));
            return;
        }
        boolean isDebugEnabled = DebugUtilities.isDebugEnabled();
        if (isDebugEnabled) {
            DebugUtilities.debug(DebugUtilities.dumpProjectState("Before configuration ", project));
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, project, facetedProject);
        if (!facetedProject.hasProjectFacet(WTPProjectsUtil.UTILITY_FACET)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, WTPProjectsUtil.UTILITY_10, null));
        } else if (!facetedProject.hasProjectFacet(WTPProjectsUtil.UTILITY_10)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, WTPProjectsUtil.UTILITY_10, null));
        }
        if (!actions.isEmpty()) {
            ResourceCleaner fileCleaner = new ResourceCleaner(project);
            try {
                this.addFoldersToClean(fileCleaner, facade);
                facetedProject.modify(actions, monitor);
            }
            finally {
                fileCleaner.cleanUp();
            }
        }
        this.fixMissingModuleCoreNature(project, monitor);
        if (isDebugEnabled) {
            DebugUtilities.debug(DebugUtilities.dumpProjectState("after configuration ", project));
        }
        this.removeTestFolderLinks(project, mavenProject, monitor, "/");
        if (isDebugEnabled) {
            DebugUtilities.debug(DebugUtilities.dumpProjectState("after removing test folders ", project));
        }
        this.setNonDependencyAttributeToContainer(project, monitor);
        WTPProjectsUtil.removeWTPClasspathContainer(project);
    }

    private boolean checkJavaConfiguration(IProject project, IPath[] sourceRoots, IPath[] resourceRoots) throws JavaModelException {
        IClasspathEntry mavenSource;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return false;
        }
        IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
        if (cpEntries == null) {
            return false;
        }
        HashSet<IPath> currentPaths = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (3 == entry.getEntryKind()) {
                currentPaths.add(entry.getPath().makeRelativeTo(project.getFullPath()));
            }
            ++n2;
        }
        iClasspathEntryArray = sourceRoots;
        n = sourceRoots.length;
        n2 = 0;
        while (n2 < n) {
            IFolder sourceFolder;
            mavenSource = iClasspathEntryArray[n2];
            if (mavenSource != null && !mavenSource.isEmpty() && (sourceFolder = project.getFolder((IPath)mavenSource)).exists() && !currentPaths.contains(mavenSource)) {
                return false;
            }
            ++n2;
        }
        iClasspathEntryArray = resourceRoots;
        n = resourceRoots.length;
        n2 = 0;
        while (n2 < n) {
            IFolder resourceFolder;
            mavenSource = iClasspathEntryArray[n2];
            if (mavenSource != null && !mavenSource.isEmpty() && (resourceFolder = project.getFolder((IPath)mavenSource)).exists() && !currentPaths.contains(mavenSource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void fixMissingModuleCoreNature(IProject project, IProgressMonitor monitor) throws CoreException {
        WTPProjectsUtil.fixMissingModuleCoreNature(project, monitor);
    }

    protected void installJavaFacet(Set<IFacetedProject.Action> actions, IProject project, IFacetedProject facetedProject) {
        WTPProjectsUtil.installJavaFacet(actions, project, facetedProject);
    }

    protected void removeTestFolderLinks(IProject project, MavenProject mavenProject, IProgressMonitor monitor, String folder) throws CoreException {
        WTPProjectsUtil.removeTestFolderLinks(project, mavenProject, monitor, folder);
    }

    protected void addContainerAttribute(IProject project, IClasspathAttribute attribute, IProgressMonitor monitor) throws JavaModelException {
        this.updateContainerAttributes(project, attribute, null, monitor);
    }

    protected void setNonDependencyAttributeToContainer(IProject project, IProgressMonitor monitor) throws JavaModelException {
        WTPProjectsUtil.updateContainerAttributes(project, NONDEPENDENCY_ATTRIBUTE, "org.eclipse.jst.component.dependency", monitor);
    }

    protected void updateContainerAttributes(IProject project, IClasspathAttribute attributeToAdd, String attributeToDelete, IProgressMonitor monitor) throws JavaModelException {
        WTPProjectsUtil.updateContainerAttributes(project, attributeToAdd, attributeToDelete, monitor);
    }

    protected IProject preConfigureDependencyProject(IMavenProjectFacade dependencyMavenProjectFacade, IProgressMonitor monitor) throws CoreException {
        IProject dependency = dependencyMavenProjectFacade.getProject();
        String depPackaging = dependencyMavenProjectFacade.getPackaging();
        if (!JEEPackaging.isJEEPackaging(depPackaging)) {
            this.configureWtpUtil(dependencyMavenProjectFacade, monitor);
        }
        return dependency;
    }

    protected void configureDeployedName(IProject project, String deployedFileName) {
        int extSeparatorPos = deployedFileName.lastIndexOf(46);
        String deployedName = extSeparatorPos > -1 ? deployedFileName.substring(0, extSeparatorPos) : deployedFileName;
        IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)project);
        if (projectComponent != null && !deployedName.equals(projectComponent.getDeployedName())) {
            StructureEdit moduleCore = null;
            try {
                WorkbenchComponent component;
                moduleCore = StructureEdit.getStructureEditForWrite((IProject)project);
                if (moduleCore != null && (component = moduleCore.getComponent()) != null) {
                    component.setName(deployedName);
                    moduleCore.saveIfNecessary(null);
                }
            }
            finally {
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
            }
        }
    }

    protected void linkFileFirst(IProject project, String sourceFile, String targetRuntimePath, IProgressMonitor monitor) throws CoreException {
        Path runtimePath = new Path(targetRuntimePath);
        WTPProjectsUtil.deleteLinks(project, (IPath)runtimePath, monitor);
        if (sourceFile != null) {
            WTPProjectsUtil.insertLinkFirst(project, (IPath)new Path(sourceFile), (IPath)new Path(targetRuntimePath), monitor);
        }
    }

    @Deprecated
    protected boolean hasChanged(IVirtualReference[] existingRefs, IVirtualReference[] refArray) {
        return WTPProjectsUtil.hasChanged(existingRefs, refArray);
    }

    @Override
    public void configureClasspath(IProject project, MavenProject mavenProject, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void setModuleDependencies(IProject project, MavenProject mavenProject, IProgressMonitor monitor) throws CoreException {
    }

    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        IPath p;
        IPath[] iPathArray = facade.getCompileSourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(p.append("META-INF/MANIFEST.MF"));
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        Path defaultResource = new Path("src/main/resources");
        fileCleaner.addFiles(defaultResource.append("META-INF/MANIFEST.MF"));
        fileCleaner.addFolder((IPath)defaultResource);
        IPath[] iPathArray2 = facade.getTestCompileSourceLocations();
        int n3 = iPathArray2.length;
        n = 0;
        while (n < n3) {
            IPath p2 = iPathArray2[n];
            if (p2 != null) {
                fileCleaner.addFolder(p2);
            }
            ++n;
        }
        iPathArray2 = facade.getTestResourceLocations();
        n3 = iPathArray2.length;
        n = 0;
        while (n < n3) {
            IPath p3 = iPathArray2[n];
            if (p3 != null) {
                fileCleaner.addFolder(p3);
            }
            ++n;
        }
    }

    protected void addComponentExclusionPatterns(IVirtualComponent component, IMavenPackageFilter filter) {
        String[] warSourceIncludes = filter.getSourceIncludes();
        String[] packagingIncludes = filter.getPackagingIncludes();
        String[] warSourceExcludes = filter.getSourceExcludes();
        String[] packagingExcludes = filter.getPackagingExcludes();
        if (warSourceIncludes.length > 0 && packagingIncludes.length > 0) {
            IFile pomFile = component.getProject().getFile("pom.xml");
            SourceLocation sourceLocation = filter.getSourceLocation();
            if (sourceLocation != null) {
                this.mavenMarkerManager.addMarker((IResource)pomFile, "org.eclipse.m2e.core.maven2Problem.wtp.configuration", NLS.bind((String)Messages.markers_inclusion_patterns_problem, (Object)filter.getSourceIncludeParameterName()), sourceLocation.getLineNumber(), 1);
            }
            warSourceIncludes = null;
        }
        String componentInclusions = StringUtils.joinAsString(warSourceIncludes, packagingIncludes);
        String componentExclusions = StringUtils.joinAsString(warSourceExcludes, packagingExcludes);
        Properties props = component.getMetaProperties();
        if (!componentInclusions.equals(props.getProperty("component.inclusion.patterns", ""))) {
            component.setMetaProperty("component.inclusion.patterns", componentInclusions);
        }
        if (!componentExclusions.equals(props.getProperty("component.exclusion.patterns", ""))) {
            component.setMetaProperty("component.exclusion.patterns", componentExclusions);
        }
    }
}

