/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public final class NodeCellEditorLocator
implements CellEditorLocator {
    private TextFigure textFigure;
    private DiagramConfigurationManager manager;

    public NodeCellEditorLocator(DiagramConfigurationManager manager, TextFigure textFigure) {
        this.manager = manager;
        this.setLabel(textFigure);
    }

    public void relocate(CellEditor celleditor) {
        Rectangle labelRect = this.textFigure.getClientArea();
        Rectangle parentRect = this.textFigure.getAvailableArea();
        double zoom = this.manager.getDiagramEditor().getZoomLevel();
        if (celleditor instanceof ComboBoxCellEditor) {
            GC gc = new GC((Drawable)((ComboBoxCellEditor)celleditor).getControl());
            int charHeight = gc.getFontMetrics().getHeight();
            gc.dispose();
            CellEditor.LayoutData layoutData = celleditor.getLayoutData();
            int offset = 0;
            if (layoutData.minimumWidth > labelRect.width && parentRect.x < labelRect.x) {
                offset = Math.min(layoutData.minimumWidth - labelRect.width, labelRect.x - parentRect.x);
            }
            CCombo combo = (CCombo)celleditor.getControl();
            this.textFigure.translateToAbsolute((Translatable)labelRect);
            combo.setBounds(labelRect.x - offset, labelRect.y, layoutData.minimumWidth, charHeight);
            return;
        }
        labelRect.x = parentRect.x;
        labelRect.width = parentRect.width;
        labelRect.width = (int)((double)labelRect.width * zoom);
        labelRect.height = (int)((double)labelRect.height * zoom);
        Text text = (Text)celleditor.getControl();
        Point size = text.computeSize(-1, -1);
        size.x = Math.min(size.x, labelRect.width);
        if (text.getText().length() == 0) {
            size.x = 10;
        }
        int horizontalOffet = 0;
        switch (this.textFigure.getHorizontalAlignment()) {
            case 131072: {
                if (size.x >= labelRect.width) break;
                horizontalOffet = labelRect.width - size.x;
                break;
            }
            case 16384: {
                break;
            }
            default: {
                if (size.x >= labelRect.width) break;
                horizontalOffet = (labelRect.width - size.x + 1) / 2;
            }
        }
        int verticalOffet = 0;
        switch (this.textFigure.getVerticalAlignment()) {
            case 1024: {
                if (size.y >= labelRect.height) break;
                verticalOffet = labelRect.height - size.y;
                break;
            }
            case 128: {
                break;
            }
            default: {
                if (size.y >= labelRect.height) break;
                verticalOffet = (labelRect.height - size.y + 1) / 2;
            }
        }
        size.x = Math.min(size.x, labelRect.width);
        size.y = Math.min(size.y, labelRect.height);
        this.textFigure.translateToAbsolute((Translatable)labelRect);
        text.setBounds(labelRect.x + horizontalOffet, labelRect.y + verticalOffet, size.x, size.y);
    }

    protected TextFigure getLabel() {
        return this.textFigure;
    }

    protected void setLabel(TextFigure textFigure) {
        this.textFigure = textFigure;
    }
}

