/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MavenJRETab
extends JavaJRETab {
    private VMArgumentsBlock vmArgumentsBlock = new VMArgumentsBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.vmArgumentsBlock.createControl(comp);
        ((GridData)this.vmArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.vmArgumentsBlock.performApply(configuration);
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.vmArgumentsBlock.initializeFrom(configuration);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.vmArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        IVMInstall defaultVMInstall = this.getDefaultVMInstall((ILaunchConfiguration)config);
        if (defaultVMInstall != null) {
            this.setDefaultVMInstallAttributes(defaultVMInstall, config);
        }
    }

    private IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        IVMInstall defaultVMInstall;
        try {
            defaultVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return defaultVMInstall;
    }

    private void setDefaultVMInstallAttributes(IVMInstall defaultVMInstall, ILaunchConfigurationWorkingCopy config) {
        String vmName = defaultVMInstall.getName();
        String vmTypeID = defaultVMInstall.getVMInstallType().getId();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

