/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.internal.launch.MavenLaunchPlugin;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class MavenLaunchUtils {
    public static AbstractMavenRuntime getMavenRuntime(ILaunchConfiguration configuration) throws CoreException {
        String name;
        MavenRuntimeManagerImpl runtimeManager = MavenPluginActivator.getDefault().getMavenRuntimeManager();
        AbstractMavenRuntime runtime = runtimeManager.getRuntime(name = configuration.getAttribute("M2_RUNTIME", ""));
        if (runtime == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.launching", -1, NLS.bind((String)Messages.MavenLaunchUtils_error_no_maven_install, (Object)name), null));
        }
        return runtime;
    }

    public static String getCliResolver(AbstractMavenRuntime runtime) throws CoreException {
        String runtimeVersion = runtime.getVersion();
        String jarname = runtimeVersion.startsWith("3.0") ? "org.eclipse.m2e.cliresolver30.jar" : (runtimeVersion.startsWith("3.") ? "org.eclipse.m2e.cliresolver31.jar" : "org.eclipse.m2e.cliresolver.jar");
        return MavenLaunchUtils.getBundleEntry(MavenLaunchPlugin.getDefault().getBundle(), jarname);
    }

    public static String getBundleEntry(Bundle bundle, String entryPath) throws CoreException {
        URL url = bundle.getEntry(entryPath);
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            URI fileURI = new URI(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPath(), fileURL.getQuery());
            return new File(fileURI).getCanonicalPath();
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.launching", -1, ex.getMessage(), (Throwable)ex));
        }
    }

    public static String quote(String string) {
        return string.indexOf(32) > -1 ? "\"" + string + "\"" : string;
    }

    public static String toPath(List<String> cp) {
        StringBuilder sb = new StringBuilder();
        for (String cpe : cp) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(cpe);
        }
        return sb.toString();
    }
}

