/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import org.eclipse.swt.widgets.Control;

public interface IUIInstrumentation {
    public static final String INSTRUMENT_FLAG = "oracle.eclipse.tools.xml.edit.ui.InstrumentFlag";

    public static enum InstrumentFlags {
        LABEL_IS_TITLE(1),
        LABEL_IS_PROPERTY(2);

        private final int _bitValue;

        private InstrumentFlags(int bitValue) {
            this._bitValue = bitValue;
        }

        public boolean isSet(Control control) {
            Integer data = InstrumentFlags.getData(control);
            if (data != null) {
                return (data & this._bitValue) != 0;
            }
            return false;
        }

        public void set(Control control) {
            Integer data = InstrumentFlags.getData(control);
            int newValue = data == null ? this._bitValue : data & this._bitValue;
            this.setData(control, newValue);
        }

        private void setData(Control control, Integer newValue) {
            control.setData(IUIInstrumentation.INSTRUMENT_FLAG, (Object)newValue);
        }

        private static Integer getData(Control control) {
            Object data = control.getData(IUIInstrumentation.INSTRUMENT_FLAG);
            if (data instanceof Integer) {
                return (Integer)data;
            }
            return null;
        }

        public static InstrumentFlags getFlag(Control control) {
            InstrumentFlags[] instrumentFlagsArray = InstrumentFlags.values();
            int n = instrumentFlagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                InstrumentFlags flag = instrumentFlagsArray[n2];
                if (flag.isSet(control)) {
                    return flag;
                }
                ++n2;
            }
            return null;
        }
    }
}

