/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.OEPETabbedPropertyUtil;
import oracle.eclipse.tools.xml.edit.ui.viewer.AbstractFieldGroupComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.ActionHyperlink;
import oracle.eclipse.tools.xml.edit.ui.viewer.FieldComposite;
import oracle.eclipse.tools.xml.edit.ui.viewer.GroupFactory;
import oracle.eclipse.tools.xml.edit.ui.viewer.IUIInstrumentation;
import oracle.eclipse.tools.xml.edit.ui.viewer.LayoutObjectComposite;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class CategoryFieldGroupComposite
extends AbstractFieldGroupComposite {
    public CategoryFieldGroupComposite(GroupFactory groupFactory, FieldGroupType fieldGroup, IControllerContext context, EObject eObject, ILabelProvider labelProvider) {
        super(groupFactory, fieldGroup, context, eObject, labelProvider);
    }

    @Override
    protected Composite createContainer(final Composite parent) {
        if (parent instanceof ScrolledComposite) {
            WidgetAdapter widgetAdapter = this.getContext().getWidgetAdapter();
            final Composite scrollableClient = (Composite)((ScrolledComposite)parent).getContent();
            Section section = widgetAdapter.createSection(scrollableClient, 2);
            OEPETabbedPropertyUtil.setTagHelp(this.getEObject(), (Control)section);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            section.setLayoutData((Object)data);
            section.clientVerticalSpacing = 5;
            section.marginHeight = 5;
            section.marginWidth = 5;
            String categoryName = this.getFieldGroup().getName() == null ? Messages.OtherProperties : this.getFieldGroup().getName().toString();
            section.setText(categoryName);
            IUIInstrumentation.InstrumentFlags.LABEL_IS_TITLE.set((Control)section);
            widgetAdapter.createCompositeSeparator((Composite)section);
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    CategoryFieldGroupComposite.computeScrollArea((ScrolledComposite)parent, scrollableClient, event.getState());
                    ((ScrolledComposite)parent).setMinSize(parent.computeSize(-1, -1));
                    parent.layout();
                }
            });
            Composite content = widgetAdapter.createComposite((Composite)section);
            GridLayout layout = new GridLayout(2, false);
            layout.marginBottom = 2;
            content.setLayout((Layout)layout);
            section.setClient((Control)content);
            return section;
        }
        return super.createContainer(parent);
    }

    private static void computeScrollArea(ScrolledComposite parentComposite, Composite childComposite, boolean isExpanded) {
        Point pt = childComposite.computeSize(-1, -1);
        parentComposite.setExpandHorizontal(isExpanded);
        parentComposite.setExpandVertical(isExpanded);
        parentComposite.setMinWidth(pt.x);
        parentComposite.setMinHeight(pt.y);
    }

    @Override
    protected List<LayoutObjectComposite.AttrControlPair> layoutChild(LayoutObjectComposite child) {
        Composite container = this._container;
        if (this._container instanceof Section) {
            container = (Composite)((Section)this._container).getClient();
        }
        ActionHyperlink propertyHyperlink = null;
        if (child instanceof FieldComposite) {
            FieldType field = ((FieldComposite)child).getField();
            IFormsPropertyDescriptor pd = field.getPropertyDescriptors();
            if (pd == null) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)Messages.bind((String)Messages.NoFormsPropertyDescriptor, (Object)(String.valueOf(field.getName()) + ':' + this.getEObject())));
                return Collections.emptyList();
            }
            IItemPropertyDescriptor ipd = pd.getItemPropertyDescriptor();
            if (!ipd.canSetProperty((Object)this.getEObject())) {
                return Collections.emptyList();
            }
            EAttribute feature = (EAttribute)pd.getFeature(this.getEObject());
            String name = this.getLabelProvider().getText((Object)pd);
            if (this.getContext().enableHyperlinks()) {
                List<IHyperlink> links = this.getContext().getHyperlinks(this.getEObject(), feature);
                if (links.size() > 0) {
                    propertyHyperlink = new ActionHyperlink(container, 0);
                    propertyHyperlink.setText(name);
                    propertyHyperlink.setToolTipText(Messages.HyperlinkTooltipMsg);
                    this.getContext().getWidgetAdapter().getHyperlinkGroup().add((Hyperlink)propertyHyperlink);
                    propertyHyperlink.setEnabled(true);
                    propertyHyperlink.setActions(links);
                    GridData data = new GridData();
                    data.horizontalSpan = 1;
                    data.horizontalAlignment = 4;
                    propertyHyperlink.setLayoutData(data);
                } else {
                    this.createPropertyLabel(container, name);
                }
            } else {
                this.createPropertyLabel(container, name);
            }
        }
        List<LayoutObjectComposite.AttrControlPair> pairs = child.createControls(container);
        if (child instanceof FieldComposite) {
            if (propertyHyperlink != null && propertyHyperlink.isEnabled()) {
                AbstractFieldGroupComposite.HyperlinkDisablementObservable hyperlinkObservable = new AbstractFieldGroupComposite.HyperlinkDisablementObservable(propertyHyperlink);
                IObservableValue modelObservable = ((FieldComposite)child).getBoundModelObservable();
                this.getContext().getDataBindingContext().bindValue((IObservableValue)hyperlinkObservable, modelObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            }
            this.setFirstPropertyEditor(((FieldComposite)child).getEditor());
        }
        return pairs;
    }

    private Label createPropertyLabel(Composite parent, String name) {
        Label propertyLabel = this.getContext().getWidgetAdapter().createLabel(parent, name);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        propertyLabel.setLayoutData((Object)data);
        IUIInstrumentation.InstrumentFlags.LABEL_IS_PROPERTY.set((Control)propertyLabel);
        return propertyLabel;
    }
}

