/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ActionHyperlink
extends Hyperlink {
    private static int orientation = Window.getDefaultOrientation();
    private Color disabledForeground = this.getDisplay().getSystemColor(2);
    private Color localForegroundCopy = JFaceColors.getHyperlinkText((Display)this.getDisplay());
    private HyperlinkActivator activator = new HyperlinkActivator();
    private boolean hyperlinkEnabled = true;
    private String savedToolTipText;
    private List<IHyperlink> actions;

    public ActionHyperlink(Composite parent, int style) {
        super(parent, style | orientation);
        this.addHyperlinkListener((IHyperlinkListener)this.activator);
    }

    public void dispose() {
        if (this.activator != null) {
            this.activator.dispose();
            this.activator = null;
        }
        super.dispose();
    }

    public void setDisabledForeground(Color dfg) {
        this.disabledForeground = dfg == null ? this.getDisplay().getSystemColor(2) : dfg;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setEnabled(boolean enabled) {
        this.setUnderlined(enabled);
        if (enabled) {
            this.setForeground(this.localForegroundCopy);
        } else {
            super.setForeground(this.getDisabledForeground());
        }
        this.setHyperlinkEnabled(enabled);
    }

    public void setToolTipText(String string) {
        this.savedToolTipText = string;
        super.setToolTipText(string);
    }

    private void setHyperlinkEnabled(boolean enabled) {
        this.hyperlinkEnabled = enabled;
        if (this.hyperlinkEnabled) {
            super.setToolTipText(this.savedToolTipText);
            this.addHyperlinkListener((IHyperlinkListener)this.activator);
        } else {
            super.setToolTipText("");
            this.removeHyperlinkListener((IHyperlinkListener)this.activator);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.localForegroundCopy = color == null ? JFaceColors.getHyperlinkText((Display)this.getDisplay()) : color;
    }

    public List<IHyperlink> getActions() {
        return this.actions == null ? (this.actions = new ArrayList<IHyperlink>()) : this.actions;
    }

    public void setActions(Collection<? extends IHyperlink> hyperlinks) {
        this.getActions().clear();
        this.getActions().addAll(hyperlinks);
    }

    public IHyperlink getAction() {
        return this.getActions().isEmpty() ? null : this.getActions().get(0);
    }

    public void setAction(IHyperlink hyperlink) {
        this.getActions().add(0, hyperlink);
    }

    private static class HyperlinkActivator
    extends HyperlinkAdapter {
        private Picker picker;

        private HyperlinkActivator() {
        }

        public void dispose() {
            this.picker = null;
        }

        public void linkActivated(HyperlinkEvent e) {
            if (e.widget instanceof ActionHyperlink) {
                ActionHyperlink link = (ActionHyperlink)e.widget;
                if (link.getActions().isEmpty()) {
                    link.setEnabled(false);
                } else if (link.getActions().size() == 1) {
                    link.getActions().get(0).open();
                } else {
                    HashMap<IFile, IHyperlink> map = new HashMap<IFile, IHyperlink>(link.getActions().size());
                    for (IHyperlink hyperlink : link.getActions()) {
                        if (!(hyperlink instanceof IAdaptable)) continue;
                        IFile file = (IFile)((IAdaptable)hyperlink).getAdapter(IFile.class);
                        if (file != null) {
                            map.put(file, hyperlink);
                            continue;
                        }
                        map = null;
                        break;
                    }
                    if (map == null) {
                        link.getActions().get(0).open();
                    } else {
                        Object file;
                        if (this.picker == null) {
                            this.picker = new Picker();
                        }
                        if (this.picker.getOpenCounter() == 0 && (file = this.picker.open((Control)link, map.keySet())) != null) {
                            ((IHyperlink)map.get(file)).open();
                        }
                    }
                }
            }
        }
    }

    private static class Picker {
        private int openCounter;

        private Picker() {
        }

        public int getOpenCounter() {
            return this.openCounter;
        }

        public <T> T open(Control parent, Collection<? extends T> elements) {
            return (T)this.open(parent, elements.toArray());
        }

        public <T> T open(Control parent, T[] elements) {
            Shell parentShell = parent.getShell();
            Display display = parent.getDisplay();
            int style = 16404;
            final Shell shell = new Shell(parentShell, style &= 0xFFFFFB07);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)shell);
            shell.setLocation(display.getCursorLocation());
            shell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 2) {
                        shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            });
            TableViewer tableViewer = new TableViewer((Composite)shell, 65556);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(tableViewer.getControl());
            final Object[] selection = new Object[1];
            tableViewer.getControl().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.item instanceof TableItem) {
                        selection[0] = ((TableItem)event.item).getData();
                        shell.close();
                    }
                }
            });
            ILabelProvider labelProvider = PlatformUI.isWorkbenchRunning() ? WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider() : new LabelProvider();
            tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            tableViewer.setSorter(new ViewerSorter());
            tableViewer.setInput(elements);
            tableViewer.getControl().pack();
            shell.pack();
            Listener displayFilter = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 3: {
                            if (shell.isDisposed() || event.widget.isDisposed() || !(event.widget instanceof Control)) break;
                            Control eventControl = (Control)event.widget;
                            Point mouseLocation = eventControl.toDisplay(event.x, event.y);
                            Rectangle shellBounds = shell.getBounds();
                            if (shellBounds.contains(mouseLocation)) break;
                            shell.close();
                        }
                    }
                }
            };
            try {
                ++this.openCounter;
                shell.open();
                display.addFilter(3, displayFilter);
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
            finally {
                --this.openCounter;
                if (!display.isDisposed()) {
                    display.removeFilter(3, displayFilter);
                }
            }
            return (T)selection[0];
        }
    }
}

