/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tagedit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.DocumentRoot;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.TagEditType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.util.TageditResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;

public class TagEditLoader {
    private ResourceSet _resSet = new ResourceSetImpl();
    private TagEditType _tagEdit;

    public TagEditLoader(URI uri) throws IOException {
        this();
        this.init(uri);
    }

    private TagEditLoader() {
        this.initResourceSet(this._resSet);
    }

    private void init(URI tleiFile) throws IOException {
        Resource tagEditRes = this._resSet.createResource(tleiFile);
        tagEditRes.load(Collections.EMPTY_MAP);
        if (!tagEditRes.getContents().isEmpty()) {
            DocumentRoot root = (DocumentRoot)tagEditRes.getContents().remove(0);
            this._tagEdit = root.getTagEdit();
            root.setTagEdit(null);
        }
        if (this._tagEdit == null) {
            throw new IOException("Could not get one or more models");
        }
    }

    private void initResourceSet(ResourceSet resourceSet) {
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
        resourceSet.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("tagedit", new TageditResourceFactoryImpl());
    }

    public TagEditType getTagEdit() {
        return this._tagEdit;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            TagEditLoader.error(CmdLineError.FILE_NOT_FOUND, String.format("Usage: %s <tagedit-dir> %n", TagEditLoader.class.getName()));
        }
        String dirName = args[0];
        try {
            File dir = new File(dirName);
            if (!dir.exists()) {
                throw new FileNotFoundException(dirName);
            }
            if (!dir.isDirectory()) {
                throw new FileNotFoundException(String.valueOf(dirName) + " must be a directory");
            }
            TagEditLoader.iterateDir(dir);
        }
        catch (FileNotFoundException e) {
            TagEditLoader.error(CmdLineError.FILE_NOT_FOUND, e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void iterateDir(File dir) throws IOException {
        File[] listFiles;
        System.out.println("Iterating dir: " + dir.getAbsolutePath());
        File[] fileArray = listFiles = dir.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                TagEditLoader.iterateDir(file);
            } else if (file.getName().endsWith(".tagedit")) {
                System.out.println("Loading: " + file.getName());
                new TagEditLoader(URI.createFileURI((String)file.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private static void error(CmdLineError code, String message) {
        System.err.println(code.toString());
        if (message != null) {
            System.err.println(message);
        }
        System.exit(code.toReturnCode());
    }

    private static enum CmdLineError {
        NOT_ENOUGH_ARGUMENTS,
        FILE_NOT_FOUND,
        GENERAL_IO_FAILURE;


        public String toString() {
            switch (this) {
                case FILE_NOT_FOUND: {
                    return "File not found";
                }
                case NOT_ENOUGH_ARGUMENTS: {
                    return "Not enough arguments";
                }
                case GENERAL_IO_FAILURE: {
                    return "General IO failure";
                }
            }
            throw new IllegalStateException();
        }

        public int toReturnCode() {
            switch (this) {
                case FILE_NOT_FOUND: {
                    return -1;
                }
                case NOT_ENOUGH_ARGUMENTS: {
                    return -2;
                }
                case GENERAL_IO_FAILURE: {
                    return -3;
                }
            }
            throw new IllegalStateException();
        }
    }
}

