/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.ITagTabDescriptorProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

public class TagTabDescriptorManager {
    public static final TagTabDescriptorManager INSTANCE = new TagTabDescriptorManager();
    private static final String EXTENSION_POINT_ID = "oracle.eclipse.tools.xml.edit.ui.tagTabDescriptorProviders";
    private List<TagTabDescriptorProviderHelper> helpers;
    private IRegistryEventListener registryEventListener;

    private TagTabDescriptorManager() {
    }

    public void reset() {
        this.helpers = null;
        if (this.registryEventListener != null) {
            Platform.getExtensionRegistry().removeListener(this.registryEventListener);
            this.registryEventListener = null;
        }
    }

    public List<ITabDescriptor> getTabDescriptors(IWorkbenchPart part, ISelection selection, int index, boolean lastIndex) {
        try {
            this.initialize();
            if (!this.helpers.isEmpty()) {
                ArrayList<ITabDescriptor> tabDescriptors = new ArrayList<ITabDescriptor>(this.helpers.size() * 2);
                Iterator<TagTabDescriptorProviderHelper> i = this.helpers.iterator();
                while (i.hasNext()) {
                    TagTabDescriptorProviderHelper helper = i.next();
                    if (helper.getTagTabDescriptorProvider() != null) {
                        if (helper.getPreferredPosition() != index && (!lastIndex || helper.getPreferredPosition() >= 0 && helper.getPreferredPosition() <= index)) continue;
                        tabDescriptors.addAll(helper.getTagTabDescriptorProvider().generateTabDescriptors(part, selection));
                        continue;
                    }
                    i.remove();
                }
                return tabDescriptors;
            }
        }
        catch (RuntimeException e) {
            Activator.log("An error occurred while handling the extension point oracle.eclipse.tools.xml.edit.ui.tagTabDescriptorProviders", e);
        }
        return new ArrayList<ITabDescriptor>(0);
    }

    private void initialize() {
        if (this.registryEventListener == null) {
            this.registryEventListener = new IRegistryEventListener(){

                public void added(IExtension[] extensions) {
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        TagTabDescriptorManager.this.initialize();
                        TagTabDescriptorManager.this.load(extension.getConfigurationElements());
                        ++n2;
                    }
                }

                public void removed(IExtension[] extensions) {
                    HashSet<String> contributorNames = new HashSet<String>(extensions.length / 2 + 1);
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IContributor contributor = extension.getContributor();
                        if (contributor != null && contributor.getName() != null && contributorNames.add(contributor.getName())) {
                            TagTabDescriptorManager.this.unload(contributor.getName());
                        }
                        ++n2;
                    }
                }

                public void added(IExtensionPoint[] extensionPoints) {
                }

                public void removed(IExtensionPoint[] extensionPoints) {
                }
            };
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            extensionRegistry.addListener(this.registryEventListener, EXTENSION_POINT_ID);
            IExtensionPoint point = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (point != null) {
                this.helpers = new ArrayList<TagTabDescriptorProviderHelper>();
                this.load(point.getConfigurationElements());
            }
        }
    }

    private void load(IConfigurationElement[] configurationElements) {
        if (this.helpers != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if ("tagTabDescriptorProvider".equals(configurationElement.getName()) && configurationElement.getAttribute("class") != null) {
                    this.helpers.add(new TagTabDescriptorProviderHelper(configurationElement));
                }
                ++n2;
            }
        }
    }

    private void unload(String contributorName) {
        if (this.helpers != null) {
            Iterator<TagTabDescriptorProviderHelper> i = this.helpers.iterator();
            while (i.hasNext()) {
                TagTabDescriptorProviderHelper helper = i.next();
                if (!helper.isFromContributor(contributorName)) continue;
                i.remove();
            }
        }
    }

    private static class TagTabDescriptorProviderHelper {
        private IConfigurationElement configurationElement;
        private ITagTabDescriptorProvider tabDescriptorProvider;
        private int preferredPosition = -1;
        private String contributorName;

        public TagTabDescriptorProviderHelper(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
            if (this.isValidConfigurationElement()) {
                try {
                    this.preferredPosition = Integer.parseInt(configurationElement.getAttribute("preferredPosition"));
                }
                catch (Exception exception) {}
            }
        }

        private boolean isValidConfigurationElement() {
            return this.configurationElement != null && this.configurationElement.isValid() && this.configurationElement.getContributor() != null;
        }

        public int getPreferredPosition() {
            return this.preferredPosition;
        }

        public ITagTabDescriptorProvider getTagTabDescriptorProvider() {
            if (this.tabDescriptorProvider == null && this.isValidConfigurationElement()) {
                Object object = null;
                try {
                    object = this.configurationElement.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Activator.log("Unable to create executable extension from " + this.configurationElement, (Exception)((Object)e));
                }
                if (object instanceof ITagTabDescriptorProvider) {
                    this.contributorName = this.configurationElement.getContributor().getName();
                    this.tabDescriptorProvider = (ITagTabDescriptorProvider)object;
                }
            }
            if (this.tabDescriptorProvider == null) {
                this.configurationElement = null;
            }
            return this.tabDescriptorProvider;
        }

        public boolean isFromContributor(String name) {
            return name != null && this.contributorName != null && this.contributorName.equals(name);
        }
    }
}

