/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.EObjectSection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TagAttrSearchDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.TagAttrSearchDialog";
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private TabbedPropertySheetPage _propertySheetPage;

    public TagAttrSearchDialog(Shell shell, TabbedPropertySheetPage propertySheetPage) {
        super(shell);
        this._propertySheetPage = propertySheetPage;
        this.setMessage(Messages.TagAttrSearchDialog_message);
        this.setSelectionHistory(new History());
        this.setTitle(Messages.TagAttrSearchDialog_title);
        this.setListLabelProvider(new LabelProvider());
        this.setDetailsLabelProvider(new DetailLabelProvider());
        this.setHelpAvailable(false);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings section;
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null && (section = (settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS)).getSection(DIALOG_BOUNDS_SETTINGS)) == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 300);
            section.put(DIALOG_WIDTH, 300);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new Filter();
    }

    protected Comparator<Info> getItemsComparator() {
        return new Comparator<Info>(){

            @Override
            public int compare(Info info0, Info info1) {
                Collator collator = Collator.getInstance();
                return collator.compare(info0.getId(), info1.getId());
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        ITabDescriptor[] tabDescriptors = this._propertySheetPage.getActiveTabs();
        TreeSet<Info> infos = new TreeSet<Info>();
        if (progressMonitor != null) {
            progressMonitor.beginTask(Messages.TagAttrSearchDialog_task, tabDescriptors.length);
        }
        ITabDescriptor[] iTabDescriptorArray = tabDescriptors;
        int n = tabDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor tabDescriptor = iTabDescriptorArray[n2];
            List sectionDescriptors = tabDescriptor.getSectionDescriptors();
            for (ISectionDescriptor sectionDescriptor : sectionDescriptors) {
                ISection section = sectionDescriptor.getSectionClass();
                if (section instanceof EObjectSection) {
                    EObjectSection eObjectSection = (EObjectSection)section;
                    FieldGroupType fieldGroup = eObjectSection.getFieldGroup();
                    for (FieldType field : fieldGroup.getField()) {
                        Info info = new Info(field.getName(), tabDescriptor);
                        if (infos.contains(info)) continue;
                        infos.add(info);
                    }
                }
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
            ++n2;
        }
        for (Info info : infos) {
            contentProvider.add((Object)info, itemsFilter);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    public String getElementName(Object item) {
        return ((Info)item).getId();
    }

    private static final class DetailLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private DetailLabelProvider() {
        }

        public Image getImage(Object element) {
            return Activator.Images.ATTRIBUTE.getImage();
        }

        public String getText(Object element) {
            if (element instanceof Info) {
                return ((Info)element).getDescription();
            }
            return null;
        }
    }

    private class Filter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public Filter() {
            super((FilteredItemsSelectionDialog)TagAttrSearchDialog.this);
        }

        public String getPattern() {
            return String.valueOf('?') + super.getPattern();
        }

        public boolean matchItem(Object item) {
            if (item instanceof Info) {
                Info info = (Info)item;
                String pattern = this.cleanPattern(this.getPattern());
                String propertyName = info.getId();
                if (propertyName.toLowerCase().contains(pattern.toLowerCase())) {
                    return true;
                }
            }
            return false;
        }

        private String cleanPattern(String pattern) {
            StringBuffer buffer = new StringBuffer(pattern.trim());
            int i = buffer.length() - 1;
            while (i >= 0) {
                if (Character.isWhitespace(buffer.charAt(i)) || '?' == buffer.charAt(i) || '*' == buffer.charAt(i)) {
                    buffer.deleteCharAt(i);
                }
                --i;
            }
            return buffer.toString();
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof Info;
        }
    }

    private static final class History
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private History() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }

    static final class Info
    implements Comparable<Info> {
        private final String _id;
        private final ITabDescriptor _tabDescriptor;

        public Info(String id, ITabDescriptor tabDescriptor) {
            this._id = id;
            this._tabDescriptor = tabDescriptor;
        }

        public String getId() {
            return this._id;
        }

        public ITabDescriptor getTabDescriptor() {
            return this._tabDescriptor;
        }

        public String getDescription() {
            return Messages.bind((String)Messages.TagAttrSearchDialog_description, (Object)this.getId());
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getClass().getSimpleName());
            buffer.append('(');
            buffer.append(this.getId());
            buffer.append(',');
            buffer.append(this.getTabDescriptor().getLabel());
            buffer.append(')');
            return buffer.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Info)) {
                return false;
            }
            Info that = (Info)obj;
            return this.getId() == null ? that.getId() == null : this.getId().equals(that.getId());
        }

        public int hashCode() {
            return this.getId() == null ? 0 : this.getId().hashCode();
        }

        @Override
        public int compareTo(Info o) {
            return this.getId().compareTo(o.getId());
        }
    }

    private static final class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return Activator.Images.ATTRIBUTE.getImage();
        }

        public String getText(Object element) {
            if (element instanceof Info) {
                return ((Info)element).getId();
            }
            return null;
        }
    }
}

