/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.common.services.document.IDisposable;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.TagEditContext;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.OEPETabbedPropertyUtil;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.TabDescriptor;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.AllSectionDescriptor;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.EObjectSectionDescriptor;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal.TagTabDescriptorManager;
import oracle.eclipse.tools.xml.edit.ui.viewer.CategoryContentProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.w3c.dom.Node;

public class OEPETabDescriptorProvider
implements ITabbedPropertySheetPageContributor,
ITabDescriptorProvider,
IDisposable {
    private static final String PROPERTY_CONTRIBUTOR = "oracle.eclipse.tools.xml.edit.ui.OEPETabDescriptorProvider";
    private static final String TAB_ID_PREFIX = "jst.pagedesigner.tabbed.properties.quickEdit.";
    private IStructuredContentProvider contentProvider;
    private IWorkbenchPart lastPart;
    private ISelection lastSelection;
    private ITabDescriptor[] lastTabDescriptors;

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        this.lastPart = null;
        this.lastSelection = null;
        this.lastTabDescriptors = null;
    }

    public String getContributorId() {
        return PROPERTY_CONTRIBUTOR;
    }

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (!part.equals(this.lastPart) || !selection.equals(this.lastSelection) || this.lastTabDescriptors == null) {
            this.lastPart = part;
            this.lastSelection = selection;
            this.lastTabDescriptors = this.computeTabDescriptors(part, selection);
        }
        return this.lastTabDescriptors;
    }

    private ITabDescriptor[] computeTabDescriptors(IWorkbenchPart part, ISelection selection) {
        Pair<EObject, Node> pair = OEPETabbedPropertyUtil.getTag(part, selection);
        if (pair.getFirst() != null) {
            boolean narrowLayout = OEPETabbedPropertyUtil.useNarrowLayout();
            ArrayList<TabDescriptor> tabDescriptors = new ArrayList<TabDescriptor>();
            Object[] sorted = this.getContentProvider().getElements(pair.getFirst());
            if (sorted instanceof FieldGroupType[]) {
                ArrayList<EObjectSectionDescriptor> sectionDescriptors = new ArrayList<EObjectSectionDescriptor>(sorted.length);
                FieldGroupType[] fieldGroupTypeArray = (FieldGroupType[])sorted;
                int n = fieldGroupTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FieldGroupType fieldGroup = fieldGroupTypeArray[n2];
                    if (fieldGroup.hasChildren()) {
                        sectionDescriptors.add(new EObjectSectionDescriptor(fieldGroup));
                    }
                    ++n2;
                }
                if (narrowLayout) {
                    TabDescriptor tabDescriptor = new TabDescriptor("oepe.NarrowTab", Messages.NarrowTab);
                    for (EObjectSectionDescriptor section : sectionDescriptors) {
                        section.setTargetTab(tabDescriptor.getId());
                        tabDescriptor.getSectionDescriptors().addAll(sectionDescriptors);
                    }
                    tabDescriptors.add(tabDescriptor);
                } else {
                    int index = 0;
                    int maxIndex = sectionDescriptors.size() - 1;
                    while (index <= maxIndex) {
                        EObjectSectionDescriptor sectionDescriptor = (EObjectSectionDescriptor)((Object)sectionDescriptors.get(index));
                        TabDescriptor tabDescriptor = new TabDescriptor(this.getEObjectTabId(sectionDescriptor.getFieldGroup(), (EObject)pair.getFirst()), sectionDescriptor.getFieldGroup().getName());
                        sectionDescriptor.setTargetTab(tabDescriptor.getId());
                        tabDescriptor.getSectionDescriptors().add(sectionDescriptor);
                        tabDescriptors.add(tabDescriptor);
                        if (index < maxIndex) {
                            tabDescriptors.addAll(TagTabDescriptorManager.INSTANCE.getTabDescriptors(part, selection, index, false));
                        }
                        ++index;
                    }
                }
            }
            tabDescriptors.addAll(TagTabDescriptorManager.INSTANCE.getTabDescriptors(part, selection, tabDescriptors.size() - 1, true));
            tabDescriptors.add((TabDescriptor)this.createAllTabDescriptor());
            return tabDescriptors.toArray(new ITabDescriptor[tabDescriptors.size()]);
        }
        return new ITabDescriptor[]{this.createAllTabDescriptor()};
    }

    private IStructuredContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new CategoryContentProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (WidgetAdapter)FormsWidgetAdapter.INSTANCE, TagEditContext.MODIFY_TAG);
        }
        return this.contentProvider;
    }

    private String getEObjectTabId(FieldGroupType fieldGroup, EObject eObject) {
        StringBuilder builder = new StringBuilder(TAB_ID_PREFIX);
        builder.append('[');
        builder.append(fieldGroup.getClass().getName());
        builder.append("].[");
        builder.append(fieldGroup.getKey());
        builder.append(']');
        builder.append(".[");
        builder.append(eObject.getClass());
        builder.append('@');
        builder.append(eObject.hashCode());
        builder.append(']');
        return builder.toString();
    }

    private ITabDescriptor createAllTabDescriptor() {
        TabDescriptor tabDescriptor = new TabDescriptor("oepe.AllTab", Messages.AllTab);
        tabDescriptor.getSectionDescriptors().add(new AllSectionDescriptor());
        return tabDescriptor;
    }

    private static class Messages
    extends NLS {
        public static String AllTab;
        public static String NarrowTab;

        static {
            NLS.initializeMessages((String)OEPETabDescriptorProvider.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

