/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.tabbedproperty.internal;

import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.common.FormsControllerContext;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.RadioFieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.tabbedproperty.BaseSection;
import oracle.eclipse.tools.xml.edit.ui.viewer.EObjectFieldGroupViewer;
import oracle.eclipse.tools.xml.edit.ui.viewer.PropertyDescriptorLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.w3c.dom.Node;

public class EObjectSection
extends BaseSection {
    private FieldGroupType _fieldGroup;
    private WidgetAdapter _widgetAdapter;
    private IFile _baseFile;
    private EObjectFieldGroupViewer _eObjectViewer;
    private IControllerContext _controllerContext;
    private ILabelProvider _labelProvider;

    public EObjectSection(FieldGroupType fieldGroup) {
        Assert.isNotNull((Object)fieldGroup);
        this._fieldGroup = fieldGroup;
        IFormsPropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd != null) {
            this._widgetAdapter = pd.getWidgetAdapter();
            this._baseFile = pd.getBaseFile();
        }
    }

    FieldGroupType getFieldGroup() {
        return this._fieldGroup;
    }

    EObjectFieldGroupViewer getFieldGroupViewer() {
        return this._eObjectViewer;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._controllerContext != null) {
            this._controllerContext.dispose();
            this._controllerContext = null;
        }
        if (this._eObjectViewer != null) {
            this._eObjectViewer.dispose();
            this._eObjectViewer = null;
        }
        if (this._labelProvider != null) {
            this._labelProvider.dispose();
            this._labelProvider = null;
        }
        this._fieldGroup = null;
        this._baseFile = null;
        this._widgetAdapter = null;
    }

    @Override
    protected WidgetAdapter getWidgetAdapter() {
        return this._widgetAdapter != null ? this._widgetAdapter : super.getWidgetAdapter();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this._controllerContext = new FormsControllerContext(this.getWidgetAdapter(), this._baseFile);
        this._eObjectViewer = new EObjectFieldGroupViewer(this._controllerContext, parent, this._fieldGroup);
        this._eObjectViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._labelProvider = new PropertyDescriptorLabelProvider();
        this._eObjectViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, EObject eObject, Node node) {
        this._eObjectViewer.setInput(eObject);
    }

    private IFormsPropertyDescriptor getPropertyDescriptor() {
        IFormsPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((List<FieldType>)this._fieldGroup.getField());
        if (propertyDescriptor == null) {
            for (RadioFieldGroupType rfg : this._fieldGroup.getRadioFieldGroup()) {
                propertyDescriptor = this.getPropertyDescriptor((List<FieldType>)rfg.getField());
                if (propertyDescriptor != null) break;
            }
        }
        return propertyDescriptor;
    }

    private IFormsPropertyDescriptor getPropertyDescriptor(List<FieldType> fields) {
        return fields.isEmpty() ? null : fields.get(0).getPropertyDescriptors();
    }
}

