/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FileChooserDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PageRelUriToResourceConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.ResourceToPageRelUriConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.ResourceToUriConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.UriToResourceConverter;
import oracle.eclipse.tools.xml.edit.ui.provider.AbstractDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.model.metadata.ossmd.util.EMFMDAdapter;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.common.metadata.Trait;

public class UriDialogCreationStrategyFactory
extends AbstractDialogCreationStrategyFactory {
    private static final String INCLUDE_URI_TRAIT_ID = "include-tag-uri-attribute";
    private static final String CONTENT_TYPE_ID = null;
    private static final boolean MULTIPLE_SELECTION = false;
    protected final boolean _absolute;

    public UriDialogCreationStrategyFactory(boolean absolute) {
        this._absolute = absolute;
    }

    @Override
    public DialogCreationStrategy create(IFormsPropertyDescriptor descriptor, EObject object, EStructuralFeature propertyFeature, AdapterFactory adapterFactory) {
        IObservableValue modelValue = EMFObservables.observeValue((EObject)object, (EStructuralFeature)propertyFeature);
        IFile baseFile = descriptor.getBaseFile();
        IProject iProject = baseFile.getProject();
        boolean allowCurrentFileSelection = this.allowCurrentFileSelection(baseFile, object);
        Converter toResourceConverter = this._absolute ? new UriToResourceConverter(iProject) : new PageRelUriToResourceConverter(baseFile);
        Converter toUriConverter = this._absolute ? new ResourceToUriConverter(baseFile) : new ResourceToPageRelUriConverter(baseFile);
        return new FileChooserDialogCreationStrategy(modelValue, iProject, CONTENT_TYPE_ID, Messages.UriDialogCreationStrategyFactory_title, Messages.UriDialogCreationStrategyFactory_treeLabel, false, Messages.UriDialogCreationStrategyFactory_validationMsg, allowCurrentFileSelection, baseFile, (IConverter)toResourceConverter, (IConverter)toUriConverter);
    }

    private boolean allowCurrentFileSelection(IFile file, EObject eObject) {
        EMFMDAdapter adapter = new EMFMDAdapter();
        Trait trait = adapter.getTagTrait(file, eObject.eClass(), INCLUDE_URI_TRAIT_ID);
        return trait == null;
    }
}

