/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.osgi.framework.Bundle;

public class URILoadingResourceLocator
implements ResourceLocator {
    private static final Map<String, URILoadingResourceLocator> CACHED_LOCATORS = new HashMap<String, URILoadingResourceLocator>();
    private final ResourceBundle _resBundle;
    private final Bundle _bundle;

    public static URILoadingResourceLocator getLocator(String uri) {
        URILoadingResourceLocator locator;
        block9: {
            locator = CACHED_LOCATORS.get(uri);
            if (locator != null) {
                return locator;
            }
            try {
                URI createURI = URI.createURI((String)uri);
                if (!createURI.isPlatformPlugin()) break block9;
                String bundleId = createURI.segment(1);
                ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl();
                try (InputStream in = converter.createInputStream(createURI);){
                    PropertyResourceBundle resBundle = new PropertyResourceBundle(in);
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (resBundle != null && bundle != null) {
                        locator = new URILoadingResourceLocator(bundle, resBundle);
                        CACHED_LOCATORS.put(uri, locator);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return locator;
    }

    private URILoadingResourceLocator(Bundle bundle, ResourceBundle resBundle) {
        this._resBundle = resBundle;
        this._bundle = bundle;
    }

    public URL getBaseURL() {
        return this._bundle.getEntry("/");
    }

    public Object getImage(String key) {
        return null;
    }

    public String getString(String key) {
        return this._resBundle.getString(key);
    }

    public String getString(String key, boolean translate) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getString(key);
    }
}

