/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.DialogInfoType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.DialogTypeKind;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldGroupType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.FieldType;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.LayoutObject;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.TagEditType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.MetadataEnhancedItemProvider;
import oracle.eclipse.tools.xml.edit.ui.provider.PropertyDescriptor;
import oracle.eclipse.tools.xml.edit.ui.provider.TagEditContext;
import oracle.eclipse.tools.xml.edit.ui.tagedit.TagEditMetaData;
import oracle.eclipse.tools.xml.model.metadata.ossmd.util.EMFMDAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

public class TagEditMetadataUtility {
    private static TagEditMetaData TAG_EDIT_METADATA = new TagEditMetaData(new EMFMDAdapter());
    static TagEditMetadataUtility INSTANCE = new TagEditMetadataUtility();

    private TagEditMetadataUtility() {
    }

    public FieldType getField(TagEditContext context, Object object, Object feature, WidgetAdapter widgetAdapter, MetadataEnhancedItemProvider.NameSuffixProvider nameSuffixProvider, ItemProviderAdapter itemProvider) {
        if (object instanceof EObject && feature instanceof EStructuralFeature) {
            EObject eObject = (EObject)object;
            EStructuralFeature esFeature = (EStructuralFeature)feature;
            EClass eClass = eObject.eClass();
            TagEditType tagEdit = TAG_EDIT_METADATA.getTagEdit(this.getFile(eObject), eClass, nameSuffixProvider.getSuffix(eObject));
            if (tagEdit == null || tagEdit.getDialogInfo().isEmpty()) {
                return null;
            }
            DialogInfoType dialogInfo = this.findDialogInfo(tagEdit, context);
            if (dialogInfo != null) {
                EList<FieldGroupType> registeredGroups = dialogInfo.getTopLevelGroups();
                return this.findField((List<FieldGroupType>)registeredGroups, esFeature.getName(), widgetAdapter, context, eObject, eClass, itemProvider);
            }
        }
        return null;
    }

    private FieldType findField(List<FieldGroupType> fieldGroups, String featureName, WidgetAdapter widgetAdapter, TagEditContext context, EObject eObject, EClass eClass, ItemProviderAdapter itemProvider) {
        for (FieldGroupType fieldGroup : fieldGroups) {
            FieldType field = this.findField(fieldGroup, featureName, widgetAdapter, context, eObject, eClass, itemProvider);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private FieldType findField(FieldGroupType fieldGroup, String featureName, WidgetAdapter widgetAdapter, TagEditContext context, EObject eObject, EClass eClass, ItemProviderAdapter itemProvider) {
        EList<LayoutObject> layoutObjects = fieldGroup.getLayoutObjects();
        for (LayoutObject layoutObject : layoutObjects) {
            FieldType field;
            if (layoutObject instanceof FieldGroupType) {
                field = this.findField((FieldGroupType)layoutObject, featureName, widgetAdapter, context, eObject, eClass, itemProvider);
                if (field == null) continue;
                return field;
            }
            if (!(layoutObject instanceof FieldType) || !(field = (FieldType)layoutObject).getName().equals(featureName)) continue;
            return this.prepareField(field, eClass, eObject, widgetAdapter, context, itemProvider);
        }
        return null;
    }

    private FieldType prepareField(FieldType field, EClass eClass, Object object, WidgetAdapter widgetAdapter, TagEditContext context, ItemProviderAdapter itemProvider) {
        IItemPropertyDescriptor desc;
        FieldType copy = (FieldType)EcoreUtil.copy((EObject)field);
        EStructuralFeature feature = eClass.getEStructuralFeature(field.getName());
        if (feature != null && (desc = itemProvider.getPropertyDescriptor(object, (Object)feature)) != null) {
            copy.setPropertyDescriptors(new PropertyDescriptor(object, desc, widgetAdapter, itemProvider.getAdapterFactory(), context));
        }
        return copy;
    }

    private DialogInfoType findDialogInfo(TagEditType tagEdit, TagEditContext context) {
        DialogTypeKind kind = context == TagEditContext.CREATE_TAG ? DialogTypeKind.INSERT : DialogTypeKind.MODIFY;
        DialogInfoType dialogInfo = this.matchDialogInfoType(tagEdit, kind);
        if (dialogInfo != null) {
            return dialogInfo;
        }
        return this.matchDialogInfoType(tagEdit, DialogTypeKind.INSERT_MODIFY);
    }

    private DialogInfoType matchDialogInfoType(TagEditType tagEdit, DialogTypeKind kind) {
        DialogInfoType dialogInfo = null;
        for (DialogInfoType findInfo : tagEdit.getDialogInfo()) {
            if (kind != findInfo.getKind()) continue;
            dialogInfo = findInfo;
            break;
        }
        return dialogInfo;
    }

    public boolean hasFieldGroups(TagEditContext context, Object object, MetadataEnhancedItemProvider.NameSuffixProvider nameSuffixProvider) {
        EObject eObject = (EObject)object;
        EClass eClass = eObject.eClass();
        TagEditType tagEdit = TAG_EDIT_METADATA.getTagEdit(this.getFile(eObject), eClass, nameSuffixProvider.getSuffix(eObject));
        if (tagEdit == null || tagEdit.getDialogInfo().isEmpty()) {
            return false;
        }
        DialogInfoType dialogInfo = this.findDialogInfo(tagEdit, context);
        if (dialogInfo == null) {
            return false;
        }
        return dialogInfo.getTopLevelGroups().size() > 0;
    }

    public List<FieldGroupType> getFieldGroups(TagEditContext context, Object object, WidgetAdapter widgetAdapter, MetadataEnhancedItemProvider.NameSuffixProvider nameSuffixProvider, ItemProviderAdapter itemProvider) {
        ArrayList<FieldGroupType> fieldGroups = new ArrayList<FieldGroupType>();
        if (object instanceof EObject) {
            EObject eObj = (EObject)object;
            EClass eClass = eObj.eClass();
            TagEditType tagEdit = TAG_EDIT_METADATA.getTagEdit(this.getFile(eObj), eClass, nameSuffixProvider.getSuffix(eObj));
            if (tagEdit == null || tagEdit.getDialogInfo().isEmpty()) {
                return Collections.emptyList();
            }
            DialogInfoType dialogInfo = this.findDialogInfo(tagEdit, context);
            if (dialogInfo != null) {
                EList<FieldGroupType> registeredGroups = dialogInfo.getTopLevelGroups();
                for (FieldGroupType fieldGroup : registeredGroups) {
                    FieldGroupType copy = (FieldGroupType)EcoreUtil.copy((EObject)fieldGroup);
                    this.updateGroup(copy, tagEdit, object, eClass, widgetAdapter, context, itemProvider);
                    fieldGroups.add(copy);
                }
            }
        }
        return fieldGroups;
    }

    private void updateGroup(FieldGroupType fieldGroup, TagEditType tagEdit, Object object, EClass eClass, WidgetAdapter widgetAdapter, TagEditContext context, ItemProviderAdapter itemProvider) {
        if (fieldGroup.getName() == null) {
            fieldGroup.setName(this.localizeGroupName(tagEdit, fieldGroup, object, itemProvider.getText(object)));
        }
        for (LayoutObject layoutObject : fieldGroup.getLayoutObjects()) {
            if (layoutObject instanceof FieldType) {
                this.updateField((FieldType)layoutObject, fieldGroup, eClass, object, widgetAdapter, context, itemProvider);
                continue;
            }
            if (!(layoutObject instanceof FieldGroupType)) continue;
            this.updateGroup((FieldGroupType)layoutObject, tagEdit, object, eClass, widgetAdapter, context, itemProvider);
        }
    }

    public String localizeGroupName(TagEditType tagEditType, FieldGroupType groupType, Object object, String objectName) {
        String key = groupType.getKey();
        if (key == null && !groupType.isBorderless()) {
            return TagEditMetadataUtility.cleanGroupName(objectName);
        }
        if (key != null) {
            return TagEditMetadataUtility.localize(tagEditType, key.toString());
        }
        return Messages.Other;
    }

    private static String cleanGroupName(String objectName) {
        StringBuffer clean = new StringBuffer();
        char[] cArray = objectName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '<' || c == '>' || c == '\r' || c == '\n') break;
            clean.append(c);
            ++n2;
        }
        return clean.toString();
    }

    private static String localize(TagEditType tagEditType, String key) {
        String translatedValue;
        ResourceLocator resLocator = tagEditType.getResourceLocator();
        String localizedValue = key;
        if (resLocator != null && (translatedValue = resLocator.getString(key)) != null) {
            localizedValue = translatedValue;
        }
        return localizedValue;
    }

    private void updateField(FieldType fieldType, FieldGroupType fieldTypeGroup, EClass eClass, Object object, WidgetAdapter widgetAdapter, TagEditContext context, ItemProviderAdapter itemProvider) {
        IItemPropertyDescriptor desc;
        if (fieldType.getName().startsWith("_")) {
            fieldTypeGroup.getField().remove((Object)fieldType);
            return;
        }
        EStructuralFeature feature = eClass.getEStructuralFeature(fieldType.getName());
        if (feature != null && (desc = itemProvider.getPropertyDescriptor(object, (Object)feature)) != null) {
            fieldType.setPropertyDescriptors(new PropertyDescriptor(object, desc, widgetAdapter, itemProvider.getAdapterFactory(), context));
        }
    }

    public IFile getFile(EObject eObj) {
        IAdaptable existingAdapter;
        Resource res = eObj.eResource();
        IFile file = null;
        if (res != null && (existingAdapter = (IAdaptable)EcoreUtil.getExistingAdapter((Notifier)res, IAdaptable.class)) != null) {
            file = (IFile)existingAdapter.getAdapter(IFile.class);
        }
        return file;
    }
}

