/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.documentservices.AttributeTypeAdapter;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit.MethodBodyTemplateType;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.MethodBindEditDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.provider.AbstractDialogCreationStrategyFactory;
import oracle.eclipse.tools.xml.edit.ui.provider.IFormsPropertyDescriptor;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MethodBindEditDialogCreationStrategyFactory
extends AbstractDialogCreationStrategyFactory {
    private static final String ACTION_METHOD_BODY_TEMPLATE = "oracle.eclipse.tools.webtier.jsf.ui.templateActionMethod";
    private static final String ACTION_LISTENER_METHOD_BODY_TEMPLATE = "oracle.eclipse.tools.webtier.jsf.ui.templateActionListenerMethod";
    private static final String VALIDATOR_METHOD_BODY_TEMPLATE = "oracle.eclipse.tools.webtier.jsf.ui.templateValidatorMethod";
    private static final String VALUE_CHANGE_LISTENER_METHOD_BODY_TEMPLATE = "oracle.eclipse.tools.webtier.jsf.ui.templateValueChangeListenerMethod";
    private static final Map<SubTypes, String> METHOD_BODY_MAP = new HashMap<SubTypes, String>();

    static {
        METHOD_BODY_MAP.put(SubTypes.JSF_ACTION_SUBTYPE, ACTION_METHOD_BODY_TEMPLATE);
        METHOD_BODY_MAP.put(SubTypes.JSF_ACTION_LISTENER_SUBTYPE, ACTION_LISTENER_METHOD_BODY_TEMPLATE);
        METHOD_BODY_MAP.put(SubTypes.JSF_VALIDATOR_SUBTYPE, VALIDATOR_METHOD_BODY_TEMPLATE);
        METHOD_BODY_MAP.put(SubTypes.JSF_VALUE_LISTENER_SUBTYPE, VALUE_CHANGE_LISTENER_METHOD_BODY_TEMPLATE);
    }

    private String getDefaultMethodBodyTemplateId(EStructuralFeature feature, IFormsPropertyDescriptor descriptor) {
        IDocument document = descriptor.getBaseDocument();
        SubTypes subtype = TleiAccess.INSTANCE.getSubtype(document, feature);
        return METHOD_BODY_MAP.get(subtype);
    }

    @Override
    public DialogCreationStrategy create(IFormsPropertyDescriptor descriptor, EObject object, EStructuralFeature propertyFeature, AdapterFactory adapterFactory) {
        IObservableValue modelValue = EMFObservables.observeValue((EObject)object, (EStructuralFeature)propertyFeature);
        IValidator validator = this.getFeatureValidator(propertyFeature);
        List<String> methodSignatures = this.getBinaryMethodSignatures(descriptor);
        String attributeName = new PropertyDescriptorLabelProvider().getText(descriptor);
        MethodBodyTemplateType userMethodBodyTemplate = descriptor.getMethodBodyTemplate();
        String userMethodBodyTemplateId = userMethodBodyTemplate == null ? null : userMethodBodyTemplate.getId();
        return new MethodBindEditDialogCreationStrategy(modelValue, validator, descriptor.getBaseDocument(), methodSignatures, attributeName, userMethodBodyTemplateId, this.getDefaultMethodBodyTemplateId(propertyFeature, descriptor));
    }

    protected List<String> getBinaryMethodSignatures(IFormsPropertyDescriptor descriptor) {
        AttributeTypeAdapter attrTypeAdapter = descriptor.getAttributeTypeAdapter();
        if (attrTypeAdapter == null) {
            return Collections.emptyList();
        }
        AttributeTypeAdapter.SupportedExpression expression = attrTypeAdapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.EL_METHOD_BINDING);
        Assert.isNotNull((Object)expression, (String)Messages.NoElMethodBindings);
        return expression.getValidSignatures();
    }

    private static final class PropertyDescriptorLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private PropertyDescriptorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFormsPropertyDescriptor) {
                IFormsPropertyDescriptor fpd = (IFormsPropertyDescriptor)element;
                Object feature = fpd.getFeature(null);
                if (feature instanceof EStructuralFeature) {
                    return ((EStructuralFeature)feature).getName();
                }
                return null;
            }
            if (element instanceof IPropertyDescriptor) {
                return ((IPropertyDescriptor)element).getId().toString();
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

