/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.provider.IDialogCreationStrategyFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;

public class DialogCreationStrategyReader {
    private static Map<String, FactoryDescriptor> _handlers = null;

    public static IDialogCreationStrategyFactory getFactory(String id) {
        FactoryDescriptor descriptor = DialogCreationStrategyReader.getAllHandlers().get(id);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getFactory();
    }

    static synchronized Map<String, FactoryDescriptor> getAllHandlers() {
        if (_handlers == null) {
            _handlers = DialogCreationStrategyReader.readAllHandlers();
        }
        return Collections.unmodifiableMap(_handlers);
    }

    private static Map<String, FactoryDescriptor> readAllHandlers() {
        HashMap<String, FactoryDescriptor> result = new HashMap<String, FactoryDescriptor>();
        Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.xml.edit.ui", (String)"dialogStrategyFactory");
        for (IExtension ext : extensions) {
            IConfigurationElement[] tagElementConfiguration;
            IConfigurationElement[] iConfigurationElementArray = tagElementConfiguration = ext.getConfigurationElements();
            int n = tagElementConfiguration.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String id = element.getAttribute("id");
                    IDialogCreationStrategyFactory factory = (IDialogCreationStrategyFactory)element.createExecutableExtension("class");
                    FactoryDescriptor descriptor = new FactoryDescriptor(id, factory);
                    result.put(id, descriptor);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
                ++n2;
            }
        }
        return result;
    }

    static class FactoryDescriptor {
        private final String _id;
        private final IDialogCreationStrategyFactory _factory;

        public FactoryDescriptor(String id, IDialogCreationStrategyFactory factory) {
            this._id = id;
            this._factory = factory;
        }

        public String getId() {
            return this._id;
        }

        public IDialogCreationStrategyFactory getFactory() {
            return this._factory;
        }
    }
}

