/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.metadata.ossmd.util.EMFMDAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;

public class StyleClassValuesContentProvider
implements IStructuredContentProvider {
    private static final String RUNTIME_VALUE_TYPE = "attribute-value-runtime-type";
    private static final String CSSSTYLECLASS = "org.eclipse.jst.jsf.core.attributevalues.CSSClassType";
    private static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    private static final String HTML_MD_URI = "HTML";
    private final IDocument _iDocument;

    public StyleClassValuesContentProvider(IDocument iDocument) {
        this._iDocument = iDocument;
    }

    public Object[] getElements(Object inputElement) {
        if (this._iDocument == null) {
            return null;
        }
        if (inputElement instanceof EObjectObservableValue) {
            EObjectObservableValue userModel = (EObjectObservableValue)inputElement;
            EClass eClass = ((EObject)userModel.getObserved()).eClass();
            EStructuralFeature feature = (EStructuralFeature)userModel.getValueType();
            return this.getStyleClassValues(eClass, feature);
        }
        return null;
    }

    private String[] getStyleClassValues(EClass eClass, EStructuralFeature feature) {
        IPossibleValues values = this.getPossibleValues(this._iDocument.getFile(), eClass, feature);
        if (values == null) {
            return null;
        }
        ArrayList<String> styleClassValues = new ArrayList<String>();
        for (Object styleClass : values.getPossibleValues()) {
            styleClassValues.add(((IPossibleValue)styleClass).getValue());
        }
        return styleClassValues.toArray(new String[styleClassValues.size()]);
    }

    private IPossibleValues getPossibleValues(IFile iFile, EClass eClass, EStructuralFeature feature) {
        Entity attrEntity;
        Entity tagEntity;
        EMFMDAdapter adapter = new EMFMDAdapter();
        if (ExtendedEcoreUtil.INSTANCE.getNamespaceUri(eClass).equals(XHTML_URI)) {
            adapter.addTranslationMapping(XHTML_URI, HTML_MD_URI);
        }
        if ((tagEntity = adapter.getTagEntity(iFile, eClass)) != null && (attrEntity = adapter.getTagEntity(iFile, eClass, feature)) != null) {
            List features;
            IMetaDataDomainContext mdContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(iFile);
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
            Trait runtimevalueType = query.getQueryHelper().getTrait(attrEntity, RUNTIME_VALUE_TYPE);
            if (runtimevalueType != null && TraitValueHelper.getValueAsString((Trait)runtimevalueType).equals(CSSSTYLECLASS) && (features = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPossibleValues.class, this.getStructuredDocContext(), this.getUri(attrEntity), tagEntity.getId(), attrEntity.getId())).size() > 0) {
                return (IPossibleValues)features.get(0);
            }
        }
        return null;
    }

    private String getUri(Entity entity) {
        return entity.getModel().getId();
    }

    private IStructuredDocumentContext getStructuredDocContext() {
        org.eclipse.jface.text.IDocument jfaceDoc = (org.eclipse.jface.text.IDocument)this._iDocument.getAdapter(org.eclipse.jface.text.IDocument.class);
        return IStructuredDocumentContextFactory.INSTANCE.getContext(jfaceDoc, 0);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

