/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ShuttleDialog<T>
extends SelectionDialog {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(ShuttleDialog.class);
    private boolean _orderSelectedItems = true;
    private boolean _allowMoveAllItems = true;
    private String _availableItemsLabelText;
    private String _availableItemsDetailsLabelText;
    private String _selectedItemsLabelText;
    private String _selectedItemsDetailsLabelText;
    private TreeViewer _availableItemsViewer;
    private TableViewer _selectedItemsViewer;
    private Object _availableItemsInput;
    private List<T> _allItems;
    private final LinkedList<T> _selectedItems = new LinkedList();
    private IStructuredContentProvider _availableItemsContentProvider;
    private ILabelProvider _availableItemsLabelProvider;
    private IStructuredContentProvider _selectedItemsContentProvider;
    private ILabelProvider _selectedItemsLabelProvider;
    private Button _rightBtn;
    private Button _leftBtn;
    private Button _rightAllBtn;
    private Button _leftAllBtn;
    private Button _upBtn;
    private Button _downBtn;
    private Button _topBtn;
    private Button _bottomBtn;
    private ISelectionChangedListener _availabeItemsSelectionListener;
    private ISelectionChangedListener _selectedItemsSelectionListener;
    private SelectionListener _rightBtnSelectionListener;
    private SelectionListener _leftBtnSelectionListener;
    private SelectionListener _rightAllBtnSelectionListener;
    private SelectionListener _leftAllBtnSelectionListener;
    private SelectionListener _upBtnSelectionListener;
    private SelectionListener _downBtnSelectionListener;
    private SelectionListener _topBtnSelectionListener;
    private SelectionListener _bottomBtnSelectionListener;
    private IDoubleClickListener _availabeItemsDoubleClickListener;
    private IDoubleClickListener _selectedItemsDoubleClickListener;
    private ListenerList _shuttleListeners = new ListenerList();

    public ShuttleDialog(Shell parentShell) {
        super(parentShell);
        this.init();
    }

    private void init() {
        this.createListeners();
    }

    protected String getAvailableItemsLabelText() {
        return this._availableItemsLabelText;
    }

    public void setAvailableItemsLabelText(String text) {
        this._availableItemsLabelText = text;
    }

    protected String getAvailableItemsDetailsLabelText() {
        return this._availableItemsDetailsLabelText;
    }

    public void setAvailableItemsDetailsLabelText(String text) {
        this._availableItemsDetailsLabelText = text;
    }

    protected String getSelectedItemsLabelText() {
        return this._selectedItemsLabelText;
    }

    public void setSelectedItemsLabelText(String text) {
        this._selectedItemsLabelText = text;
    }

    protected String getSelectedItemsDetailsLabelText() {
        return this._selectedItemsDetailsLabelText;
    }

    public void setSelectedItemsDetailsLabelText(String text) {
        this._selectedItemsDetailsLabelText = text;
    }

    public void setOrderSelectedItems(boolean orderSelected) {
        this._orderSelectedItems = orderSelected;
    }

    public boolean createDetailsLabel() {
        return this.getAvailableItemsDetailsLabelText() != null || this.getSelectedItemsDetailsLabelText() != null;
    }

    public void setAllowMoveAllItems(boolean allowMoveAll) {
        this._allowMoveAllItems = allowMoveAll;
    }

    public void setAllItemsInput(List<? extends T> input) {
        this._allItems = Collections.unmodifiableList(input);
    }

    public void setAvailableItemsContentProvider(IStructuredContentProvider sp) {
        this._availableItemsContentProvider = sp;
    }

    public void setAvailableItemsLabelProvider(ILabelProvider lp) {
        this._availableItemsLabelProvider = lp;
    }

    public void setInitiallySelectedItemsInput(List<? extends T> input) {
        this._selectedItems.clear();
        this._selectedItems.addAll(input);
    }

    public void setSelectedItemsInput(List<? extends T> input) {
        this.setInitiallySelectedItemsInput(input);
        this._selectedItemsViewer.refresh();
        this.setResult(this._selectedItems);
    }

    public List<T> getSelectedItems() {
        return Collections.unmodifiableList(this._selectedItems);
    }

    public List<T> getAvailableItems() {
        LinkedList<T> newList = new LinkedList<T>(this._allItems);
        newList.removeAll(this._selectedItems);
        return Collections.unmodifiableList(newList);
    }

    public Object getAvailableItemsInput() {
        return this._availableItemsInput;
    }

    public void setAvailableItemsInput(Object input) {
        this._availableItemsInput = input;
    }

    public void setSelectedItemsContentProvider(IStructuredContentProvider sp) {
        this._selectedItemsContentProvider = sp;
    }

    public void setSelectedItemsLabelProvider(ILabelProvider lp) {
        this._selectedItemsLabelProvider = lp;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridLayout layout = new GridLayout(this._orderSelectedItems ? 4 : 3, false);
        parent.setLayout((Layout)layout);
        Label msg = this.createMessageArea(parent);
        GridData msgData = new GridData(4, 4, true, false);
        msgData.horizontalSpan = this._orderSelectedItems ? 4 : 3;
        msg.setLayoutData((Object)msgData);
        this.createAvailableItemsComposite(parent);
        this.createMoveItemsButtonComposite(parent);
        this.createSelectedItemsComposite(parent);
        if (this._orderSelectedItems) {
            this.createOrderSelectedItemsButtonComposite(parent);
        }
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 280;
        data.minimumWidth = 520;
        data.heightHint = 350;
        data.widthHint = 550;
        parent.setLayoutData((Object)data);
        this.addListeners();
        this.resetButtonEnablement();
        return parent;
    }

    private void createAvailableItemsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        Label availableItemsLabel = new Label(composite, 16384);
        availableItemsLabel.setText(this.getAvailableItemsLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        availableItemsLabel.setLayoutData((Object)data);
        this._availableItemsViewer = new TreeViewer(composite, 2820);
        if (this._availableItemsContentProvider != null) {
            this._availableItemsViewer.setContentProvider((IContentProvider)this._availableItemsContentProvider);
        }
        if (this._availableItemsLabelProvider != null) {
            this._availableItemsViewer.setLabelProvider((IBaseLabelProvider)this._availableItemsLabelProvider);
        }
        this._availableItemsViewer.setInput(this.getAvailableItemsInput());
        this._availableItemsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleDialog.this.handleAddSelected();
            }
        });
        this.doSelectAvailableItem(this._availableItemsViewer);
        if (this.createDetailsLabel()) {
            Label availableItemsDetailLabel = new Label(composite, 16384);
            if (this.getAvailableItemsDetailsLabelText() != null) {
                availableItemsDetailLabel.setText(this.getAvailableItemsDetailsLabelText());
            }
        }
        data = new GridData(4, 4, true, true);
        Tree tree = this._availableItemsViewer.getTree();
        tree.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
    }

    protected void doSelectAvailableItem(TreeViewer viewer) {
    }

    protected TableViewer createSelectedItemsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        Label selectedItemsLabel = new Label(composite, 16384);
        selectedItemsLabel.setText(this.getSelectedItemsLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        selectedItemsLabel.setLayoutData((Object)data);
        this._selectedItemsViewer = new TableViewer(composite);
        if (this._selectedItemsContentProvider != null) {
            this._selectedItemsViewer.setContentProvider((IContentProvider)this._selectedItemsContentProvider);
        }
        if (this._selectedItemsLabelProvider != null) {
            this._selectedItemsViewer.setLabelProvider((IBaseLabelProvider)this._selectedItemsLabelProvider);
        }
        this._selectedItemsViewer.setInput(this._selectedItems);
        this._selectedItemsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleDialog.this.handleRemoveSelected();
            }
        });
        this.setResult(this._selectedItems);
        if (this.createDetailsLabel()) {
            Label selectedItemsDetailLabel = new Label(composite, 16384);
            if (this.getSelectedItemsDetailsLabelText() != null) {
                selectedItemsDetailLabel.setText(this.getSelectedItemsDetailsLabelText());
            }
        }
        data = new GridData(4, 4, true, true);
        Table table = this._selectedItemsViewer.getTable();
        table.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        return this._selectedItemsViewer;
    }

    private void createMoveItemsButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._rightBtn = new Button(composite, 8);
        this._rightBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_RIGHT));
        GridData data = new GridData(4, 0x1000000, false, false);
        this._rightBtn.setLayoutData((Object)data);
        this._leftBtn = new Button(composite, 8);
        this._leftBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_LEFT));
        this._leftBtn.setLayoutData((Object)data);
        if (this._allowMoveAllItems) {
            Label spacer = new Label(composite, 16384);
            spacer.setText("");
            spacer.setLayoutData((Object)data);
            this._rightAllBtn = new Button(composite, 8);
            this._rightAllBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_ALL_RIGHT));
            this._rightAllBtn.setToolTipText(_resourceLoader.resource("rightAllButtonToolTip", new Object[0]));
            this._rightAllBtn.setLayoutData((Object)data);
            this._leftAllBtn = new Button(composite, 8);
            this._leftAllBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_ALL_LEFT));
            this._leftAllBtn.setToolTipText(_resourceLoader.resource("leftAllButtonToolTip", new Object[0]));
            this._leftAllBtn.setLayoutData((Object)data);
        }
    }

    private void createOrderSelectedItemsButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, false, false);
        this._topBtn = new Button(composite, 8);
        this._topBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_TO_TOP));
        this._topBtn.setToolTipText(_resourceLoader.resource("topButtonToolTip", new Object[0]));
        this._topBtn.setLayoutData((Object)data);
        this._upBtn = new Button(composite, 8);
        this._upBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_UP));
        this._upBtn.setToolTipText(_resourceLoader.resource("upButtonToolTip", new Object[0]));
        this._upBtn.setLayoutData((Object)data);
        Label spacer = new Label(composite, 16384);
        spacer.setText("");
        spacer.setLayoutData((Object)data);
        this._downBtn = new Button(composite, 8);
        this._downBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_DOWN));
        this._downBtn.setToolTipText(_resourceLoader.resource("downButtonToolTip", new Object[0]));
        this._downBtn.setLayoutData((Object)data);
        this._bottomBtn = new Button(composite, 8);
        this._bottomBtn.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_TO_BOTTOM));
        this._bottomBtn.setToolTipText(_resourceLoader.resource("bottomButtonToolTip", new Object[0]));
        this._bottomBtn.setLayoutData((Object)data);
    }

    private void handleAddSelected() {
        ITreeSelection treeSelection;
        TreePath[] paths;
        IStructuredSelection selection = (IStructuredSelection)this._availableItemsViewer.getSelection();
        if (selection instanceof ITreeSelection && (paths = (treeSelection = (ITreeSelection)selection).getPaths()).length > 0 && this.allowAddSelected(paths[0])) {
            ArrayList<TreePath> toMove = new ArrayList<TreePath>();
            toMove.add(paths[0]);
            this.moveItemsToSelected(toMove);
        }
        this.resetButtonEnablement();
    }

    protected boolean allowAddSelected(TreePath path) {
        return true;
    }

    private void handleRemoveSelected() {
        IStructuredSelection selection = (IStructuredSelection)this._selectedItemsViewer.getSelection();
        if (selection != null) {
            this.removeItemsFromSelected(selection.toList());
        }
        this.resetButtonEnablement();
    }

    private void createListeners() {
        this._rightBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShuttleDialog.this.handleAddSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._leftBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShuttleDialog.this.handleRemoveSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._rightAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List items = (List)ShuttleDialog.this._availableItemsViewer.getInput();
                ShuttleDialog.this.moveItemsToSelected(items);
                ShuttleDialog.this.resetButtonEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._leftAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShuttleDialog.this.removeItemsFromSelected(ShuttleDialog.this._selectedItems);
                ShuttleDialog.this.resetButtonEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._upBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ShuttleDialog.this._selectedItems.get(0).equals(itemsToMove.get(0))) {
                        ArrayList items = new ArrayList(ShuttleDialog.this._selectedItems);
                        int i = 1;
                        while (i < items.size()) {
                            if (itemsToMove.contains(items.get(i))) {
                                Object item = ShuttleDialog.this._selectedItems.remove(i);
                                ShuttleDialog.this._selectedItems.add(i - 1, item);
                            }
                            ++i;
                        }
                        ShuttleDialog.this._selectedItemsViewer.refresh();
                        ShuttleDialog.this.setResult(ShuttleDialog.this._selectedItems);
                    }
                }
                ShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._downBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ShuttleDialog.this._selectedItems.get(ShuttleDialog.this._selectedItems.size() - 1).equals(itemsToMove.get(itemsToMove.size() - 1))) {
                        ArrayList items = new ArrayList(ShuttleDialog.this._selectedItems);
                        int i = items.size() - 2;
                        while (i >= 0) {
                            if (itemsToMove.contains(items.get(i))) {
                                Object item = ShuttleDialog.this._selectedItems.remove(i);
                                ShuttleDialog.this._selectedItems.add(i + 1, item);
                            }
                            --i;
                        }
                        ShuttleDialog.this._selectedItemsViewer.refresh();
                        ShuttleDialog.this.setResult(ShuttleDialog.this._selectedItems);
                    }
                }
                ShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._topBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ShuttleDialog.this._selectedItems.get(0).equals(itemsToMove.get(0))) {
                        ShuttleDialog.this._selectedItems.removeAll(itemsToMove);
                        int i = itemsToMove.size() - 1;
                        while (i >= 0) {
                            ShuttleDialog.this._selectedItems.addFirst(itemsToMove.get(i));
                            --i;
                        }
                        ShuttleDialog.this._selectedItemsViewer.refresh();
                        ShuttleDialog.this.setResult(ShuttleDialog.this._selectedItems);
                    }
                }
                ShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._bottomBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ShuttleDialog.this._selectedItems.get(ShuttleDialog.this._selectedItems.size() - 1).equals(itemsToMove.get(itemsToMove.size() - 1))) {
                        ShuttleDialog.this._selectedItems.removeAll(itemsToMove);
                        int i = 0;
                        while (i < itemsToMove.size()) {
                            ShuttleDialog.this._selectedItems.addLast(itemsToMove.get(i));
                            ++i;
                        }
                        ShuttleDialog.this._selectedItemsViewer.refresh();
                        ShuttleDialog.this.setResult(ShuttleDialog.this._selectedItems);
                    }
                }
                ShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._availabeItemsSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ShuttleDialog.this._rightBtn.setEnabled(ShuttleDialog.this.enableShuffleRightButton(event));
                ShuttleDialog.this._leftBtn.setEnabled(false);
                ShuttleDialog.this.setMoveAllItemsButtonEnablement();
                if (ShuttleDialog.this._orderSelectedItems) {
                    ShuttleDialog.this._upBtn.setEnabled(false);
                    ShuttleDialog.this._downBtn.setEnabled(false);
                    ShuttleDialog.this._topBtn.setEnabled(false);
                    ShuttleDialog.this._bottomBtn.setEnabled(false);
                }
                ShuttleDialog.this._selectedItemsViewer.removeSelectionChangedListener(ShuttleDialog.this._selectedItemsSelectionListener);
                Table table = ShuttleDialog.this._selectedItemsViewer.getTable();
                table.deselectAll();
                ShuttleDialog.this._selectedItemsViewer.addSelectionChangedListener(ShuttleDialog.this._selectedItemsSelectionListener);
            }
        };
        this._selectedItemsSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel;
                ShuttleDialog.this._rightBtn.setEnabled(false);
                if (ShuttleDialog.this._selectedItems.isEmpty()) {
                    ShuttleDialog.this._leftBtn.setEnabled(false);
                } else {
                    ShuttleDialog.this._leftBtn.setEnabled(true);
                }
                ShuttleDialog.this.setMoveAllItemsButtonEnablement();
                if (ShuttleDialog.this._orderSelectedItems && !(sel = event.getSelection()).isEmpty() && sel instanceof IStructuredSelection) {
                    ShuttleDialog.this.setOrderSelectedItemsButtonEnablement((IStructuredSelection)sel);
                }
                ShuttleDialog.this._availableItemsViewer.removeSelectionChangedListener(ShuttleDialog.this._availabeItemsSelectionListener);
                Tree tree = ShuttleDialog.this._availableItemsViewer.getTree();
                tree.deselectAll();
                ShuttleDialog.this._availableItemsViewer.addSelectionChangedListener(ShuttleDialog.this._availabeItemsSelectionListener);
            }
        };
        this._availabeItemsDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleDialog.this.handleAddSelected();
            }
        };
        this._selectedItemsDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ShuttleDialog.this.handleRemoveSelected();
            }
        };
    }

    protected boolean enableShuffleRightButton(SelectionChangedEvent event) {
        return true;
    }

    private void addListeners() {
        this._rightBtn.addSelectionListener(this._rightBtnSelectionListener);
        this._leftBtn.addSelectionListener(this._leftBtnSelectionListener);
        if (this._allowMoveAllItems) {
            this._rightAllBtn.addSelectionListener(this._rightAllBtnSelectionListener);
            this._leftAllBtn.addSelectionListener(this._leftAllBtnSelectionListener);
        }
        if (this._orderSelectedItems) {
            this._upBtn.addSelectionListener(this._upBtnSelectionListener);
            this._downBtn.addSelectionListener(this._downBtnSelectionListener);
            this._topBtn.addSelectionListener(this._topBtnSelectionListener);
            this._bottomBtn.addSelectionListener(this._bottomBtnSelectionListener);
        }
        this._availableItemsViewer.addSelectionChangedListener(this._availabeItemsSelectionListener);
        this._availableItemsViewer.addDoubleClickListener(this._availabeItemsDoubleClickListener);
        this._selectedItemsViewer.addSelectionChangedListener(this._selectedItemsSelectionListener);
        this._selectedItemsViewer.addDoubleClickListener(this._selectedItemsDoubleClickListener);
    }

    public void addShuttleListener(IShuttleListener<T> listener) {
        this._shuttleListeners.add(listener);
    }

    public void removeShuttleListener(IShuttleListener<T> listener) {
        this._shuttleListeners.remove(listener);
    }

    private void notifyMoveItemsToSelected(List<T> items) {
        Object[] listeners = this._shuttleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShuttleListener)listeners[i]).moveItemsToSelected(items);
            ++i;
        }
    }

    private void notifyRemoveItemsFromSelected(List<T> items) {
        Object[] listeners = this._shuttleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShuttleListener)listeners[i]).removeItemsFromSelected(items);
            ++i;
        }
    }

    private void moveItemsToSelected(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this._selectedItems.addAll(items);
        this._selectedItemsViewer.refresh();
        this.setResult(this._selectedItems);
        this.notifyMoveItemsToSelected(items);
    }

    private void removeItemsFromSelected(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this._selectedItems.removeAll(items);
        this._selectedItemsViewer.refresh();
        this.setResult(this._selectedItems);
        this.notifyRemoveItemsFromSelected(items);
    }

    protected void resetButtonEnablement() {
        this._rightBtn.setEnabled(false);
        this._leftBtn.setEnabled(false);
        this.setMoveAllItemsButtonEnablement();
        if (this._orderSelectedItems) {
            this._upBtn.setEnabled(false);
            this._downBtn.setEnabled(false);
            this._topBtn.setEnabled(false);
            this._bottomBtn.setEnabled(false);
        }
    }

    protected void setMoveAllItemsButtonEnablement() {
        if (this._allowMoveAllItems) {
            List availableItems = (List)this._availableItemsViewer.getInput();
            this._rightAllBtn.setEnabled(!availableItems.isEmpty());
            this._leftAllBtn.setEnabled(!this._selectedItems.isEmpty());
        }
    }

    protected void setOrderSelectedItemsButtonEnablement(IStructuredSelection selection) {
        if (this._orderSelectedItems && selection != null) {
            if (selection.size() == 0) {
                this._upBtn.setEnabled(false);
                this._topBtn.setEnabled(false);
                this._downBtn.setEnabled(false);
                this._bottomBtn.setEnabled(false);
            } else {
                List items = selection.toList();
                if (this._selectedItems.get(0).equals(items.get(0))) {
                    this._upBtn.setEnabled(false);
                    this._topBtn.setEnabled(false);
                } else {
                    this._upBtn.setEnabled(true);
                    this._topBtn.setEnabled(true);
                }
                if (this._selectedItems.get(this._selectedItems.size() - 1).equals(items.get(items.size() - 1))) {
                    this._downBtn.setEnabled(false);
                    this._bottomBtn.setEnabled(false);
                } else {
                    this._downBtn.setEnabled(true);
                    this._bottomBtn.setEnabled(true);
                }
            }
        }
    }

    public static interface IShuttleListener<T> {
        public void removeItemsFromSelected(List<T> var1);

        public void moveItemsToSelected(List<T> var1);
    }
}

