/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdPathUtil {
    private static final String DVT_URI = "http://xmlns.oracle.com/dss/adf/faces";
    private static final String FACES_URI = "http://xmlns.oracle.com/adf/faces/rich";
    private static final Set<String> DVT_TAGS = new HashSet<String>();
    private static final Set<String> FACES_TAGS;
    private static final String ID_ATTR_NAME = "id";

    static {
        DVT_TAGS.add("areaGraph");
        DVT_TAGS.add("areaDataLayer");
        DVT_TAGS.add("areaLayer");
        DVT_TAGS.add("barGraph");
        DVT_TAGS.add("bubbleGraph");
        DVT_TAGS.add("comboGraph");
        DVT_TAGS.add("customAreaLayer");
        DVT_TAGS.add("dataCell");
        DVT_TAGS.add("diagramLinks");
        DVT_TAGS.add("diagramNodes");
        DVT_TAGS.add("dualYBarGraph");
        DVT_TAGS.add("dualYComboGraph");
        DVT_TAGS.add("dualYLineGraph");
        DVT_TAGS.add("funnelGraph");
        DVT_TAGS.add("gauge");
        DVT_TAGS.add("graph");
        DVT_TAGS.add("headerCell");
        DVT_TAGS.add("hierarchyViewer");
        DVT_TAGS.add("horizontalBarGraph");
        DVT_TAGS.add("horizontalStackedBarGraph");
        DVT_TAGS.add("lineGraph");
        DVT_TAGS.add("map");
        DVT_TAGS.add("meshNodes");
        DVT_TAGS.add("paletteLinkDefs");
        DVT_TAGS.add("paletteSection");
        DVT_TAGS.add("paretoGraph");
        DVT_TAGS.add("pieGraph");
        DVT_TAGS.add("pivotFilterBar");
        DVT_TAGS.add("pivotTable");
        DVT_TAGS.add("pointDataLayer");
        DVT_TAGS.add("projectGantt");
        DVT_TAGS.add("radarGraph");
        DVT_TAGS.add("resourceUtilizationGantt");
        DVT_TAGS.add("scatterGraph");
        DVT_TAGS.add("schedulingGantt");
        DVT_TAGS.add("searchResults");
        DVT_TAGS.add("stackedBarGraph");
        DVT_TAGS.add("stockCandleGraph");
        DVT_TAGS.add("stockGraph");
        DVT_TAGS.add("sunburst");
        DVT_TAGS.add("thematicMap");
        DVT_TAGS.add("timeline");
        DVT_TAGS.add("timelineSeries");
        DVT_TAGS.add("treemap");
        FACES_TAGS = new HashSet<String>();
        FACES_TAGS.add("breadCrumbs");
        FACES_TAGS.add("calendar");
        FACES_TAGS.add("carousel");
        FACES_TAGS.add("declarativeComponent");
        FACES_TAGS.add("iterator");
        FACES_TAGS.add("listView");
        FACES_TAGS.add("navigationPane");
        FACES_TAGS.add("pageTemplate");
        FACES_TAGS.add("panelCollection");
        FACES_TAGS.add("query");
        FACES_TAGS.add("quickQuery");
        FACES_TAGS.add("region");
        FACES_TAGS.add("subform");
        FACES_TAGS.add("table");
        FACES_TAGS.add("train");
        FACES_TAGS.add("trainButtonBar");
        FACES_TAGS.add("tree");
        FACES_TAGS.add("treeTable");
    }

    private IdPathUtil() {
        throw new AssertionError((Object)"Should never be instantiated!");
    }

    public static boolean isContainer(IDOMElement element) {
        return IdPathUtil.isContainer(element, FACES_URI, FACES_TAGS) ? true : IdPathUtil.isContainer(element, DVT_URI, DVT_TAGS);
    }

    private static boolean isContainer(IDOMElement element, String uri, Set<String> tags) {
        if (IdPathUtil.hasUri(uri, element)) {
            String tagName = element.getLocalName();
            return tags.contains(tagName);
        }
        return false;
    }

    private static boolean hasUri(String uri, IDOMElement element) {
        NamedNodeMap attributes;
        Element docElement;
        Document ownerDoc = element.getOwnerDocument();
        if (ownerDoc != null && (docElement = ownerDoc.getDocumentElement()) != null && (attributes = docElement.getAttributes()) != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                IDOMAttr domAttribute;
                Node attribute = attributes.item(i);
                if (attribute instanceof IDOMAttr && uri.equals((domAttribute = (IDOMAttr)attribute).getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean hasIdAttribute(IDOMElement element) {
        return element.hasAttribute(ID_ATTR_NAME);
    }

    public static String getIdAttribute(IDOMElement element) {
        if (IdPathUtil.hasIdAttribute(element)) {
            String idValue = element.getAttribute(ID_ATTR_NAME);
            return idValue == null ? null : idValue.trim();
        }
        return null;
    }

    public static String calculateRelativePath(TreePath from, TreePath to) {
        Object lastSegment = to.getLastSegment();
        if (!(lastSegment instanceof IDOMElement)) {
            return null;
        }
        String toLocalId = IdPathUtil.getIdAttribute((IDOMElement)to.getLastSegment());
        if (toLocalId == null || "".equals(toLocalId)) {
            return null;
        }
        ArrayList<String> fromAncestorPath = new ArrayList<String>(IdPathUtil.getAncestorPathFrom(from));
        ArrayList<String> toAncestorPath = new ArrayList<String>(IdPathUtil.getAncestorPathFrom(to.getParentPath()));
        int i = 0;
        int common = 0;
        while (i < fromAncestorPath.size() && i < toAncestorPath.size()) {
            String fromS = (String)fromAncestorPath.get(i);
            String toS = (String)toAncestorPath.get(i);
            if ((toS != null || fromS != null) && (fromS == null || !fromS.equals(toS))) break;
            ++common;
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        if (fromAncestorPath.size() - common > 0) {
            builder.append(':');
            int j = common;
            while (j < fromAncestorPath.size()) {
                builder.append(':');
                ++j;
            }
        }
        boolean foundAny = false;
        if (toAncestorPath.size() - common > 0) {
            int j = common;
            while (j < toAncestorPath.size()) {
                String toS = (String)toAncestorPath.get(j);
                if (toS == null || "".equals(toS)) {
                    return null;
                }
                if (foundAny) {
                    builder.append(':');
                } else {
                    foundAny = true;
                }
                builder.append(toS);
                ++j;
            }
        }
        if (foundAny) {
            builder.append(':');
        }
        builder.append(toLocalId);
        return builder.toString();
    }

    public static List<String> getAncestorPathFrom(TreePath id) {
        ArrayList<String> list = new ArrayList<String>();
        int i = id.getSegmentCount() - 1;
        while (i >= 0) {
            IDOMElement ancestor = (IDOMElement)id.getSegment(i);
            if (IdPathUtil.isContainer(ancestor)) {
                String ancestorId = IdPathUtil.getIdAttribute(ancestor);
                list.add(0, ancestorId);
            }
            --i;
        }
        return Collections.unmodifiableList(list);
    }

    public static TreePath findPath(IDOMElement parent, IDOMElement element) {
        if (parent.equals(element)) {
            return new TreePath(new Object[]{element});
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            TreePath path;
            Node child = children.item(i);
            if (child instanceof IDOMElement && (path = IdPathUtil.findPath((IDOMElement)child, element)) != null) {
                return IdPathUtil.concatenateParentToPath(parent, path);
            }
            ++i;
        }
        return null;
    }

    private static TreePath concatenateParentToPath(IDOMElement parent, TreePath path) {
        Object[] segments = new Object[path.getSegmentCount() + 1];
        segments[0] = parent;
        int i = 0;
        while (i < path.getSegmentCount()) {
            segments[i + 1] = path.getSegment(i);
            ++i;
        }
        return new TreePath(segments);
    }

    public static TreePath findPath(IDOMElement root, String idPath) {
        String id = IdPathUtil.getId(idPath);
        if (id != null) {
            return IdPathUtil.findPathFromId(root, id);
        }
        return null;
    }

    private static TreePath findPathFromId(IDOMElement parent, String id) {
        if (id.equals(IdPathUtil.getIdAttribute(parent))) {
            return new TreePath(new Object[]{parent});
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            TreePath path;
            Node child = children.item(i);
            if (child instanceof IDOMElement && (path = IdPathUtil.findPath((IDOMElement)child, id)) != null) {
                return IdPathUtil.concatenateParentToPath(parent, path);
            }
            ++i;
        }
        return null;
    }

    private static String getId(String idPath) {
        String[] components = idPath.split(":");
        int i = components.length - 1;
        while (i >= 0) {
            String id = components[i];
            if (id != null && !"".equals(id)) {
                return id;
            }
            --i;
        }
        return null;
    }
}

