/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.xml.edit.ui.propeditor.CheckboxPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.swt.widgets.Composite;

public class SpecialValueCheckboxPropertyEditor
extends CheckboxPropertyEditor {
    private final Object _onUncheckedValue;
    private final Object _onCheckedValue;
    private final Class<?> _valueType;

    public SpecialValueCheckboxPropertyEditor(Composite parent, WidgetAdapter widgetAdapter, Object onCheckedValue, Object onUncheckedValue, Class<?> valueType) {
        super(parent, widgetAdapter);
        this._onCheckedValue = onCheckedValue;
        this._onUncheckedValue = onUncheckedValue;
        this._valueType = valueType;
    }

    @Override
    public IObservableValue getObservableValue(int event) {
        IObservableValue base = super.getObservableValue(event);
        return new CheckboxSelectionObservableWrapper(base, this._valueType, this._onCheckedValue, this._onUncheckedValue);
    }

    private static class CheckboxSelectionObservableWrapper
    extends AbstractObservableValue
    implements IValueChangeListener {
        private final IObservableValue _delegate;
        private final Object _onCheckedValue;
        private final Object _onUncheckedValue;
        private final Class<?> _valueType;

        public CheckboxSelectionObservableWrapper(IObservableValue delegate, Class<?> valueType, Object onCheckedValue, Object onUncheckedValue) {
            this._delegate = delegate;
            this._onCheckedValue = onCheckedValue;
            this._onUncheckedValue = onUncheckedValue;
            this._valueType = valueType;
            this._delegate.addValueChangeListener((IValueChangeListener)this);
        }

        protected Object doGetValue() {
            Boolean value = (Boolean)this._delegate.getValue();
            if (value == null || !value.booleanValue()) {
                return this._onUncheckedValue;
            }
            return this._onCheckedValue;
        }

        public Object getValueType() {
            return this._valueType;
        }

        public void handleValueChange(ValueChangeEvent event) {
            Object oldValue = event.diff.getOldValue();
            Object newValue = event.diff.getNewValue();
            oldValue = oldValue == null || (Boolean)oldValue == false ? this._onUncheckedValue : this._onCheckedValue;
            newValue = newValue == null || (Boolean)newValue == false ? this._onUncheckedValue : this._onCheckedValue;
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }

        protected void doSetValue(Object value) {
            if (value == null || value == this._onUncheckedValue || value.equals(this._onUncheckedValue)) {
                this._delegate.setValue((Object)Boolean.FALSE);
            } else {
                this._delegate.setValue((Object)Boolean.TRUE);
            }
        }
    }
}

