/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.viewer.TagAttributeObservbleValue;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeAdapterEStoreEObjectImpl;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreDOMAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.properties.celleditors.CSSStyleDeclarationFactory;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class SelectStyleCreationStrategy
extends AbstractDialogCreationStrategy {
    private final TagAttributeObservbleValue _userModel;
    private IDOMElement _element;

    public SelectStyleCreationStrategy(TagAttributeObservbleValue userModel) {
        this._userModel = userModel;
    }

    @Override
    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    @Override
    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE);
    }

    @Override
    public void openDialog(Control parent, IObservableValue modelObservable) {
        this._element = (IDOMElement)NodeEStoreDOMAdapter.INSTANCE.getBoundObject((NodeAdapterEStoreEObjectImpl)this._userModel.getObserved());
        String tagAttr = this._userModel.getAttribute().getName();
        ICSSStyleDeclaration styleDeclaration = CSSStyleDeclarationFactory.getInstance().getStyleDeclaration(this._element, tagAttr);
        CSSPropertyContext context = new CSSPropertyContext(styleDeclaration);
        StyleDialog dialog = new StyleDialog(parent.getShell(), new PreferenceManager(), this._element, context);
        dialog.open();
        if (dialog.getReturnCode() == 0 && context.isModified()) {
            styleDeclaration = CSSStyleDeclarationFactory.getInstance().getStyleDeclaration(this._element, tagAttr);
            if (styleDeclaration == null) {
                this._element.setAttribute(tagAttr, "");
                styleDeclaration = (ICSSStyleDeclaration)((ElementCSSInlineStyle)this._element).getStyle();
            }
            context.applyModified(styleDeclaration);
        }
    }
}

