/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.SelectionStatusDialog;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class PropertyEditorDialog
extends SelectionStatusDialog {
    protected String title;
    protected Control editingArea;
    protected IObservable modelObservable;
    protected DataBindingContext context;
    protected Binding updateModelBinding;
    protected List<Binding> unsetBindings;
    protected Binding validationBinding;
    protected IValidator validator;

    protected PropertyEditorDialog(Shell parentShell, String title, String instructions, IObservable modelObservable, IValidator validator) {
        super(parentShell);
        this.title = title;
        this.setMessage(instructions);
        this.modelObservable = modelObservable;
        this.validator = validator;
    }

    public PropertyEditorDialog(IShellProvider parentShell, String title, String instructions, IObservable modelObservable, IValidator validator) {
        super(parentShell.getShell());
        this.title = title;
        this.setMessage(instructions);
        this.modelObservable = modelObservable;
        this.validator = validator;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IObservable getModelObservable() {
        return this.modelObservable;
    }

    protected IValidator getValidator() {
        return this.validator;
    }

    @Override
    protected void computeResult() {
        this.performModelBindingUpdate();
    }

    public List<Binding> getUnsetBindings() {
        return this.unsetBindings;
    }

    public void setUnsetBindings(List<Binding> unsetBindings) {
        this.unsetBindings = unsetBindings;
    }

    protected void performModelBindingUpdate() {
        this.updateModelBinding.updateTargetToModel();
        this.triggerUnsetBindings();
    }

    protected void triggerUnsetBindings() {
        if (this.unsetBindings != null) {
            for (Binding binding : this.unsetBindings) {
                if (binding.isDisposed()) {
                    LoggingService.logDebug((Plugin)Activator.getDefault(), (String)("Unset binding " + binding + " has been disposed!"));
                    continue;
                }
                binding.updateTargetToModel();
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.editingArea = this.createEditingArea(composite);
        this.context = new DataBindingContext();
        this.bindData();
        return composite;
    }

    protected IObservableValue getStatusObservableValue() {
        return new WritableValue(Status.OK_STATUS, IStatus.class){

            public void doSetValue(Object value) {
                PropertyEditorDialog.this.updateStatus((IStatus)value);
                super.doSetValue(value);
            }
        };
    }

    protected abstract Control createEditingArea(Composite var1);

    protected abstract void bindData();

    protected abstract void bindOkButton(Button var1);

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.bindOkButton(this.getButton(0));
    }

    public boolean close() {
        if (this.updateModelBinding != null && !this.updateModelBinding.isDisposed()) {
            this.updateModelBinding.dispose();
        }
        if (this.validationBinding != null && !this.validationBinding.isDisposed()) {
            this.validationBinding.dispose();
        }
        return super.close();
    }
}

