/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class PropertyEditor {
    private static final FocusListener _textFocusListener = new TextFocusListener();
    private static final DisposeListener _textFocusDisposeListener = new TextFocusDisposeListener();
    private Control _control = null;
    private WidgetAdapter _widgetAdapter;
    private boolean _mustEditWithDialog;
    private IObservableValue _modelObservable;
    private String _defaultValue;

    protected PropertyEditor(Composite parent, WidgetAdapter widgetAdapter) {
        Assert.isTrue((widgetAdapter != null ? 1 : 0) != 0, (String)"WidgetAdapter cannot be null");
        this._widgetAdapter = widgetAdapter;
        this.adaptParent(parent);
        this.create(parent);
    }

    protected PropertyEditor(Composite parent, WidgetAdapter widgetAdapter, boolean mustEditWithDialog) {
        Assert.isTrue((widgetAdapter != null ? 1 : 0) != 0, (String)"WidgetAdapter cannot be null");
        this._widgetAdapter = widgetAdapter;
        this._mustEditWithDialog = mustEditWithDialog;
        this.adaptParent(parent);
        this.create(parent);
    }

    public void create(Composite parent) {
        Assert.isTrue((this._control == null ? 1 : 0) != 0);
        this._control = this.createControl(parent);
    }

    protected WidgetAdapter getWidgetAdapter() {
        return this._widgetAdapter;
    }

    protected boolean mustEditWithDialog() {
        return this._mustEditWithDialog;
    }

    protected abstract Control createControl(Composite var1);

    protected void adaptParent(Composite parent) {
        this._widgetAdapter.adaptParent(parent);
    }

    public void dispose() {
        if (this._control != null && !this._control.isDisposed()) {
            this._control.dispose();
        }
        this._control = null;
        this._widgetAdapter = null;
    }

    public Control getControl() {
        return this._control;
    }

    public abstract IObservableValue getObservableValue(int var1);

    public Control getBindingControl() {
        return this.getControl();
    }

    public void setFocus() {
        this.doSetFocus();
    }

    protected abstract void doSetFocus();

    public boolean isEnabled() {
        Control control = this.getControl();
        return control == null ? false : control.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        Control control = this.getControl();
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void setModelObservable(IObservableValue modelObservable) {
        this._modelObservable = modelObservable;
    }

    public IObservableValue getModelObservable() {
        return this._modelObservable;
    }

    public void setDefaultValue(String value) {
        this._defaultValue = value;
    }

    protected String getDefaultValue() {
        return this._defaultValue;
    }

    protected void setUpTextFocusListener(Text text) {
        text.addFocusListener(_textFocusListener);
        text.addDisposeListener(_textFocusDisposeListener);
    }

    private static final class TextFocusDisposeListener
    implements DisposeListener {
        private TextFocusDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            if (!e.widget.isDisposed() && e.widget instanceof Text) {
                Text text = (Text)e.widget;
                text.removeFocusListener(_textFocusListener);
                text.removeDisposeListener((DisposeListener)this);
            }
        }
    }

    private static final class TextFocusListener
    implements FocusListener {
        private TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!e.widget.isDisposed() && e.widget instanceof Text) {
                Text text = (Text)e.widget;
                text.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

