/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditorDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MultiLineDialogCreationStrategy
extends AbstractDialogCreationStrategy {
    protected IObservableValue modelValue;
    protected IValidator validator;

    public MultiLineDialogCreationStrategy(IObservableValue modelValue, IValidator validator) {
        this.modelValue = modelValue;
        this.validator = validator;
    }

    @Override
    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    @Override
    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE);
    }

    @Override
    public void openDialog(Control parent, IObservableValue modelObservable) {
        if (modelObservable != null) {
            if (this.modelValue != null && this.modelValue != modelObservable) {
                this.modelValue.dispose();
            }
            this.modelValue = modelObservable;
        }
        MultiLineStringEditDialog dialog = new MultiLineStringEditDialog(parent.getShell(), Messages.MultiLineStringEditDialog, Messages.EnterAValue, this.modelValue, this.validator);
        dialog.open();
    }

    private static class MultiLineStringEditDialog
    extends PropertyEditorDialog {
        public MultiLineStringEditDialog(IShellProvider parentShell, String title, String instructions, IObservableValue modelValue, IValidator validator) {
            super(parentShell, title, instructions, (IObservable)modelValue, validator);
        }

        public MultiLineStringEditDialog(Shell parentShell, String title, String instructions, IObservableValue modelValue, IValidator validator) {
            super(parentShell, title, instructions, (IObservable)modelValue, validator);
        }

        @Override
        public Control createEditingArea(Composite parent) {
            Text text = new Text(parent, 2818);
            GridData data = new GridData(1808);
            data.heightHint = 5 * text.getLineHeight();
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            text.setLayoutData((Object)data);
            return text;
        }

        @Override
        public void bindData() {
            this.context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.editingArea, (int)16), (IObservableValue)this.modelObservable, (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_NEVER), null);
            WritableValue intermediateValue = new WritableValue(null, String.class);
            this.validationBinding = this.context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.editingArea, (int)24), (IObservableValue)intermediateValue, new UpdateValueStrategy().setAfterGetValidator(this.validator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            this.context.bindValue(this.getStatusObservableValue(), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), IStatus.class){

                protected Object calculate() {
                    return MultiLineStringEditDialog.this.validationBinding.getValidationStatus().getValue();
                }
            }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
            this.updateModelBinding = this.context.bindValue((IObservableValue)intermediateValue, (IObservableValue)this.modelObservable, (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy(EMFUpdateValueStrategy.POLICY_NEVER));
        }

        @Override
        protected void bindOkButton(Button button) {
            this.context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)button), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), Boolean.class){

                protected Object calculate() {
                    Object value = MultiLineStringEditDialog.this.validationBinding.getValidationStatus().getValue();
                    if (!(value instanceof IStatus)) {
                        return null;
                    }
                    IStatus status = (IStatus)value;
                    if (!(status.isOK() || status.matches(1) || status.matches(2))) {
                        return false;
                    }
                    return true;
                }
            }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        }
    }
}

