/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.ResourceObservableValue;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.FileChooserDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FileChooserDialogCreationStrategy
extends AbstractDialogCreationStrategy {
    private static final String CURRENT_FILE_VALIDATION_MSG = Messages.FileChooserDialogCreationStrategy_CurrentFileValidationMsg;
    protected IObservableValue _modelValue;
    protected final IProject _iProject;
    protected final IContentType _contentType;
    protected final String _title;
    protected final String _treeLabel;
    protected final boolean _multipleSelection;
    protected final String _validationMsg;
    protected final boolean _allowCurrentFileSelection;
    protected final IFile _currentFile;
    protected final String _currentFileValidationMsg;
    protected final IConverter _toResourceConverter;
    protected final IConverter _toUriConverter;

    public FileChooserDialogCreationStrategy(IObservableValue modelValue, IProject iProject, String contentTypeId, String title, String treeLabel, boolean multipleSelection, String validationMsg, boolean allowCurrentFileSelection, IFile currentFile, String currentFileValidationMsg, IConverter toResourceConverter, IConverter toUriConverter) {
        this._modelValue = modelValue;
        this._iProject = iProject;
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        this._contentType = contentTypeManager.getContentType(contentTypeId);
        this._title = title;
        this._treeLabel = treeLabel;
        this._multipleSelection = multipleSelection;
        this._validationMsg = validationMsg;
        this._allowCurrentFileSelection = allowCurrentFileSelection;
        if (!allowCurrentFileSelection) {
            Assert.isNotNull((Object)currentFile);
        }
        this._currentFile = currentFile;
        this._currentFileValidationMsg = !allowCurrentFileSelection && currentFileValidationMsg == null ? CURRENT_FILE_VALIDATION_MSG : currentFileValidationMsg;
        this._toResourceConverter = toResourceConverter;
        this._toUriConverter = toUriConverter;
    }

    public FileChooserDialogCreationStrategy(IObservableValue modelValue, IProject iProject, String contentTypeId, String title, String treeLabel, boolean multipleSelection, String validationMsg, boolean allowCurrentFileSelection, IFile currentFile, IConverter toResourceConverter, IConverter toUriConverter) {
        this(modelValue, iProject, contentTypeId, title, treeLabel, multipleSelection, validationMsg, allowCurrentFileSelection, currentFile, CURRENT_FILE_VALIDATION_MSG, toResourceConverter, toUriConverter);
    }

    public FileChooserDialogCreationStrategy(IObservableValue modelValue, IProject iProject, String contentTypeId, String title, String treeLabel, boolean multipleSelection, String validationMsg, IConverter toResourceConverter, IConverter toUriConverter) {
        this(modelValue, iProject, contentTypeId, title, treeLabel, multipleSelection, validationMsg, true, null, CURRENT_FILE_VALIDATION_MSG, toResourceConverter, toUriConverter);
    }

    @Override
    public ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter) {
        return this.createToolItem(parent, widgetAdapter, LABEL_PROVIDER);
    }

    @Override
    public Image getToolItemImage() {
        return CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE);
    }

    @Override
    public void openDialog(final Control parent, IObservableValue modelObservable) {
        IShellProvider provider = new IShellProvider(){

            public Shell getShell() {
                return parent.getShell();
            }
        };
        if (modelObservable != null) {
            if (this._modelValue != null && this._modelValue != modelObservable) {
                this._modelValue.dispose();
            }
            this._modelValue = modelObservable;
        }
        FileChooserDialog.FileChooserDialogCreationAdvisor advisor = FileChooserDialog.FileChooserDialogCreationAdvisor.getAdvisor(new DataBindingContext(), this._title, this._treeLabel, this._multipleSelection, this._validationMsg, this._allowCurrentFileSelection, this._currentFile, this._currentFileValidationMsg, this._contentType, this._iProject, new UserDataMediator(this._modelValue, this._toResourceConverter), new IntermediateDataMediator(this._toUriConverter));
        FileChooserDialog dialog = new FileChooserDialog(provider.getShell(), advisor);
        dialog.open();
    }

    private static final class IntermediateDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        private final IConverter _toUriConverter;

        public IntermediateDataMediator(IConverter toUriConverter) {
            super(new ResourceObservableValue(null), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
            this._toUriConverter = toUriConverter;
        }

        @Override
        protected IConverter getTargetUpdateConverter() {
            return this._toUriConverter;
        }
    }

    private static final class UserDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        private final IConverter _toResourceConverter;

        public UserDataMediator(IObservableValue userModel, IConverter toResourceConverter) {
            super(userModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
            this._toResourceConverter = toResourceConverter;
        }

        @Override
        protected IConverter getModelUpdateConverter() {
            return this._toResourceConverter;
        }
    }
}

