/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboPropertyEditor
extends PropertyEditor {
    protected Combo combo;
    protected List<String> items;

    public ComboPropertyEditor(Composite parent, List<String> items, WidgetAdapter widgetAdapter) {
        super(parent, widgetAdapter);
        this.setItems(items);
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void setItems(List<String> items) {
        Assert.isNotNull(items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected void populateComboBoxItems() {
        if (this.combo != null && this.items != null) {
            this.combo.removeAll();
            for (String item : this.items) {
                this.combo.add(item);
            }
        }
    }

    @Override
    protected Control createControl(Composite parent) {
        this.combo = this.getWidgetAdapter().createCombo(parent, 12);
        this.populateComboBoxItems();
        return this.combo;
    }

    @Override
    protected void doSetFocus() {
        this.combo.setFocus();
    }

    @Override
    public IObservableValue getObservableValue(int event) {
        return SWTObservables.observeSelection((Control)this.getBindingControl());
    }
}

