/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextConvertingObservableValue;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboDialogPropertyEditor
extends AbstractDialogPropertyEditor {
    protected Combo combo;
    protected List<String> items;

    public ComboDialogPropertyEditor(Composite parent, List<DialogCreationStrategy> strategies, WidgetAdapter widgetAdapter, List<String> items) {
        super(parent, strategies, widgetAdapter);
        this.setItems(items);
        this.createDialogButtons();
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void setItems(List<String> items) {
        Assert.isNotNull(items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.combo != null && this.items != null) {
            this.combo.removeAll();
            for (String item : this.items) {
                this.combo.add(item);
            }
        }
    }

    @Override
    public Control getBindingControl() {
        return this.combo;
    }

    @Override
    protected Control createBindingControl(Composite parent, int style) {
        this.combo = this.getWidgetAdapter().createCombo(parent, 4);
        this.populateComboBoxItems();
        return this.combo;
    }

    @Override
    public IObservableValue getObservableValue(int event) {
        return new ComboDefaultingConvertingObservableValue((IObservableValue)SWTObservables.observeText((Control)this.getBindingControl()));
    }

    @Override
    protected void doSetFocus() {
        this.combo.setFocus();
    }

    private final class ComboDefaultingConvertingObservableValue
    extends TextConvertingObservableValue {
        public ComboDefaultingConvertingObservableValue(IObservableValue delegate) {
            super(delegate);
        }

        @Override
        protected Object doConvertGetValue(Object value) {
            Object convertedValue = super.doConvertGetValue(value);
            if (convertedValue == null && ComboDialogPropertyEditor.this.getDefaultValue() != null) {
                ComboDialogPropertyEditor.this.combo.setText(ComboDialogPropertyEditor.this.getDefaultValue());
            }
            return convertedValue;
        }
    }
}

