/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BooleanDialogPropertyEditor
extends AbstractDialogPropertyEditor {
    private Composite composite;
    private Composite checkboxComposite;
    private Button checkbox;
    private ToolBar checkboxToolBar;
    private Composite textButtonComposite;
    private Text text;
    private ToolBar textToolBar;
    private Label textButtonPlaceholder;
    private Control currentControl;
    private ToolBar currentToolBar;

    public BooleanDialogPropertyEditor(Composite parent, List<DialogCreationStrategy> strategies, WidgetAdapter widgetAdapter) {
        super(parent, strategies, widgetAdapter, false);
    }

    @Override
    protected Control createBindingControl(Composite parent, int style) {
        this.composite = this.getWidgetAdapter().createComposite(parent, style);
        StackLayout layout = new StackLayout();
        this.composite.setLayout((Layout)layout);
        this.checkboxComposite = this.getWidgetAdapter().createComposite(this.composite);
        GridLayout checkboxLayout = new GridLayout(2, false);
        checkboxLayout.marginHeight = 0;
        checkboxLayout.verticalSpacing = 0;
        checkboxLayout.marginWidth = 0;
        checkboxLayout.horizontalSpacing = 0;
        this.checkboxComposite.setLayout((Layout)checkboxLayout);
        this.checkbox = this.getWidgetAdapter().createButton(this.checkboxComposite, null, 32);
        this.checkbox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.text = this.getWidgetAdapter().createText(this.composite, null, style);
        this.setUpTextFocusListener(this.text);
        this.currentControl = this.checkbox;
        layout.topControl = this.checkboxComposite;
        return this.composite;
    }

    @Override
    protected void createDialogButtons() {
        Control parent = this.getControl();
        this.textButtonComposite = this.getWidgetAdapter().createComposite((Composite)parent);
        StackLayout textButtonLayout = new StackLayout();
        this.textButtonComposite.setLayout((Layout)textButtonLayout);
        this.textButtonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.textButtonPlaceholder = this.getWidgetAdapter().createLabel(this.textButtonComposite, null);
        this.textToolBar = this.getWidgetAdapter().createToolBar(this.textButtonComposite, 0x800000);
        GridLayout textToolBarLayout = new GridLayout(this.strategies.size(), true);
        textToolBarLayout.marginHeight = 1;
        textToolBarLayout.verticalSpacing = 1;
        textToolBarLayout.marginWidth = 1;
        textToolBarLayout.horizontalSpacing = 1;
        this.textToolBar.setLayout((Layout)textToolBarLayout);
        textButtonLayout.topControl = this.textToolBar;
        for (final DialogCreationStrategy strategy : this.strategies) {
            ToolItem toolItem = strategy.createToolItem(this.textToolBar, this.getWidgetAdapter());
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    strategy.openDialog((Control)BooleanDialogPropertyEditor.this.textButtonComposite, BooleanDialogPropertyEditor.this.getModelObservable());
                }
            });
        }
        this.checkboxToolBar = this.getWidgetAdapter().createToolBar(this.checkboxComposite, 0x800000);
        GridLayout layout = new GridLayout(this.strategies.size(), true);
        layout.marginHeight = 1;
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        this.checkboxToolBar.setLayout((Layout)layout);
        this.checkboxToolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        for (final DialogCreationStrategy strategy : this.strategies) {
            ToolItem toolItem = strategy.createToolItem(this.checkboxToolBar, this.getWidgetAdapter());
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    strategy.openDialog((Control)BooleanDialogPropertyEditor.this.checkboxComposite, BooleanDialogPropertyEditor.this.getModelObservable());
                }
            });
        }
        this.currentToolBar = this.checkboxToolBar;
    }

    @Override
    protected ToolBar getToolBar() {
        return this.currentToolBar;
    }

    @Override
    public Control getBindingControl() {
        return this.currentControl;
    }

    @Override
    protected void doSetFocus() {
        this.getBindingControl().setFocus();
    }

    @Override
    public IObservableValue getObservableValue(int event) {
        return new BooleanObservableValue(this.checkbox, this.text);
    }

    private class BooleanObservableValue
    extends WritableValue
    implements FocusListener,
    SelectionListener {
        public BooleanObservableValue(Button checkbox, Text text) {
            super(null, Boolean.class);
            text.addFocusListener((FocusListener)this);
            checkbox.addSelectionListener((SelectionListener)this);
        }

        public Object doGetValue() {
            Object value = super.doGetValue();
            if (value instanceof String && "".equals(((String)value).trim())) {
                return null;
            }
            return value;
        }

        public void doSetValue(Object value) {
            if (value instanceof String && "".equals(((String)value).trim())) {
                value = null;
            }
            if (value == null) {
                this.setCheckboxVisible();
                if (BooleanDialogPropertyEditor.this.getDefaultValue() != null) {
                    boolean selected = false;
                    if (Boolean.TRUE.toString().equalsIgnoreCase(BooleanDialogPropertyEditor.this.getDefaultValue())) {
                        selected = true;
                    }
                    BooleanDialogPropertyEditor.this.checkbox.setSelection(selected);
                } else {
                    BooleanDialogPropertyEditor.this.checkbox.setSelection(false);
                }
            } else if (value instanceof String) {
                String stringValue = ((String)value).trim();
                if (stringValue.length() == 0 || stringValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    this.setCheckboxVisible();
                    BooleanDialogPropertyEditor.this.checkbox.setSelection(false);
                } else if (stringValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    this.setCheckboxVisible();
                    BooleanDialogPropertyEditor.this.checkbox.setSelection(true);
                } else {
                    this.setTextVisible();
                    BooleanDialogPropertyEditor.this.text.setText(stringValue);
                }
            } else if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                this.setCheckboxVisible();
                BooleanDialogPropertyEditor.this.checkbox.setSelection(booleanValue.booleanValue());
            }
            BooleanDialogPropertyEditor.this.composite.layout();
            BooleanDialogPropertyEditor.this.textButtonComposite.layout();
            super.doSetValue(value);
        }

        private void setCheckboxVisible() {
            BooleanDialogPropertyEditor.this.currentControl = (Control)BooleanDialogPropertyEditor.this.checkbox;
            BooleanDialogPropertyEditor.this.currentToolBar = BooleanDialogPropertyEditor.this.checkboxToolBar;
            ((StackLayout)((BooleanDialogPropertyEditor)BooleanDialogPropertyEditor.this).composite.getLayout()).topControl = BooleanDialogPropertyEditor.this.checkboxComposite;
            ((StackLayout)((BooleanDialogPropertyEditor)BooleanDialogPropertyEditor.this).textButtonComposite.getLayout()).topControl = BooleanDialogPropertyEditor.this.textButtonPlaceholder;
        }

        private void setTextVisible() {
            BooleanDialogPropertyEditor.this.currentControl = (Control)BooleanDialogPropertyEditor.this.text;
            BooleanDialogPropertyEditor.this.currentToolBar = BooleanDialogPropertyEditor.this.textToolBar;
            ((StackLayout)((BooleanDialogPropertyEditor)BooleanDialogPropertyEditor.this).composite.getLayout()).topControl = BooleanDialogPropertyEditor.this.text;
            ((StackLayout)((BooleanDialogPropertyEditor)BooleanDialogPropertyEditor.this).textButtonComposite.getLayout()).topControl = BooleanDialogPropertyEditor.this.textToolBar;
        }

        public void widgetSelected(SelectionEvent e) {
            super.doSetValue((Object)BooleanDialogPropertyEditor.this.checkbox.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            String textValue = BooleanDialogPropertyEditor.this.text.getText();
            if (textValue != null) {
                textValue = textValue.trim();
            }
            this.doSetValue(textValue);
        }
    }
}

