/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractDialogPropertyEditor
extends PropertyEditor {
    protected List<DialogCreationStrategy> strategies;
    protected ToolBar toolBar;

    protected AbstractDialogPropertyEditor(Composite parent, List<DialogCreationStrategy> strategies, WidgetAdapter widgetAdapter, boolean mustEditWithDialog) {
        super(parent, widgetAdapter, mustEditWithDialog);
        this.setDialogCreationStrategies(strategies);
        this.createDialogButtons();
    }

    protected AbstractDialogPropertyEditor(Composite parent, List<DialogCreationStrategy> strategies, WidgetAdapter widgetAdapter) {
        super(parent, widgetAdapter, false);
        this.setDialogCreationStrategies(strategies);
    }

    public void setDialogCreationStrategies(List<DialogCreationStrategy> strategies) {
        Assert.isTrue((strategies != null ? 1 : 0) != 0, (String)"strategies cannot be null");
        Assert.isTrue((strategies.size() > 0 ? 1 : 0) != 0, (String)"must be at least one strategy");
        this.strategies = Collections.unmodifiableList(strategies);
    }

    public List<DialogCreationStrategy> getDialogCreationStrategies() {
        return this.strategies;
    }

    @Override
    public abstract Control getBindingControl();

    @Override
    protected Control createControl(Composite parent) {
        Composite editor = this.getWidgetAdapter().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        editor.setLayout((Layout)layout);
        int style = 4;
        if (this.mustEditWithDialog()) {
            style |= 8;
        }
        Control bindingControl = this.createBindingControl(editor, style);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 100;
        bindingControl.setLayoutData((Object)gridData);
        return editor;
    }

    protected abstract Control createBindingControl(Composite var1, int var2);

    protected void createDialogButtons() {
        final Control parent = this.getControl();
        if (parent == null) {
            return;
        }
        this.toolBar = this.getWidgetAdapter().createToolBar((Composite)parent, 0x800000);
        GridLayout layout = new GridLayout(this.strategies.size(), true);
        layout.marginHeight = 1;
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        this.toolBar.setLayout((Layout)layout);
        this.toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        for (final DialogCreationStrategy strategy : this.strategies) {
            ToolItem toolItem = strategy.createToolItem(this.toolBar, this.getWidgetAdapter());
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    strategy.openDialog(parent, AbstractDialogPropertyEditor.this.getModelObservable());
                }
            });
        }
    }

    @Override
    public abstract IObservableValue getObservableValue(int var1);

    @Override
    public boolean isEnabled() {
        Control control = this.getBindingControl();
        return control == null ? false : control.isEnabled();
    }

    protected ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Control control = this.getBindingControl();
        if (control != null) {
            control.setEnabled(enabled);
        }
        ToolItem[] toolItemArray = this.getToolBar().getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if (this.canBeEnabled(enabled, toolItem)) {
                toolItem.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private boolean canBeEnabled(boolean enabled, ToolItem toolItem) {
        if (!enabled) {
            return true;
        }
        boolean disabledByDesign = "TRUE".equals(toolItem.getData("oracle.eclipse.tools.xml.edit.ui.isWidgetDisabled"));
        return !disabledByDesign;
    }
}

