/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogButtonLabelProvider;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.IDialogButtonLabelProvider;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractDialogCreationStrategy
implements DialogCreationStrategy {
    public static final String CUSTOM_EDIT_TOOL_TIP = Messages.SelectAValue;
    public static final String EDIT_BUTTON_TEXT = Messages.Edit;
    public static final IDialogButtonLabelProvider LABEL_PROVIDER = new DialogButtonLabelProvider();

    protected ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter, IDialogButtonLabelProvider labelProvider) {
        String toolTip;
        ToolItem toolItem = widgetAdapter.createToolItem(parent, 8);
        Image image = labelProvider.getImage(this);
        if (image == null) {
            String text = labelProvider.getText(this);
            if (text != null) {
                toolItem.setText(text);
            }
        } else {
            toolItem.setImage(image);
        }
        if ((toolTip = labelProvider.getToolTipText(this)) != null) {
            toolItem.setToolTipText(toolTip);
        }
        return toolItem;
    }

    @Override
    public String getToolItemText() {
        return EDIT_BUTTON_TEXT;
    }

    @Override
    public String getToolTipText() {
        return CUSTOM_EDIT_TOOL_TIP;
    }

    protected Image getButtonImageFromRegistry(String buttonImageId) {
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        return registry.get(buttonImageId);
    }
}

