/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.propeditor;

import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.xml.edit.ui.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.AbstractDialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.IDialogButtonLabelProvider;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractBindDialogCreationStrategy
extends AbstractDialogCreationStrategy {
    public static final String IS_WIDGET_DISABLED = "oracle.eclipse.tools.xml.edit.ui.isWidgetDisabled";
    public static final String WIDGET_DISABLED = "TRUE";
    private String _validationMessage = Messages.AbstractBindDialogCreationStrategy_OkValidationMessage;

    @Override
    public final String getToolTipText() {
        if (this.isValid()) {
            return this.doGetToolTipText();
        }
        return this.getValidationMessage();
    }

    public abstract String doGetToolTipText();

    public abstract IDocument getBaseDocument();

    public boolean isValid() {
        boolean valid = this.getBaseDocument() != null;
        this._validationMessage = valid ? Messages.AbstractBindDialogCreationStrategy_OkValidationMessage : Messages.AbstractBindDialogCreationStrategy_InvalidDocumentValidationMessage;
        return valid;
    }

    public String getValidationMessage() {
        return this._validationMessage;
    }

    @Override
    public void openDialog(Control parent, IObservableValue modelObservable) {
        if (!this.isValid()) {
            DialogService.showErrorDialog((String)this.getValidationMessage());
            return;
        }
        Dialog dialog = this.getDialog(parent, modelObservable);
        Assert.isNotNull((Object)dialog, (String)"Could not create dialog");
        dialog.open();
    }

    protected abstract Dialog getDialog(Control var1, IObservableValue var2);

    @Override
    protected ToolItem createToolItem(ToolBar parent, WidgetAdapter widgetAdapter, IDialogButtonLabelProvider labelProvider) {
        ToolItem toolItem = super.createToolItem(parent, widgetAdapter, labelProvider);
        if (!this.isValid()) {
            toolItem.setEnabled(false);
            toolItem.setData(IS_WIDGET_DISABLED, (Object)WIDGET_DISABLED);
        }
        return toolItem;
    }
}

