/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValRefFilterType implements Enumerator
{
    STRING(0, "STRING", "string"),
    NUMERIC(1, "NUMERIC", "numeric"),
    STRING_NUMERIC(2, "STRING_NUMERIC", "string-numeric"),
    DATE(3, "DATE", "date"),
    BOOLEAN(4, "BOOLEAN", "boolean"),
    ENUMERABLE(5, "ENUMERABLE", "enumerable");

    public static final int STRING_VALUE = 0;
    public static final int NUMERIC_VALUE = 1;
    public static final int STRING_NUMERIC_VALUE = 2;
    public static final int DATE_VALUE = 3;
    public static final int BOOLEAN_VALUE = 4;
    public static final int ENUMERABLE_VALUE = 5;
    private static final ValRefFilterType[] VALUES_ARRAY;
    public static final List<ValRefFilterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValRefFilterType[]{STRING, NUMERIC, STRING_NUMERIC, DATE, BOOLEAN, ENUMERABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValRefFilterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValRefFilterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValRefFilterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValRefFilterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValRefFilterType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return NUMERIC;
            }
            case 2: {
                return STRING_NUMERIC;
            }
            case 3: {
                return DATE;
            }
            case 4: {
                return BOOLEAN;
            }
            case 5: {
                return ENUMERABLE;
            }
        }
        return null;
    }

    private ValRefFilterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

