/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DialogTypeKind implements Enumerator
{
    INSERT_MODIFY(2, "INSERT_MODIFY", "insert-modify"),
    INSERT(0, "INSERT", "insert"),
    MODIFY(1, "MODIFY", "modify");

    public static final int INSERT_MODIFY_VALUE = 2;
    public static final int INSERT_VALUE = 0;
    public static final int MODIFY_VALUE = 1;
    private static final DialogTypeKind[] VALUES_ARRAY;
    public static final List<DialogTypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DialogTypeKind[]{INSERT_MODIFY, INSERT, MODIFY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DialogTypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DialogTypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DialogTypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DialogTypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DialogTypeKind get(int value) {
        switch (value) {
            case 2: {
                return INSERT_MODIFY;
            }
            case 0: {
                return INSERT;
            }
            case 1: {
                return MODIFY;
            }
        }
        return null;
    }

    private DialogTypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public boolean matches(DialogTypeKind dialogTypeKind) {
        switch (dialogTypeKind.getValue()) {
            case 0: {
                return this.value == 0 || this.value == 2;
            }
            case 1: {
                return this.value == 1 || this.value == 2;
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException("One of the cases above must be true unless the enum has changed out of sync");
    }
}

