/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.metamodel.tagedit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DialogOverrideOption implements Enumerator
{
    DEFAULT(0, "default", "default"),
    OVERRIDE(1, "override", "override"),
    SUPPRESS(2, "suppress", "suppress");

    public static final int DEFAULT_VALUE = 0;
    public static final int OVERRIDE_VALUE = 1;
    public static final int SUPPRESS_VALUE = 2;
    private static final DialogOverrideOption[] VALUES_ARRAY;
    public static final List<DialogOverrideOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DialogOverrideOption[]{DEFAULT, OVERRIDE, SUPPRESS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DialogOverrideOption get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DialogOverrideOption result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DialogOverrideOption getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DialogOverrideOption result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DialogOverrideOption get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return OVERRIDE;
            }
            case 2: {
                return SUPPRESS;
            }
        }
        return null;
    }

    private DialogOverrideOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

